/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Vertex;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.IndexHits;

public class Neo4j2VertexIterable<T extends Vertex>
implements CloseableIterable<Neo4j2Vertex> {
    private final Iterable<Node> nodes;
    private final Neo4j2Graph graph;
    private final boolean checkTransaction;

    public Neo4j2VertexIterable(Iterable<Node> nodes, Neo4j2Graph graph, boolean checkTransaction) {
        this.graph = graph;
        this.nodes = nodes;
        this.checkTransaction = checkTransaction;
    }

    public Neo4j2VertexIterable(Iterable<Node> nodes, Neo4j2Graph graph) {
        this(nodes, graph, false);
    }

    public Iterator<Neo4j2Vertex> iterator() {
        return new Iterator<Neo4j2Vertex>(){
            private final Iterator<Node> itty;
            private Node nextNode;
            {
                this.itty = Neo4j2VertexIterable.this.nodes.iterator();
                this.nextNode = null;
            }

            @Override
            public void remove() {
                this.itty.remove();
            }

            @Override
            public Neo4j2Vertex next() {
                Neo4j2VertexIterable.this.graph.autoStartTransaction(false);
                if (!Neo4j2VertexIterable.this.checkTransaction) {
                    return new Neo4j2Vertex(this.itty.next(), Neo4j2VertexIterable.this.graph);
                }
                if (null != this.nextNode) {
                    Node temp = this.nextNode;
                    this.nextNode = null;
                    return new Neo4j2Vertex(temp, Neo4j2VertexIterable.this.graph);
                }
                while (true) {
                    Node node = this.itty.next();
                    try {
                        if (Neo4j2VertexIterable.this.graph.nodeIsDeleted(node.getId())) continue;
                        return new Neo4j2Vertex(node, Neo4j2VertexIterable.this.graph);
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                Neo4j2VertexIterable.this.graph.autoStartTransaction(false);
                if (!Neo4j2VertexIterable.this.checkTransaction) {
                    return this.itty.hasNext();
                }
                if (null != this.nextNode) {
                    return true;
                }
                while (this.itty.hasNext()) {
                    Node node = this.itty.next();
                    try {
                        if (Neo4j2VertexIterable.this.graph.nodeIsDeleted(node.getId())) continue;
                        this.nextNode = node;
                        return true;
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                return false;
            }
        };
    }

    public void close() {
        if (this.nodes instanceof IndexHits) {
            ((IndexHits)this.nodes).close();
        }
    }
}

