/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2.batch;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchElement;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchGraph;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.util.Map;

class Neo4j2BatchEdge
extends Neo4j2BatchElement
implements Edge {
    private final String label;

    public Neo4j2BatchEdge(Neo4j2BatchGraph graph, Long id, String label) {
        super(graph, id);
        this.label = label;
    }

    public <T> T removeProperty(String key) {
        Map<String, Object> properties = this.getPropertyMapClone();
        Object value = properties.remove(key);
        this.graph.getRawGraph().setRelationshipProperties(this.id.longValue(), properties);
        return (T)value;
    }

    public void setProperty(String key, Object value) {
        if (key.isEmpty()) {
            throw ExceptionFactory.propertyKeyCanNotBeEmpty();
        }
        if (key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (key.equals("label")) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        Map<String, Object> properties = this.getPropertyMapClone();
        properties.put(key, value);
        this.graph.getRawGraph().setRelationshipProperties(this.id.longValue(), properties);
    }

    @Override
    public Map<String, Object> getPropertyMap() {
        return this.graph.getRawGraph().getRelationshipProperties(this.id.longValue());
    }

    public Vertex getVertex(Direction direction) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "e[" + this.id + "][?-" + this.label + "->?]";
    }
}

