/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2.batch;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchEdge;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchIndex;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.tooling.GlobalGraphOperations;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndexProvider;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class Neo4j2BatchGraph
implements KeyIndexableGraph,
IndexableGraph,
MetaGraph<BatchInserter> {
    private final BatchInserter rawGraph;
    private final BatchInserterIndexProvider indexProvider;
    private final Map<String, Neo4j2BatchIndex<? extends Element>> indices = new HashMap<String, Neo4j2BatchIndex<? extends Element>>();
    private Long idCounter = 0L;
    protected final Set<String> vertexIndexKeys = new HashSet<String>();
    protected final Set<String> edgeIndexKeys = new HashSet<String>();
    private static final Features FEATURES = new Features();
    private static final String INDEXED_KEYS_POSTFIX = ":indexed_keys";

    public Neo4j2BatchGraph(String directory) {
        this.rawGraph = BatchInserters.inserter((String)directory);
        this.indexProvider = new LuceneBatchInserterIndexProvider(this.rawGraph);
    }

    public Neo4j2BatchGraph(String directory, Map<String, String> parameters) {
        this.rawGraph = null == parameters ? BatchInserters.inserter((String)directory) : BatchInserters.inserter((String)directory, parameters);
        this.indexProvider = new LuceneBatchInserterIndexProvider(this.rawGraph);
    }

    public Neo4j2BatchGraph(BatchInserter rawGraph, BatchInserterIndexProvider indexProvider) {
        this.rawGraph = rawGraph;
        this.indexProvider = indexProvider;
    }

    public void shutdown() {
        this.flushIndices();
        this.indexProvider.shutdown();
        this.rawGraph.shutdown();
        this.removeReferenceNodeAndFinalizeKeyIndices();
    }

    public void flushIndices() {
        for (Neo4j2BatchIndex<? extends Element> index : this.indices.values()) {
            index.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReferenceNodeAndFinalizeKeyIndices() {
        GraphDatabaseService rawGraphDB = null;
        try {
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.rawGraph.getStoreDir());
            if (this.vertexIndexKeys.size() > 0) {
                builder.setConfig(GraphDatabaseSettings.node_keys_indexable, this.vertexIndexKeys.toString().replace("[", "").replace("]", "")).setConfig(GraphDatabaseSettings.node_auto_indexing, "true");
            }
            if (this.edgeIndexKeys.size() > 0) {
                builder.setConfig(GraphDatabaseSettings.relationship_keys_indexable, this.edgeIndexKeys.toString().replace("[", "").replace("]", "")).setConfig(GraphDatabaseSettings.relationship_auto_indexing, "true");
            }
            rawGraphDB = builder.newGraphDatabase();
            Transaction tx = rawGraphDB.beginTx();
            try {
                GlobalGraphOperations graphOperations = GlobalGraphOperations.at((GraphDatabaseService)rawGraphDB);
                if (this.vertexIndexKeys.size() > 0) {
                    Neo4j2BatchGraph.populateKeyIndices(rawGraphDB, rawGraphDB.index().getNodeAutoIndexer(), graphOperations.getAllNodes(), Vertex.class);
                }
                if (this.edgeIndexKeys.size() > 0) {
                    Neo4j2BatchGraph.populateKeyIndices(rawGraphDB, rawGraphDB.index().getRelationshipAutoIndexer(), graphOperations.getAllRelationships(), Edge.class);
                }
                tx.success();
            }
            finally {
                tx.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (rawGraphDB != null) {
                rawGraphDB.shutdown();
            }
        }
    }

    private static <T extends PropertyContainer> void populateKeyIndices(GraphDatabaseService rawGraphDB, AutoIndexer<T> rawAutoIndexer, Iterable<T> rawElements, Class elementClass) {
        if (!rawAutoIndexer.isEnabled()) {
            return;
        }
        Set properties = rawAutoIndexer.getAutoIndexedProperties();
        Transaction tx = rawGraphDB.beginTx();
        GraphPropertiesImpl kernel = ((NodeManager)((GraphDatabaseAPI)rawGraphDB).getDependencyResolver().resolveDependency(NodeManager.class)).getGraphProperties();
        kernel.setProperty(elementClass.getSimpleName() + INDEXED_KEYS_POSTFIX, (Object)properties.toArray(new String[properties.size()]));
        int count = 0;
        for (PropertyContainer pc : rawElements) {
            for (String property : properties) {
                if (!pc.hasProperty(property)) continue;
                pc.setProperty(property, pc.getProperty(property));
                if (++count < 10000) continue;
                count = 0;
                tx.success();
                tx.finish();
                tx = rawGraphDB.beginTx();
            }
        }
        tx.success();
        tx.finish();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.toString());
    }

    public BatchInserter getRawGraph() {
        return this.rawGraph;
    }

    public Vertex addVertex(Object id) {
        Long finalId;
        Map<Object, Object> finalProperties = new HashMap();
        if (null == id) {
            Neo4j2BatchGraph neo4j2BatchGraph = this;
            neo4j2BatchGraph.idCounter = neo4j2BatchGraph.idCounter + 1L;
            this.rawGraph.createNode(neo4j2BatchGraph.idCounter.longValue(), finalProperties, new Label[0]);
            finalId = this.idCounter;
        } else if (id instanceof Long) {
            this.rawGraph.createNode(((Long)id).longValue(), finalProperties, new Label[0]);
            finalId = (Long)id;
        } else if (id instanceof Map) {
            finalProperties = this.makePropertyMap((Map)id);
            Long providedId = (Long)((Map)id).get("_id");
            finalProperties.remove("_id");
            if (providedId == null) {
                finalId = this.rawGraph.createNode(finalProperties, new Label[0]);
            } else {
                this.rawGraph.createNode(providedId.longValue(), finalProperties, new Label[0]);
                finalId = providedId;
            }
        } else {
            try {
                finalId = Double.valueOf(id.toString()).longValue();
                this.rawGraph.createNode(finalId.longValue(), finalProperties, new Label[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The provided object must be null, a long id, an object convertible to long, or a Map<String,Object>");
            }
        }
        return new Neo4j2BatchVertex(this, finalId);
    }

    public Vertex getVertex(Object id) {
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        try {
            Long longId = id instanceof Long ? (Long)id : Long.valueOf(Double.valueOf(id.toString()).longValue());
            if (this.rawGraph.nodeExists(longId.longValue())) {
                return new Neo4j2BatchVertex(this, longId);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Iterable<Vertex> getVertices() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Vertex> getVertices(String key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeVertex(Vertex vertex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        Map<Object, Object> finalProperties = id == null || !(id instanceof Map) ? new HashMap() : this.makePropertyMap((Map)id);
        Long finalId = this.rawGraph.createRelationship(((Long)outVertex.getId()).longValue(), ((Long)inVertex.getId()).longValue(), (RelationshipType)DynamicRelationshipType.withName((String)label), finalProperties);
        return new Neo4j2BatchEdge(this, finalId, label);
    }

    public Edge getEdge(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Edge> getEdges() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Edge> getEdges(String key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(Edge edge) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        return this.indices.get(indexName);
    }

    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        Map<String, String> map = Neo4j2BatchGraph.generateParameterMap(indexParameters);
        if (indexParameters.length == 0) {
            map.put("type", "exact");
        }
        Neo4j2BatchIndex<T> index = Vertex.class.isAssignableFrom(indexClass) ? new Neo4j2BatchIndex<T>(this, this.indexProvider.nodeIndex(indexName, map), indexName, indexClass) : new Neo4j2BatchIndex<T>(this, this.indexProvider.relationshipIndex(indexName, map), indexName, indexClass);
        this.indices.put(indexName, index);
        return index;
    }

    public Iterable<Index<? extends Element>> getIndices() {
        return this.indices.values();
    }

    public void dropIndex(String indexName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    private Map<String, Object> makePropertyMap(Map<String, Object> map) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("_id")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndexKeys.remove(key);
        } else {
            this.edgeIndexKeys.remove(key);
        }
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndexKeys.add(key);
        } else {
            this.edgeIndexKeys.add(key);
        }
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.vertexIndexKeys;
        }
        return this.edgeIndexKeys;
    }

    private static Map<String, String> generateParameterMap(Parameter<Object, Object> ... indexParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter<Object, Object> parameter : indexParameters) {
            map.put(parameter.getKey().toString(), parameter.getValue().toString());
        }
        return map;
    }

    public Features getFeatures() {
        return FEATURES;
    }

    public GraphQuery query() {
        throw new UnsupportedOperationException();
    }

    static {
        Neo4j2BatchGraph.FEATURES.supportsSerializableObjectProperty = false;
        Neo4j2BatchGraph.FEATURES.supportsBooleanProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsDoubleProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsFloatProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsIntegerProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsPrimitiveArrayProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsUniformListProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsMixedListProperty = false;
        Neo4j2BatchGraph.FEATURES.supportsLongProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsMapProperty = false;
        Neo4j2BatchGraph.FEATURES.supportsStringProperty = true;
        Neo4j2BatchGraph.FEATURES.supportsDuplicateEdges = true;
        Neo4j2BatchGraph.FEATURES.supportsSelfLoops = true;
        Neo4j2BatchGraph.FEATURES.isPersistent = true;
        Neo4j2BatchGraph.FEATURES.isWrapper = false;
        Neo4j2BatchGraph.FEATURES.supportsVertexIteration = false;
        Neo4j2BatchGraph.FEATURES.supportsEdgeIteration = false;
        Neo4j2BatchGraph.FEATURES.supportsVertexIndex = true;
        Neo4j2BatchGraph.FEATURES.supportsEdgeIndex = true;
        Neo4j2BatchGraph.FEATURES.ignoresSuppliedIds = false;
        Neo4j2BatchGraph.FEATURES.supportsTransactions = false;
        Neo4j2BatchGraph.FEATURES.supportsIndices = true;
        Neo4j2BatchGraph.FEATURES.supportsKeyIndices = true;
        Neo4j2BatchGraph.FEATURES.supportsVertexKeyIndex = true;
        Neo4j2BatchGraph.FEATURES.supportsEdgeKeyIndex = true;
        Neo4j2BatchGraph.FEATURES.supportsEdgeRetrieval = true;
        Neo4j2BatchGraph.FEATURES.supportsVertexProperties = true;
        Neo4j2BatchGraph.FEATURES.supportsEdgeProperties = true;
        Neo4j2BatchGraph.FEATURES.supportsThreadedTransactions = false;
        Neo4j2BatchGraph.FEATURES.supportsThreadIsolatedTransactions = false;
    }
}

