/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2.batch;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchEdgeIterable;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchGraph;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchVertexIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.HashMap;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;

class Neo4j2BatchIndex<T extends Element>
implements Index<T> {
    private final Neo4j2BatchGraph graph;
    protected final BatchInserterIndex rawIndex;
    private final String name;
    private final Class<T> indexClass;

    public Neo4j2BatchIndex(Neo4j2BatchGraph graph, BatchInserterIndex index, String name, Class<T> indexClass) {
        this.graph = graph;
        this.rawIndex = index;
        this.name = name;
        this.indexClass = indexClass;
    }

    public void put(String key, Object value, T element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.rawIndex.add(((Long)element.getId()).longValue(), map);
    }

    public CloseableIterable<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.indexClass)) {
            return new Neo4j2BatchVertexIterable(this.graph, (IndexHits<Long>)this.rawIndex.get(key, value));
        }
        return new Neo4j2BatchEdgeIterable(this.graph, (IndexHits<Long>)this.rawIndex.get(key, value));
    }

    public CloseableIterable<T> query(String key, Object query) {
        if (Vertex.class.isAssignableFrom(this.indexClass)) {
            return new Neo4j2BatchVertexIterable(this.graph, (IndexHits<Long>)this.rawIndex.query(key, query));
        }
        return new Neo4j2BatchEdgeIterable(this.graph, (IndexHits<Long>)this.rawIndex.query(key, query));
    }

    public long count(String key, Object value) {
        long count = 0L;
        for (Element t : this.get(key, value)) {
            ++count;
        }
        return count;
    }

    public void remove(String key, Object value, T element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    public String getIndexName() {
        return this.name;
    }

    public void flush() {
        this.rawIndex.flush();
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }
}

