/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2.batch;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchElement;
import com.tinkerpop.blueprints.impls.neo4j2.batch.Neo4j2BatchGraph;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.Map;

class Neo4j2BatchVertex
extends Neo4j2BatchElement
implements Vertex {
    public Neo4j2BatchVertex(Neo4j2BatchGraph graph, Long id) {
        super(graph, id);
    }

    public <T> T removeProperty(String key) {
        Map<String, Object> properties = this.getPropertyMapClone();
        Object value = properties.remove(key);
        this.graph.getRawGraph().setNodeProperties(this.id.longValue(), properties);
        return (T)value;
    }

    public void setProperty(String key, Object value) {
        if (key.isEmpty()) {
            throw ExceptionFactory.propertyKeyCanNotBeEmpty();
        }
        if (key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        Map<String, Object> properties = this.getPropertyMapClone();
        properties.put(key, value);
        this.graph.getRawGraph().setNodeProperties(this.id.longValue(), properties);
    }

    public Iterable<Edge> getEdges(Direction direction, String ... labels) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Edge addEdge(String label, Vertex vertex) {
        return this.graph.addEdge(null, this, vertex, label);
    }

    public VertexQuery query() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getPropertyMap() {
        return this.graph.getRawGraph().getNodeProperties(this.id.longValue());
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }
}

