/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4jbatch;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4jbatch.Neo4jBatchElement;
import com.tinkerpop.blueprints.impls.neo4jbatch.Neo4jBatchGraph;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.util.Map;

class Neo4jBatchEdge
extends Neo4jBatchElement
implements Edge {
    private final String label;

    public Neo4jBatchEdge(Neo4jBatchGraph graph, Long id, String label) {
        super(graph, id);
        this.label = label;
    }

    public Object removeProperty(String key) {
        Map<String, Object> properties = this.getPropertyMapClone();
        Object value = properties.remove(key);
        this.graph.getRawGraph().setRelationshipProperties(this.id.longValue(), properties);
        return value;
    }

    public void setProperty(String key, Object value) {
        if (key.isEmpty()) {
            throw ExceptionFactory.elementKeyCanNotBeEmpty();
        }
        if (key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (key.equals("label")) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        Map<String, Object> properties = this.getPropertyMapClone();
        properties.put(key, value);
        this.graph.getRawGraph().setRelationshipProperties(this.id.longValue(), properties);
    }

    @Override
    public Map<String, Object> getPropertyMap() {
        return this.graph.getRawGraph().getRelationshipProperties(this.id.longValue());
    }

    public Vertex getVertex(Direction direction) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "e[" + this.id + "][?-" + this.label + "->?]";
    }
}

