/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4jbatch;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4jbatch.Neo4jBatchEdge;
import com.tinkerpop.blueprints.impls.neo4jbatch.Neo4jBatchIndex;
import com.tinkerpop.blueprints.impls.neo4jbatch.Neo4jBatchVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.tooling.GlobalGraphOperations;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndexProvider;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class Neo4jBatchGraph
implements KeyIndexableGraph,
IndexableGraph,
MetaGraph<BatchInserter> {
    private final BatchInserter rawGraph;
    private final BatchInserterIndexProvider indexProvider;
    private final Map<String, Neo4jBatchIndex<? extends Element>> indices = new HashMap<String, Neo4jBatchIndex<? extends Element>>();
    private Long idCounter = 0L;
    protected final Set<String> vertexIndexKeys = new HashSet<String>();
    protected final Set<String> edgeIndexKeys = new HashSet<String>();
    private static final Features FEATURES = new Features();
    private static final String INDEXED_KEYS_POSTFIX = ":indexed_keys";

    public Neo4jBatchGraph(String directory) {
        this.rawGraph = BatchInserters.inserter((String)directory);
        this.indexProvider = new LuceneBatchInserterIndexProvider(this.rawGraph);
    }

    public Neo4jBatchGraph(String directory, Map<String, String> parameters) {
        this.rawGraph = null == parameters ? BatchInserters.inserter((String)directory) : BatchInserters.inserter((String)directory, parameters);
        this.indexProvider = new LuceneBatchInserterIndexProvider(this.rawGraph);
    }

    public Neo4jBatchGraph(BatchInserter rawGraph, BatchInserterIndexProvider indexProvider) {
        this.rawGraph = rawGraph;
        this.indexProvider = indexProvider;
    }

    public void shutdown() {
        this.flushIndices();
        this.indexProvider.shutdown();
        this.rawGraph.shutdown();
        this.removeReferenceNodeAndFinalizeKeyIndices();
    }

    public void flushIndices() {
        for (Neo4jBatchIndex<? extends Element> index : this.indices.values()) {
            index.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReferenceNodeAndFinalizeKeyIndices() {
        GraphDatabaseService rawGraphDB = null;
        try {
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.rawGraph.getStoreDir());
            if (this.vertexIndexKeys.size() > 0) {
                builder.setConfig((Setting)GraphDatabaseSettings.node_keys_indexable, this.vertexIndexKeys.toString().replace("[", "").replace("]", "")).setConfig((Setting)GraphDatabaseSettings.node_auto_indexing, "true");
            }
            if (this.edgeIndexKeys.size() > 0) {
                builder.setConfig((Setting)GraphDatabaseSettings.relationship_keys_indexable, this.edgeIndexKeys.toString().replace("[", "").replace("]", "")).setConfig((Setting)GraphDatabaseSettings.relationship_auto_indexing, "true");
            }
            rawGraphDB = builder.newGraphDatabase();
            Transaction tx = rawGraphDB.beginTx();
            try {
                rawGraphDB.getReferenceNode().delete();
                tx.success();
            }
            catch (Exception e) {
                tx.failure();
            }
            finally {
                tx.finish();
            }
            GlobalGraphOperations graphOperations = GlobalGraphOperations.at((GraphDatabaseService)rawGraphDB);
            if (this.vertexIndexKeys.size() > 0) {
                Neo4jBatchGraph.populateKeyIndices(rawGraphDB, rawGraphDB.index().getNodeAutoIndexer(), graphOperations.getAllNodes(), Vertex.class);
            }
            if (this.edgeIndexKeys.size() > 0) {
                Neo4jBatchGraph.populateKeyIndices(rawGraphDB, rawGraphDB.index().getRelationshipAutoIndexer(), graphOperations.getAllRelationships(), Edge.class);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (rawGraphDB != null) {
                rawGraphDB.shutdown();
            }
        }
    }

    private static <T extends PropertyContainer> void populateKeyIndices(GraphDatabaseService rawGraphDB, AutoIndexer<T> rawAutoIndexer, Iterable<T> rawElements, Class elementClass) {
        if (!rawAutoIndexer.isEnabled()) {
            return;
        }
        Set properties = rawAutoIndexer.getAutoIndexedProperties();
        Transaction tx = rawGraphDB.beginTx();
        GraphProperties kernel = ((InternalAbstractGraphDatabase)rawGraphDB).getNodeManager().getGraphProperties();
        kernel.setProperty(elementClass.getSimpleName() + INDEXED_KEYS_POSTFIX, (Object)properties.toArray(new String[properties.size()]));
        int count = 0;
        for (PropertyContainer pc : rawElements) {
            for (String property : properties) {
                if (!pc.hasProperty(property)) continue;
                pc.setProperty(property, pc.getProperty(property));
                if (++count < 10000) continue;
                count = 0;
                tx.success();
                tx.finish();
                tx = rawGraphDB.beginTx();
            }
        }
        tx.success();
        tx.finish();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.toString());
    }

    public BatchInserter getRawGraph() {
        return this.rawGraph;
    }

    public Vertex addVertex(Object id) {
        Long finalId;
        Map<Object, Object> finalProperties = new HashMap();
        if (null == id) {
            Neo4jBatchGraph neo4jBatchGraph = this;
            neo4jBatchGraph.idCounter = neo4jBatchGraph.idCounter + 1L;
            this.rawGraph.createNode(neo4jBatchGraph.idCounter.longValue(), finalProperties);
            finalId = this.idCounter;
        } else if (id instanceof Long) {
            this.rawGraph.createNode(((Long)id).longValue(), finalProperties);
            finalId = (Long)id;
        } else if (id instanceof Map) {
            finalProperties = this.makePropertyMap((Map)id);
            Long providedId = (Long)((Map)id).get("_id");
            finalProperties.remove("_id");
            if (providedId == null) {
                finalId = this.rawGraph.createNode(finalProperties);
            } else {
                this.rawGraph.createNode(providedId.longValue(), finalProperties);
                finalId = providedId;
            }
        } else {
            try {
                finalId = Double.valueOf(id.toString()).longValue();
                this.rawGraph.createNode(finalId.longValue(), finalProperties);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The provided object must be null, a long id, an object convertible to long, or a Map<String,Object>");
            }
        }
        return new Neo4jBatchVertex(this, finalId);
    }

    public Vertex getVertex(Object id) {
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        try {
            Long longId = id instanceof Long ? (Long)id : Long.valueOf(Double.valueOf(id.toString()).longValue());
            if (this.rawGraph.nodeExists(longId.longValue())) {
                return new Neo4jBatchVertex(this, longId);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Iterable<Vertex> getVertices() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Vertex> getVertices(String key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeVertex(Vertex vertex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Map<Object, Object> finalProperties = id == null || !(id instanceof Map) ? new HashMap() : this.makePropertyMap((Map)id);
        Long finalId = this.rawGraph.createRelationship(((Long)outVertex.getId()).longValue(), ((Long)inVertex.getId()).longValue(), (RelationshipType)DynamicRelationshipType.withName((String)label), finalProperties);
        return new Neo4jBatchEdge(this, finalId, label);
    }

    public Edge getEdge(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Edge> getEdges() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Edge> getEdges(String key, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(Edge edge) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        return this.indices.get(indexName);
    }

    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        Map<String, String> map = Neo4jBatchGraph.generateParameterMap(indexParameters);
        if (indexParameters.length == 0) {
            map.put("type", "exact");
        }
        Neo4jBatchIndex<T> index = Vertex.class.isAssignableFrom(indexClass) ? new Neo4jBatchIndex<T>(this, this.indexProvider.nodeIndex(indexName, map), indexName, indexClass) : new Neo4jBatchIndex<T>(this, this.indexProvider.relationshipIndex(indexName, map), indexName, indexClass);
        this.indices.put(indexName, index);
        return index;
    }

    public Iterable<Index<? extends Element>> getIndices() {
        return this.indices.values();
    }

    public void dropIndex(String indexName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Delete operations are not supported");
    }

    private Map<String, Object> makePropertyMap(Map<String, Object> map) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("_id")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndexKeys.remove(key);
        } else {
            this.edgeIndexKeys.remove(key);
        }
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexIndexKeys.add(key);
        } else {
            this.edgeIndexKeys.add(key);
        }
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.vertexIndexKeys;
        }
        return this.edgeIndexKeys;
    }

    private static Map<String, String> generateParameterMap(Parameter<Object, Object> ... indexParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter<Object, Object> parameter : indexParameters) {
            map.put(parameter.getKey().toString(), parameter.getValue().toString());
        }
        return map;
    }

    public Features getFeatures() {
        return FEATURES;
    }

    static {
        Neo4jBatchGraph.FEATURES.supportsSerializableObjectProperty = false;
        Neo4jBatchGraph.FEATURES.supportsBooleanProperty = true;
        Neo4jBatchGraph.FEATURES.supportsDoubleProperty = true;
        Neo4jBatchGraph.FEATURES.supportsFloatProperty = true;
        Neo4jBatchGraph.FEATURES.supportsIntegerProperty = true;
        Neo4jBatchGraph.FEATURES.supportsPrimitiveArrayProperty = true;
        Neo4jBatchGraph.FEATURES.supportsUniformListProperty = true;
        Neo4jBatchGraph.FEATURES.supportsMixedListProperty = false;
        Neo4jBatchGraph.FEATURES.supportsLongProperty = true;
        Neo4jBatchGraph.FEATURES.supportsMapProperty = false;
        Neo4jBatchGraph.FEATURES.supportsStringProperty = true;
        Neo4jBatchGraph.FEATURES.supportsDuplicateEdges = true;
        Neo4jBatchGraph.FEATURES.supportsSelfLoops = true;
        Neo4jBatchGraph.FEATURES.isPersistent = true;
        Neo4jBatchGraph.FEATURES.isRDFModel = false;
        Neo4jBatchGraph.FEATURES.isWrapper = false;
        Neo4jBatchGraph.FEATURES.supportsVertexIteration = false;
        Neo4jBatchGraph.FEATURES.supportsEdgeIteration = false;
        Neo4jBatchGraph.FEATURES.supportsVertexIndex = true;
        Neo4jBatchGraph.FEATURES.supportsEdgeIndex = true;
        Neo4jBatchGraph.FEATURES.ignoresSuppliedIds = false;
        Neo4jBatchGraph.FEATURES.supportsTransactions = false;
        Neo4jBatchGraph.FEATURES.supportsIndices = true;
        Neo4jBatchGraph.FEATURES.supportsKeyIndices = true;
        Neo4jBatchGraph.FEATURES.supportsVertexKeyIndex = true;
        Neo4jBatchGraph.FEATURES.supportsEdgeKeyIndex = true;
        Neo4jBatchGraph.FEATURES.supportsEdgeRetrieval = true;
        Neo4jBatchGraph.FEATURES.supportsVertexProperties = true;
        Neo4jBatchGraph.FEATURES.supportsEdgeProperties = true;
        Neo4jBatchGraph.FEATURES.supportsThreadedTransactions = false;
    }
}

