/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.sail;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.sail.SailEdge;
import com.tinkerpop.blueprints.impls.sail.SailEdgeIterable;
import com.tinkerpop.blueprints.impls.sail.SailHelper;
import com.tinkerpop.blueprints.impls.sail.SailVertex;
import com.tinkerpop.blueprints.util.DefaultGraphQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.PropertyFilteredIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import info.aduna.iteration.CloseableIteration;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailGraph
implements TransactionalGraph,
MetaGraph<Sail> {
    private static final Logger LOGGER = Logger.getLogger(SailGraph.class.getName());
    public static final Map<String, RDFFormat> formats = new HashMap<String, RDFFormat>();
    private static final Features FEATURES = new Features();
    private final List<SailConnection> connections = new LinkedList<SailConnection>();
    protected final Sail rawGraph;
    protected final ThreadLocal<SailConnection> sailConnection = new ThreadLocal<SailConnection>(){

        @Override
        protected SailConnection initialValue() {
            SailConnection sc = null;
            try {
                sc = SailGraph.this.createConnection();
            }
            catch (SailException e) {
                e.printStackTrace(System.err);
            }
            return sc;
        }
    };
    private static final String LOG4J_PROPERTIES = "log4j.properties";

    public static RDFFormat getFormat(String format) {
        RDFFormat ret = formats.get(format);
        if (null == ret) {
            throw new IllegalArgumentException(format + " is an unsupported RDF file format. Use rdf-xml, n-triples, n-quads, turtle, n3, trix, or trig");
        }
        return ret;
    }

    public SailGraph(Sail sail) {
        try {
            PropertyConfigurator.configure((URL)SailGraph.class.getResource(LOG4J_PROPERTIES));
        }
        catch (Throwable e) {
            LOGGER.warning("failed to configure Log4j: " + e.getMessage());
        }
        try {
            this.rawGraph = sail;
            sail.initialize();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addDefaultNamespaces() {
        this.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.addNamespace("owl", "http://www.w3.org/2002/07/owl#");
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.addNamespace("foaf", "http://xmlns.com/foaf/0.1/");
    }

    public Sail getRawGraph() {
        return this.rawGraph;
    }

    private Vertex createVertex(String resource) {
        if (SailHelper.isBNode(resource)) {
            return new SailVertex((Value)new BNodeImpl(resource.substring(2)), this);
        }
        Literal literal = SailHelper.makeLiteral(resource, this);
        if (literal != null) {
            return new SailVertex((Value)literal, this);
        }
        if (resource.contains(":") || resource.contains("/") || resource.contains("#")) {
            resource = this.expandPrefix(resource);
            return new SailVertex((Value)new URIImpl(resource), this);
        }
        throw new RuntimeException(resource + " is not a valid URI, blank node, or literal value");
    }

    public Vertex addVertex(Object id) {
        if (null == id) {
            id = "urn:uuid:" + UUID.randomUUID().toString();
        }
        return this.createVertex(id.toString());
    }

    public Vertex getVertex(Object id) {
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        try {
            return this.createVertex(id.toString());
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    public Edge getEdge(Object id) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Vertex> getVertices() {
        throw new UnsupportedOperationException("RDF is an edge based graph model");
    }

    public Iterable<Vertex> getVertices(String key, Object value) {
        throw new UnsupportedOperationException("RDF is an edge based graph model");
    }

    public Iterable<Edge> getEdges() {
        return new SailEdgeIterable(null, null, null, this);
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        return new PropertyFilteredIterable(key, value, (Iterable)new SailEdgeIterable(null, null, null, this));
    }

    public void removeVertex(Vertex vertex) {
        Value vertexValue = ((SailVertex)vertex).getRawVertex();
        try {
            if (vertexValue instanceof Resource) {
                this.sailConnection.get().removeStatements((Resource)vertexValue, null, null, new Resource[0]);
            }
            this.sailConnection.get().removeStatements(null, null, vertexValue, new Resource[0]);
        }
        catch (SailException e) {
            throw ExceptionFactory.vertexWithIdDoesNotExist((Object)vertex.getId());
        }
    }

    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        Value outVertexValue = ((SailVertex)outVertex).getRawVertex();
        Value inVertexValue = ((SailVertex)inVertex).getRawVertex();
        if (!(outVertexValue instanceof Resource)) {
            throw new IllegalArgumentException(outVertex.toString() + " is not a legal URI or blank node");
        }
        try {
            URIImpl labelURI = new URIImpl(this.expandPrefix(label));
            StatementImpl statement = new StatementImpl((Resource)outVertexValue, (URI)labelURI, inVertexValue);
            SailHelper.addStatement((Statement)statement, this.sailConnection.get());
            return new SailEdge((Statement)statement, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void removeEdge(Edge edge) {
        Statement statement = ((SailEdge)edge).getRawEdge();
        try {
            SailHelper.removeStatement(statement, this.sailConnection.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ThreadLocal<SailConnection> getSailConnection() {
        return this.sailConnection;
    }

    public void addNamespace(String prefix, String namespace) {
        try {
            this.sailConnection.get().setNamespace(prefix, namespace);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void removeNamespace(String prefix) {
        try {
            this.sailConnection.get().removeNamespace(prefix);
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        try {
            CloseableIteration results = this.sailConnection.get().getNamespaces();
            while (results.hasNext()) {
                Namespace namespace = (Namespace)results.next();
                namespaces.put(namespace.getPrefix(), namespace.getName());
            }
            results.close();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRDF(InputStream input, String baseURI, String format, String baseGraph) {
        try {
            this.commit();
            SailConnection c = this.rawGraph.getConnection();
            try {
                c.begin();
                RDFParser p = Rio.createParser((RDFFormat)SailGraph.getFormat(format));
                SailAdder h = null == baseGraph ? new SailAdder(c, new Resource[0]) : new SailAdder(c, new Resource[]{new URIImpl(baseGraph)});
                p.setRDFHandler((RDFHandler)h);
                p.parse(input, baseURI);
                c.commit();
            }
            finally {
                c.rollback();
                c.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRDF(OutputStream output, String format) {
        try {
            this.commit();
            SailConnection c = this.rawGraph.getConnection();
            try {
                c.begin();
                RDFWriter w = Rio.createWriter((RDFFormat)SailGraph.getFormat(format), (OutputStream)output);
                w.startRDF();
                CloseableIteration iter = c.getStatements(null, null, null, false, new Resource[0]);
                try {
                    while (iter.hasNext()) {
                        w.handleStatement((Statement)iter.next());
                    }
                }
                finally {
                    iter.close();
                }
                w.endRDF();
            }
            finally {
                c.rollback();
                c.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized SailConnection createConnection() throws SailException {
        this.cleanupConnections();
        SailConnection sc = this.rawGraph.getConnection();
        sc.begin();
        this.connections.add(sc);
        return sc;
    }

    private void cleanupConnections() throws SailException {
        LinkedList<SailConnection> toRemove = new LinkedList<SailConnection>();
        for (SailConnection sc : this.connections) {
            if (sc.isOpen()) continue;
            toRemove.add(sc);
        }
        for (SailConnection sc : toRemove) {
            this.connections.remove(sc);
        }
    }

    private void closeAllConnections() throws SailException {
        for (SailConnection sc : this.connections) {
            if (null == sc || !sc.isOpen()) continue;
            sc.rollback();
            sc.close();
        }
    }

    public synchronized void shutdown() {
        try {
            this.commit();
            this.closeAllConnections();
            this.rawGraph.shutDown();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String expandPrefix(String uri) {
        try {
            String namespace;
            if (uri.contains(":") && null != (namespace = this.sailConnection.get().getNamespace(uri.substring(0, uri.indexOf(":"))))) {
                uri = namespace + uri.substring(uri.indexOf(":") + 1);
            }
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }

    public String prefixNamespace(String uri) {
        try {
            CloseableIteration namespaces = this.sailConnection.get().getNamespaces();
            while (namespaces.hasNext()) {
                Namespace namespace = (Namespace)namespaces.next();
                if (!uri.contains(namespace.getName())) continue;
                uri = uri.replace(namespace.getName(), namespace.getPrefix() + ":");
            }
            namespaces.close();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return uri;
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    public void commit() {
        try {
            SailConnection sc = this.sailConnection.get();
            sc.commit();
            sc.begin();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void rollback() {
        try {
            SailConnection sc = this.sailConnection.get();
            sc.rollback();
            sc.begin();
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.getClass().getSimpleName().toLowerCase());
    }

    private String getPrefixes() {
        String prefixString = "";
        Map<String, String> namespaces = this.getNamespaces();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            prefixString = prefixString + "PREFIX " + entry.getKey() + ": <" + entry.getValue() + ">\n";
        }
        return prefixString;
    }

    public Features getFeatures() {
        return FEATURES;
    }

    public GraphQuery query() {
        return new DefaultGraphQuery((Graph)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Vertex>> executeSparql(String sparqlQuery) throws RuntimeException {
        try {
            sparqlQuery = this.getPrefixes() + sparqlQuery;
            SPARQLParser parser = new SPARQLParser();
            ParsedQuery query = parser.parseQuery(sparqlQuery, null);
            boolean includeInferred = false;
            CloseableIteration results = this.sailConnection.get().evaluate(query.getTupleExpr(), query.getDataset(), (BindingSet)new MapBindingSet(), includeInferred);
            ArrayList<Map<String, Vertex>> returnList = new ArrayList<Map<String, Vertex>>();
            try {
                while (results.hasNext()) {
                    BindingSet bs = (BindingSet)results.next();
                    HashMap<String, Vertex> returnMap = new HashMap<String, Vertex>();
                    for (Binding b : bs) {
                        returnMap.put(b.getName(), this.getVertex(b.getValue().toString()));
                    }
                    returnList.add(returnMap);
                }
            }
            finally {
                results.close();
            }
            return returnList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        SailGraph.FEATURES.supportsDuplicateEdges = false;
        SailGraph.FEATURES.supportsSelfLoops = true;
        SailGraph.FEATURES.isPersistent = false;
        SailGraph.FEATURES.supportsVertexIteration = false;
        SailGraph.FEATURES.supportsEdgeIteration = true;
        SailGraph.FEATURES.supportsVertexIndex = false;
        SailGraph.FEATURES.supportsEdgeIndex = false;
        SailGraph.FEATURES.ignoresSuppliedIds = false;
        SailGraph.FEATURES.supportsEdgeRetrieval = false;
        SailGraph.FEATURES.supportsVertexProperties = false;
        SailGraph.FEATURES.supportsEdgeProperties = false;
        SailGraph.FEATURES.supportsTransactions = true;
        SailGraph.FEATURES.supportsEdgeKeyIndex = false;
        SailGraph.FEATURES.supportsVertexKeyIndex = false;
        SailGraph.FEATURES.supportsKeyIndices = false;
        SailGraph.FEATURES.isWrapper = false;
        SailGraph.FEATURES.supportsIndices = false;
        SailGraph.FEATURES.supportsSerializableObjectProperty = false;
        SailGraph.FEATURES.supportsBooleanProperty = false;
        SailGraph.FEATURES.supportsDoubleProperty = false;
        SailGraph.FEATURES.supportsFloatProperty = false;
        SailGraph.FEATURES.supportsIntegerProperty = false;
        SailGraph.FEATURES.supportsPrimitiveArrayProperty = false;
        SailGraph.FEATURES.supportsUniformListProperty = false;
        SailGraph.FEATURES.supportsMixedListProperty = false;
        SailGraph.FEATURES.supportsLongProperty = false;
        SailGraph.FEATURES.supportsMapProperty = false;
        SailGraph.FEATURES.supportsStringProperty = false;
        SailGraph.FEATURES.supportsThreadedTransactions = false;
        formats.put("n3", RDFFormat.N3);
        formats.put("n-quads", RDFFormat.NQUADS);
        formats.put("n-triples", RDFFormat.NTRIPLES);
        formats.put("rdf-json", RDFFormat.RDFJSON);
        formats.put("rdf-xml", RDFFormat.RDFXML);
        formats.put("trix", RDFFormat.TRIX);
        formats.put("trig", RDFFormat.TRIG);
        formats.put("turtle", RDFFormat.TURTLE);
    }

    private class SailAdder
    implements RDFHandler {
        private final SailConnection c;
        private final Resource[] contexts;

        public SailAdder(SailConnection c, Resource ... contexts) {
            this.c = c;
            this.contexts = contexts;
        }

        public void startRDF() throws RDFHandlerException {
        }

        public void endRDF() throws RDFHandlerException {
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            try {
                this.c.setNamespace(prefix, uri);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void handleStatement(Statement s) throws RDFHandlerException {
            try {
                if (1 <= this.contexts.length) {
                    for (Resource x : this.contexts) {
                        this.c.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{x});
                    }
                } else {
                    this.c.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{s.getContext()});
                }
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void handleComment(String s) throws RDFHandlerException {
        }
    }
}

