/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.sail;

import com.tinkerpop.blueprints.impls.sail.SailGraph;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

class SailHelper {
    public static final Pattern literalPattern = Pattern.compile("^\"(.*?)\"((\\^\\^<(.+?)>)$|(@(.{2}))$)");

    SailHelper() {
    }

    protected static void removeStatement(Statement statement, SailConnection sailConnection) {
        try {
            if (null != statement.getContext()) {
                sailConnection.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
            } else {
                sailConnection.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
            }
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static void addStatement(Statement statement, SailConnection sailConnection) {
        try {
            if (null != statement.getContext()) {
                sailConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
            } else {
                sailConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[0]);
            }
        }
        catch (SailException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected static void addStatement(Resource subject, URI predicate, Value object, Resource context, SailConnection sailConnection) {
        Object statement = null != context ? new ContextStatementImpl(subject, predicate, object, context) : new StatementImpl(subject, predicate, object);
        SailHelper.addStatement((Statement)statement, sailConnection);
    }

    public static boolean isBNode(String resource) {
        return resource.length() > 2 && resource.startsWith("_:");
    }

    public static boolean isLiteral(String resource) {
        return literalPattern.matcher(resource).matches() || resource.startsWith("\"") && resource.endsWith("\"") && resource.length() > 1;
    }

    public static boolean isURI(String resource) {
        return !SailHelper.isBNode(resource) && !SailHelper.isLiteral(resource) && (resource.contains(":") || resource.contains("/") || resource.contains("#"));
    }

    public static Literal makeLiteral(String resource, SailGraph graph) {
        Matcher matcher = literalPattern.matcher(resource);
        if (matcher.matches()) {
            if (null != matcher.group(4)) {
                return new LiteralImpl(matcher.group(1), (URI)new URIImpl(graph.expandPrefix(matcher.group(4))));
            }
            return new LiteralImpl(matcher.group(1), matcher.group(6));
        }
        if (resource.startsWith("\"") && resource.endsWith("\"") && resource.length() > 1) {
            return new LiteralImpl(resource.substring(1, resource.length() - 1));
        }
        return null;
    }
}

