/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.BaseTest;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;

public class EdgeTestSuite
extends TestSuite {
    public EdgeTestSuite() {
    }

    public EdgeTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testEdgeEquality() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v = graph.addVertex(this.graphTest.convertId("1"));
        Vertex u = graph.addVertex(this.graphTest.convertId("2"));
        Edge e = graph.addEdge(null, v, u, this.graphTest.convertLabel("knows"));
        EdgeTestSuite.assertEquals((String)e.getLabel(), (String)this.graphTest.convertLabel("knows"));
        EdgeTestSuite.assertEquals((Object)e.getVertex(Direction.IN), (Object)u);
        EdgeTestSuite.assertEquals((Object)e.getVertex(Direction.OUT), (Object)v);
        EdgeTestSuite.assertEquals((Object)e, v.getEdges(Direction.OUT, new String[0]).iterator().next());
        EdgeTestSuite.assertEquals((Object)e, u.getEdges(Direction.IN, new String[0]).iterator().next());
        EdgeTestSuite.assertEquals(v.getEdges(Direction.OUT, new String[0]).iterator().next(), u.getEdges(Direction.IN, new String[0]).iterator().next());
        HashSet<Object> set = new HashSet<Object>();
        set.add(e);
        set.add(e);
        set.add(v.getEdges(Direction.OUT, new String[0]).iterator().next());
        set.add(v.getEdges(Direction.OUT, new String[0]).iterator().next());
        set.add(u.getEdges(Direction.IN, new String[0]).iterator().next());
        set.add(u.getEdges(Direction.IN, new String[0]).iterator().next());
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            set.add(graph.getEdges().iterator().next());
        }
        EdgeTestSuite.assertEquals((int)set.size(), (int)1);
        graph.shutdown();
    }

    public void testAddEdges() {
        Graph graph = this.graphTest.generateGraph();
        this.stopWatch();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
        Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("knows"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("caresFor"));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.printPerformance(graph.toString(), 6, "elements added and checked", this.stopWatch());
        graph.shutdown();
    }

    public void testAddManyEdges() {
        Graph graph = this.graphTest.generateGraph();
        int edgeCount = 100;
        int vertexCount = 200;
        long counter = 0L;
        this.stopWatch();
        for (int i = 0; i < edgeCount; ++i) {
            Vertex out = graph.addVertex(this.graphTest.convertId("" + counter++));
            Vertex in = graph.addVertex(this.graphTest.convertId("" + counter++));
            graph.addEdge(null, out, in, this.graphTest.convertLabel(UUID.randomUUID().toString()));
        }
        EdgeTestSuite.printPerformance(graph.toString(), vertexCount + edgeCount, "elements added", this.stopWatch());
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            EdgeTestSuite.assertEquals((int)edgeCount, (int)EdgeTestSuite.count(graph.getEdges()));
            EdgeTestSuite.printPerformance(graph.toString(), edgeCount, "edges counted", this.stopWatch());
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            EdgeTestSuite.assertEquals((int)vertexCount, (int)EdgeTestSuite.count(graph.getVertices()));
            EdgeTestSuite.printPerformance(graph.toString(), vertexCount, "vertices counted", this.stopWatch());
            this.stopWatch();
            for (Vertex vertex : graph.getVertices()) {
                if (EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])) > 0) {
                    EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])));
                    EdgeTestSuite.assertFalse((EdgeTestSuite.count(vertex.getEdges(Direction.IN, new String[0])) > 0 ? 1 : 0) != 0);
                    continue;
                }
                EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(vertex.getEdges(Direction.IN, new String[0])));
                EdgeTestSuite.assertFalse((EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])) > 0 ? 1 : 0) != 0);
            }
            EdgeTestSuite.printPerformance(graph.toString(), vertexCount, "vertices checked", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testGetEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        Vertex v2 = graph.addVertex(null);
        Vertex v3 = graph.addVertex(null);
        Edge e1 = graph.addEdge(null, v1, v2, this.graphTest.convertLabel("test1"));
        Edge e2 = graph.addEdge(null, v2, v3, this.graphTest.convertLabel("test2"));
        Edge e3 = graph.addEdge(null, v3, v1, this.graphTest.convertLabel("test3"));
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            this.stopWatch();
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e1.getId()), (Object)e1);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e1.getId()).getVertex(Direction.IN), (Object)v2);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e1.getId()).getVertex(Direction.OUT), (Object)v1);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e2.getId()), (Object)e2);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e2.getId()).getVertex(Direction.IN), (Object)v3);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e2.getId()).getVertex(Direction.OUT), (Object)v2);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e3.getId()), (Object)e3);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e3.getId()).getVertex(Direction.IN), (Object)v1);
            EdgeTestSuite.assertEquals((Object)graph.getEdge(e3.getId()).getVertex(Direction.OUT), (Object)v3);
            EdgeTestSuite.printPerformance(graph.toString(), 3, "edges retrieved", this.stopWatch());
        }
        EdgeTestSuite.assertEquals(EdgeTestSuite.getOnlyElement(v1.getEdges(Direction.OUT, new String[0])), (Object)e1);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v1.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.IN), (Object)v2);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v1.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.OUT), (Object)v1);
        EdgeTestSuite.assertEquals(EdgeTestSuite.getOnlyElement(v2.getEdges(Direction.OUT, new String[0])), (Object)e2);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v2.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.IN), (Object)v3);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v2.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.OUT), (Object)v2);
        EdgeTestSuite.assertEquals(EdgeTestSuite.getOnlyElement(v3.getEdges(Direction.OUT, new String[0])), (Object)e3);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v3.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.IN), (Object)v1);
        EdgeTestSuite.assertEquals((Object)((Edge)EdgeTestSuite.getOnlyElement(v3.getEdges(Direction.OUT, new String[0]))).getVertex(Direction.OUT), (Object)v3);
        graph.shutdown();
    }

    public void testGetNonExistantEdges() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            try {
                graph.getEdge(null);
                EdgeTestSuite.fail((String)"Getting an element with a null identifier must throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                EdgeTestSuite.assertTrue((boolean)true);
            }
            EdgeTestSuite.assertNull((Object)graph.getEdge((Object)"asbv"));
            EdgeTestSuite.assertNull((Object)graph.getEdge((Object)12.0));
        }
        graph.shutdown();
    }

    public void testRemoveManyEdges() {
        Graph graph = this.graphTest.generateGraph();
        long counter = 200000L;
        int edgeCount = 10;
        HashSet<Edge> edges = new HashSet<Edge>();
        for (int i = 0; i < edgeCount; ++i) {
            Vertex out = graph.addVertex(this.graphTest.convertId("" + counter++));
            Vertex in = graph.addVertex(this.graphTest.convertId("" + counter++));
            edges.add(graph.addEdge(null, out, in, this.graphTest.convertLabel("a" + UUID.randomUUID().toString())));
        }
        EdgeTestSuite.assertEquals((int)edgeCount, (int)edges.size());
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            EdgeTestSuite.assertEquals((int)(edgeCount * 2), (int)EdgeTestSuite.count(graph.getVertices()));
            EdgeTestSuite.printPerformance(graph.toString(), edgeCount * 2, "vertices counted", this.stopWatch());
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            EdgeTestSuite.assertEquals((int)edgeCount, (int)EdgeTestSuite.count(graph.getEdges()));
            EdgeTestSuite.printPerformance(graph.toString(), edgeCount, "edges counted", this.stopWatch());
            Random random = new Random();
            int i = edgeCount;
            this.stopWatch();
            for (Edge edge : edges) {
                if (random.nextBoolean()) {
                    graph.removeEdge(edge);
                } else {
                    edge.remove();
                }
                EdgeTestSuite.assertEquals((int)(--i), (int)EdgeTestSuite.count(graph.getEdges()));
                if (!graph.getFeatures().supportsVertexIteration.booleanValue()) continue;
                int x = 0;
                for (Vertex vertex : graph.getVertices()) {
                    if (EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])) > 0) {
                        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])));
                        EdgeTestSuite.assertFalse((EdgeTestSuite.count(vertex.getEdges(Direction.IN, new String[0])) > 0 ? 1 : 0) != 0);
                        continue;
                    }
                    if (EdgeTestSuite.count(vertex.getEdges(Direction.IN, new String[0])) > 0) {
                        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(vertex.getEdges(Direction.IN, new String[0])));
                        EdgeTestSuite.assertFalse((EdgeTestSuite.count(vertex.getEdges(Direction.OUT, new String[0])) > 0 ? 1 : 0) != 0);
                        continue;
                    }
                    ++x;
                }
                EdgeTestSuite.assertEquals((int)((edgeCount - i) * 2), (int)x);
            }
            EdgeTestSuite.printPerformance(graph.toString(), edgeCount, "edges removed and graph checked", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testAddingDuplicateEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
        Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("knows"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        if (graph.getFeatures().supportsDuplicateEdges.booleanValue()) {
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)5, (int)EdgeTestSuite.count(graph.getEdges()));
            }
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)4, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)4, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        } else {
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)EdgeTestSuite.count(graph.getVertices()), (int)3);
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)EdgeTestSuite.count(graph.getEdges()), (int)2);
            }
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        }
        graph.shutdown();
    }

    public void testRemoveEdgesByRemovingVertex() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
        Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("knows"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            v1 = graph.getVertex(this.graphTest.convertId("1"));
            v2 = graph.getVertex(this.graphTest.convertId("2"));
            v3 = graph.getVertex(this.graphTest.convertId("3"));
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
        }
        graph.removeVertex(v1);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsDuplicateEdges.booleanValue()) {
            EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        } else {
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        }
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        if (graph.getFeatures().supportsDuplicateEdges.booleanValue()) {
            EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        } else {
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        }
        graph.shutdown();
    }

    public void testRemoveEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
        Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
        Edge e1 = graph.addEdge(null, v1, v2, this.graphTest.convertLabel("knows"));
        Edge e2 = graph.addEdge(null, v2, v3, this.graphTest.convertLabel("pets"));
        Edge e3 = graph.addEdge(null, v2, v3, this.graphTest.convertLabel("cares_for"));
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
        }
        graph.removeEdge(e1);
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            v1 = graph.getVertex(this.graphTest.convertId("1"));
            v2 = graph.getVertex(this.graphTest.convertId("2"));
            v3 = graph.getVertex(this.graphTest.convertId("3"));
        }
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        e2.remove();
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            v1 = graph.getVertex(this.graphTest.convertId("1"));
            v2 = graph.getVertex(this.graphTest.convertId("2"));
            v3 = graph.getVertex(this.graphTest.convertId("3"));
        }
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        graph.removeEdge(e3);
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            v1 = graph.getVertex(this.graphTest.convertId("1"));
            v2 = graph.getVertex(this.graphTest.convertId("2"));
            v3 = graph.getVertex(this.graphTest.convertId("3"));
        }
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.OUT, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v1.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
        EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v3.getEdges(Direction.IN, new String[0])));
        graph.shutdown();
    }

    public void testAddingSelfLoops() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsSelfLoops.booleanValue()) {
            Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
            Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
            Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
            graph.addEdge(null, v1, v1, this.graphTest.convertLabel("is_self"));
            graph.addEdge(null, v2, v2, this.graphTest.convertLabel("is_self"));
            graph.addEdge(null, v3, v3, this.graphTest.convertLabel("is_self"));
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getEdges()));
                int counter = 0;
                for (Edge edge : graph.getEdges()) {
                    ++counter;
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN), (Object)edge.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN).getId(), (Object)edge.getVertex(Direction.OUT).getId());
                }
                EdgeTestSuite.assertEquals((int)counter, (int)3);
            }
        }
        graph.shutdown();
    }

    public void testRemoveSelfLoops() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsSelfLoops.booleanValue()) {
            Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
            Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
            Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
            Edge e1 = graph.addEdge(null, v1, v1, this.graphTest.convertLabel("is_self"));
            Edge e2 = graph.addEdge(null, v2, v2, this.graphTest.convertLabel("is_self"));
            Edge e3 = graph.addEdge(null, v3, v3, this.graphTest.convertLabel("is_self"));
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getEdges()));
                for (Edge edge : graph.getEdges()) {
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN), (Object)edge.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN).getId(), (Object)edge.getVertex(Direction.OUT).getId());
                }
            }
            graph.removeVertex(v1);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)2, (int)EdgeTestSuite.count(graph.getEdges()));
                for (Edge edge : graph.getEdges()) {
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN), (Object)edge.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN).getId(), (Object)edge.getVertex(Direction.OUT).getId());
                }
            }
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)1, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
            graph.removeEdge(e2);
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.OUT, new String[0])));
            EdgeTestSuite.assertEquals((int)0, (int)EdgeTestSuite.count(v2.getEdges(Direction.IN, new String[0])));
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)EdgeTestSuite.count(graph.getEdges()), (int)1);
                for (Edge edge : graph.getEdges()) {
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN), (Object)edge.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)edge.getVertex(Direction.IN).getId(), (Object)edge.getVertex(Direction.OUT).getId());
                }
            }
        }
        graph.shutdown();
    }

    public void testEdgeIterator() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
            Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
            Vertex v3 = graph.addVertex(this.graphTest.convertId("3"));
            Edge e1 = graph.addEdge(null, v1, v2, this.graphTest.convertLabel("test"));
            Edge e2 = graph.addEdge(null, v2, v3, this.graphTest.convertLabel("test"));
            Edge e3 = graph.addEdge(null, v3, v1, this.graphTest.convertLabel("test"));
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getVertices()));
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                EdgeTestSuite.assertEquals((int)3, (int)EdgeTestSuite.count(graph.getEdges()));
            }
            HashSet<String> edgeIds = new HashSet<String>();
            int count = 0;
            for (Edge e : graph.getEdges()) {
                ++count;
                edgeIds.add(e.getId().toString());
                EdgeTestSuite.assertEquals((Object)this.graphTest.convertId("test"), (Object)e.getLabel());
                if (e.getId().toString().equals(e1.getId().toString())) {
                    EdgeTestSuite.assertEquals((Object)v1, (Object)e.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)v2, (Object)e.getVertex(Direction.IN));
                    continue;
                }
                if (e.getId().toString().equals(e2.getId().toString())) {
                    EdgeTestSuite.assertEquals((Object)v2, (Object)e.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)v3, (Object)e.getVertex(Direction.IN));
                    continue;
                }
                if (e.getId().toString().equals(e3.getId().toString())) {
                    EdgeTestSuite.assertEquals((Object)v3, (Object)e.getVertex(Direction.OUT));
                    EdgeTestSuite.assertEquals((Object)v1, (Object)e.getVertex(Direction.IN));
                    continue;
                }
                EdgeTestSuite.assertTrue((boolean)false);
            }
            EdgeTestSuite.assertEquals((int)3, (int)count);
            EdgeTestSuite.assertEquals((int)3, (int)edgeIds.size());
            EdgeTestSuite.assertTrue((boolean)edgeIds.contains(e1.getId().toString()));
            EdgeTestSuite.assertTrue((boolean)edgeIds.contains(e2.getId().toString()));
            EdgeTestSuite.assertTrue((boolean)edgeIds.contains(e3.getId().toString()));
        }
        graph.shutdown();
    }

    public void testAddingRemovingEdgeProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Vertex a = graph.addVertex(this.graphTest.convertId("1"));
            Vertex b = graph.addVertex(this.graphTest.convertId("2"));
            Edge edge = graph.addEdge(this.graphTest.convertId("3"), a, b, "knows");
            EdgeTestSuite.assertEquals((int)edge.getPropertyKeys().size(), (int)0);
            EdgeTestSuite.assertNull((Object)edge.getProperty("weight"));
            if (graph.getFeatures().supportsDoubleProperty.booleanValue()) {
                edge.setProperty("weight", (Object)0.5);
                EdgeTestSuite.assertEquals((int)edge.getPropertyKeys().size(), (int)1);
                EdgeTestSuite.assertEquals((Object)edge.getProperty("weight"), (Object)0.5);
                edge.setProperty("weight", (Object)0.6);
                EdgeTestSuite.assertEquals((int)edge.getPropertyKeys().size(), (int)1);
                EdgeTestSuite.assertEquals((Object)edge.getProperty("weight"), (Object)0.6);
                EdgeTestSuite.assertEquals((Object)edge.removeProperty("weight"), (Object)0.6);
                EdgeTestSuite.assertNull((Object)edge.getProperty("weight"));
                EdgeTestSuite.assertEquals((int)edge.getPropertyKeys().size(), (int)0);
            }
            if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                edge.setProperty("blah", (Object)"marko");
                edge.setProperty("blah2", (Object)"josh");
                EdgeTestSuite.assertEquals((int)edge.getPropertyKeys().size(), (int)2);
            }
        }
        graph.shutdown();
    }

    public void testAddingLabelAndIdProperty() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Edge edge = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            try {
                edge.setProperty("id", (Object)"123");
                EdgeTestSuite.fail((String)"Setting edge property with reserved key 'id' should fail");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                edge.setProperty("label", (Object)"hates");
                EdgeTestSuite.fail((String)"Setting edge property with reserved key 'label' should fail");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        graph.shutdown();
    }

    public void testNoConcurrentModificationException() {
        Graph graph = this.graphTest.generateGraph();
        for (int i = 0; i < 25; ++i) {
            graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("test"));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)BaseTest.count(graph.getVertices()), (int)50);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)BaseTest.count(graph.getEdges()), (int)25);
            for (Edge edge : graph.getEdges()) {
                graph.removeEdge(edge);
            }
            EdgeTestSuite.assertEquals((int)BaseTest.count(graph.getEdges()), (int)0);
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)BaseTest.count(graph.getVertices()), (int)50);
        }
        graph.shutdown();
    }

    public void testEmptyKeyProperty() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Edge e = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "friend");
            try {
                e.setProperty("", (Object)"value");
                EdgeTestSuite.fail((String)"Setting an edge property with an empty string key should fail");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        graph.shutdown();
    }

    public void testEdgeCentricRemoving() {
        Graph graph = this.graphTest.generateGraph();
        Edge a = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
        Edge b = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
        Edge c = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
        Object cId = c.getId();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)EdgeTestSuite.count(graph.getEdges()), (int)3);
        }
        a.remove();
        b.remove();
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            EdgeTestSuite.assertNotNull((Object)graph.getEdge(cId));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            EdgeTestSuite.assertEquals((int)EdgeTestSuite.count(graph.getEdges()), (int)1);
        }
        graph.shutdown();
    }

    public void testSettingBadVertexProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Edge edge = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            try {
                edge.setProperty(null, (Object)-1);
                EdgeTestSuite.fail((String)"Setting property with a null key should throw an error");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                edge.setProperty("", (Object)-1);
                EdgeTestSuite.fail((String)"Setting edge property with a empty key should throw an error");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                edge.setProperty("id", (Object)-1);
                EdgeTestSuite.fail((String)"Setting edge property with a key of 'id' should throw an error");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                edge.setProperty("label", (Object)"friend");
                EdgeTestSuite.fail((String)"Setting edge property with a key of 'label' should throw an error");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                edge.setProperty("good", null);
                EdgeTestSuite.fail((String)"Setting edge property with a null value should throw an error");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        graph.shutdown();
    }

    public void testSetEdgeLabelNullShouldThrowIllegalArgumentException() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        Vertex v2 = graph.addVertex(null);
        try {
            v2.addEdge(null, v1);
            EdgeTestSuite.fail((String)"Adding edge to vertex with a null label should throw an error");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            graph.addEdge(null, v1, v2, null);
            EdgeTestSuite.fail((String)"Adding edge to graph with a null label should throw an error");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        graph.shutdown();
    }
}

