/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.BaseTest;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.util.io.MockSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class GraphTestSuite
extends TestSuite {
    public GraphTestSuite() {
    }

    public GraphTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testFeatureCompliance() {
        Graph graph = this.graphTest.generateGraph();
        graph.getFeatures().checkCompliance();
        System.out.println(graph.getFeatures());
        graph.shutdown();
    }

    public void testEmptyOnConstruction() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(graph.getEdges()));
        }
        graph.shutdown();
    }

    public void testStringRepresentation() {
        Graph graph = this.graphTest.generateGraph();
        try {
            this.stopWatch();
            GraphTestSuite.assertNotNull((Object)graph.toString());
            GraphTestSuite.assertTrue((boolean)graph.toString().startsWith(graph.getClass().getSimpleName().toLowerCase()));
            GraphTestSuite.printPerformance(graph.toString(), 1, "graph string representation generated", this.stopWatch());
        }
        catch (Exception e) {
            GraphTestSuite.fail((String)("Unexpected exception testing graph string representation: " + e.getMessage()));
        }
        graph.shutdown();
    }

    public void testStringRepresentationOfVertexId() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsTransactions.booleanValue()) {
            ((TransactionalGraph)graph).commit();
        }
        Vertex a = graph.addVertex(null);
        Object id = a.getId();
        Vertex b = graph.getVertex(id);
        Vertex c = graph.getVertex((Object)id.toString());
        GraphTestSuite.assertEquals((Object)a, (Object)b);
        GraphTestSuite.assertEquals((Object)b, (Object)c);
        GraphTestSuite.assertEquals((Object)c, (Object)a);
        graph.shutdown();
    }

    public void testSemanticallyCorrectIterables() {
        int counter;
        Iterator itty;
        Graph graph = this.graphTest.generateGraph();
        for (int i = 0; i < 15; ++i) {
            graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            Iterable vertices = graph.getVertices();
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(vertices), (int)30);
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(vertices), (int)30);
            itty = vertices.iterator();
            counter = 0;
            while (itty.hasNext()) {
                GraphTestSuite.assertTrue((boolean)itty.hasNext());
                itty.next();
                ++counter;
            }
            GraphTestSuite.assertEquals((int)counter, (int)30);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            Iterable edges = graph.getEdges();
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(edges), (int)15);
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(edges), (int)15);
            itty = edges.iterator();
            counter = 0;
            while (itty.hasNext()) {
                GraphTestSuite.assertTrue((boolean)itty.hasNext());
                itty.next();
                ++counter;
            }
            GraphTestSuite.assertEquals((int)counter, (int)15);
        }
        graph.shutdown();
    }

    public void testGettingVerticesAndEdgesWithKeyValue() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v1 = graph.addVertex(null);
            v1.setProperty("name", (Object)"marko");
            v1.setProperty("location", (Object)"everywhere");
            Vertex v2 = graph.addVertex(null);
            v2.setProperty("name", (Object)"stephen");
            v2.setProperty("location", (Object)"everywhere");
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices("location", (Object)"everywhere")), (int)2);
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices("name", (Object)"marko")), (int)1);
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices("name", (Object)"stephen")), (int)1);
                GraphTestSuite.assertEquals(GraphTestSuite.getOnlyElement(graph.getVertices("name", (Object)"marko")), (Object)v1);
                GraphTestSuite.assertEquals(GraphTestSuite.getOnlyElement(graph.getVertices("name", (Object)"stephen")), (Object)v2);
            }
        }
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Edge e1 = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
            e1.setProperty("name", (Object)"marko");
            e1.setProperty("location", (Object)"everywhere");
            Edge e2 = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("knows"));
            e2.setProperty("name", (Object)"stephen");
            e2.setProperty("location", (Object)"everywhere");
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges("location", (Object)"everywhere")), (int)2);
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges("name", (Object)"marko")), (int)1);
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges("name", (Object)"stephen")), (int)1);
                GraphTestSuite.assertEquals(graph.getEdges("name", (Object)"marko").iterator().next(), (Object)e1);
                GraphTestSuite.assertEquals(graph.getEdges("name", (Object)"stephen").iterator().next(), (Object)e2);
            }
        }
        graph.shutdown();
    }

    public void testAddingVerticesAndEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        Edge edge = graph.addEdge(null, a, b, this.graphTest.convertLabel("knows"));
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(graph.getEdges()));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)2, (int)GraphTestSuite.count(graph.getVertices()));
        }
        graph.removeVertex(a);
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(graph.getEdges()));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(graph.getVertices()));
        }
        try {
            graph.removeEdge(edge);
        }
        catch (Exception e) {
            GraphTestSuite.assertTrue((boolean)true);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(graph.getEdges()));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(graph.getVertices()));
        }
        graph.shutdown();
    }

    public void testSettingProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Vertex a = graph.addVertex(null);
            Vertex b = graph.addVertex(null);
            graph.addEdge(null, a, b, this.graphTest.convertLabel("knows"));
            graph.addEdge(null, a, b, this.graphTest.convertLabel("knows"));
            for (Edge edge : b.getEdges(Direction.IN, new String[0])) {
                edge.setProperty("key", (Object)"value");
            }
        }
        graph.shutdown();
    }

    public void testDataTypeValidationOnProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsElementProperties() && !graph.getFeatures().isWrapper.booleanValue()) {
            Vertex vertexA = graph.addVertex(null);
            Vertex vertexB = graph.addVertex(null);
            Edge edge = graph.addEdge(null, vertexA, vertexB, this.graphTest.convertLabel("knows"));
            this.trySetProperty((Element)vertexA, "keyString", "value", graph.getFeatures().supportsStringProperty);
            this.trySetProperty((Element)edge, "keyString", "value", graph.getFeatures().supportsStringProperty);
            this.trySetProperty((Element)vertexA, "keyInteger", 100, graph.getFeatures().supportsIntegerProperty);
            this.trySetProperty((Element)edge, "keyInteger", 100, graph.getFeatures().supportsIntegerProperty);
            this.trySetProperty((Element)vertexA, "keyLong", 10000L, graph.getFeatures().supportsLongProperty);
            this.trySetProperty((Element)edge, "keyLong", 10000L, graph.getFeatures().supportsLongProperty);
            this.trySetProperty((Element)vertexA, "keyDouble", 100.321, graph.getFeatures().supportsDoubleProperty);
            this.trySetProperty((Element)edge, "keyDouble", 100.321, graph.getFeatures().supportsDoubleProperty);
            this.trySetProperty((Element)vertexA, "keyFloat", Float.valueOf(100.321f), graph.getFeatures().supportsFloatProperty);
            this.trySetProperty((Element)edge, "keyFloat", Float.valueOf(100.321f), graph.getFeatures().supportsFloatProperty);
            this.trySetProperty((Element)vertexA, "keyBoolean", true, graph.getFeatures().supportsBooleanProperty);
            this.trySetProperty((Element)edge, "keyBoolean", true, graph.getFeatures().supportsBooleanProperty);
            this.trySetProperty((Element)vertexA, "keyDate", new Date(), graph.getFeatures().supportsSerializableObjectProperty);
            this.trySetProperty((Element)edge, "keyDate", new Date(), graph.getFeatures().supportsSerializableObjectProperty);
            ArrayList<String> listA = new ArrayList<String>();
            listA.add("try1");
            listA.add("try2");
            this.trySetProperty((Element)vertexA, "keyListString", listA, graph.getFeatures().supportsUniformListProperty);
            this.trySetProperty((Element)edge, "keyListString", listA, graph.getFeatures().supportsUniformListProperty);
            this.tryGetProperty((Element)vertexA, "keyListString", listA, graph.getFeatures().supportsUniformListProperty);
            this.tryGetProperty((Element)edge, "keyListString", listA, graph.getFeatures().supportsUniformListProperty);
            ArrayList<Object> listB = new ArrayList<Object>();
            listB.add("try1");
            listB.add(2);
            this.trySetProperty((Element)vertexA, "keyListMixed", listB, graph.getFeatures().supportsMixedListProperty);
            this.trySetProperty((Element)edge, "keyListMixed", listB, graph.getFeatures().supportsMixedListProperty);
            this.tryGetProperty((Element)vertexA, "keyListString", listA, graph.getFeatures().supportsMixedListProperty);
            this.tryGetProperty((Element)edge, "keyListString", listA, graph.getFeatures().supportsMixedListProperty);
            this.trySetProperty((Element)vertexA, "keyArrayString", new String[]{"try1", "try2"}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayString", new String[]{"try1", "try2"}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayInteger", new int[]{1, 2}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayInteger", new int[]{1, 2}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayLong", new long[]{1000L, 2000L}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayLong", new long[]{1000L, 2000L}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayFloat", new float[]{1000.321f, 2000.321f}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayFloat", new float[]{1000.321f, 2000.321f}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayDouble", new double[]{1000.321, 2000.321}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayDouble", new double[]{1000.321, 2000.321}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayBoolean", new boolean[]{false, true}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayBoolean", new boolean[]{false, true}, graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)vertexA, "keyArrayEmpty", new int[0], graph.getFeatures().supportsPrimitiveArrayProperty);
            this.trySetProperty((Element)edge, "keyArrayEmpty", new int[0], graph.getFeatures().supportsPrimitiveArrayProperty);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("testString", "try");
            map.put("testInteger", "string");
            this.trySetProperty((Element)vertexA, "keyMap", map, graph.getFeatures().supportsMapProperty);
            this.trySetProperty((Element)edge, "keyMap", map, graph.getFeatures().supportsMapProperty);
            MockSerializable mockSerializable = new MockSerializable();
            mockSerializable.setTestField("test");
            this.trySetProperty((Element)vertexA, "keySerializable", mockSerializable, graph.getFeatures().supportsSerializableObjectProperty);
            this.trySetProperty((Element)edge, "keySerializable", mockSerializable, graph.getFeatures().supportsSerializableObjectProperty);
        }
        graph.shutdown();
    }

    private void trySetProperty(Element element, String key, Object value, boolean allowDataType) {
        boolean exceptionTossed = false;
        try {
            element.setProperty(key, value);
        }
        catch (Throwable t) {
            exceptionTossed = true;
            if (!allowDataType) {
                GraphTestSuite.assertTrue((boolean)(t instanceof IllegalArgumentException));
            }
            GraphTestSuite.fail((String)("setProperty should not have thrown an exception as this data type is accepted according to the GraphTest settings.\n\nException was " + t));
        }
        if (!allowDataType && !exceptionTossed) {
            GraphTestSuite.fail((String)"setProperty threw an exception but the data type should have been accepted.");
        }
    }

    private void tryGetProperty(Element element, String key, Object value, boolean allowDataType) {
        if (allowDataType) {
            GraphTestSuite.assertEquals((Object)element.getProperty(key), (Object)value);
        }
    }

    public void testSimpleRemovingVerticesEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v = graph.addVertex(null);
        Vertex u = graph.addVertex(null);
        Edge e = graph.addEdge(null, v, u, this.graphTest.convertLabel("knows"));
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices()), (int)2);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges()), (int)1);
        }
        GraphTestSuite.assertEquals((Object)((Edge)v.getEdges(Direction.OUT, new String[0]).iterator().next()).getVertex(Direction.IN), (Object)u);
        GraphTestSuite.assertEquals((Object)((Edge)u.getEdges(Direction.IN, new String[0]).iterator().next()).getVertex(Direction.OUT), (Object)v);
        GraphTestSuite.assertEquals(v.getEdges(Direction.OUT, new String[0]).iterator().next(), (Object)e);
        GraphTestSuite.assertEquals(u.getEdges(Direction.IN, new String[0]).iterator().next(), (Object)e);
        graph.removeVertex(v);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices()), (int)1);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges()), (int)0);
        }
        graph.shutdown();
    }

    public void testRemovingEdges() {
        int i;
        Graph graph = this.graphTest.generateGraph();
        int vertexCount = 100;
        int edgeCount = 200;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Random random = new Random();
        this.stopWatch();
        for (i = 0; i < vertexCount; ++i) {
            vertices.add(graph.addVertex(null));
        }
        GraphTestSuite.printPerformance(graph.toString(), vertexCount, "vertices added", this.stopWatch());
        this.stopWatch();
        for (i = 0; i < edgeCount; ++i) {
            Vertex b;
            Vertex a = (Vertex)vertices.get(random.nextInt(vertices.size()));
            if (a == (b = (Vertex)vertices.get(random.nextInt(vertices.size())))) continue;
            edges.add(graph.addEdge(null, a, b, this.graphTest.convertLabel("a" + UUID.randomUUID())));
        }
        GraphTestSuite.printPerformance(graph.toString(), edgeCount, "edges added", this.stopWatch());
        this.stopWatch();
        int counter = 0;
        for (Edge e : edges) {
            ++counter;
            graph.removeEdge(e);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)(edges.size() - counter), (int)GraphTestSuite.count(graph.getEdges()));
            }
            if (!graph.getFeatures().supportsVertexIteration.booleanValue()) continue;
            GraphTestSuite.assertEquals((int)vertices.size(), (int)GraphTestSuite.count(graph.getVertices()));
        }
        GraphTestSuite.printPerformance(graph.toString(), edgeCount, "edges deleted (with size check on each delete)", this.stopWatch());
        graph.shutdown();
    }

    public void testRemovingVertices() {
        int i;
        Graph graph = this.graphTest.generateGraph();
        int vertexCount = 500;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        this.stopWatch();
        for (i = 0; i < vertexCount; ++i) {
            vertices.add(graph.addVertex(null));
        }
        GraphTestSuite.printPerformance(graph.toString(), vertexCount, "vertices added", this.stopWatch());
        this.stopWatch();
        for (i = 0; i < vertexCount; i += 2) {
            Vertex a = (Vertex)vertices.get(i);
            Vertex b = (Vertex)vertices.get(i + 1);
            edges.add(graph.addEdge(null, a, b, this.graphTest.convertLabel("a" + UUID.randomUUID())));
        }
        GraphTestSuite.printPerformance(graph.toString(), vertexCount / 2, "edges added", this.stopWatch());
        this.stopWatch();
        Random random = new Random();
        int counter = 0;
        for (Vertex v : vertices) {
            ++counter;
            if (random.nextBoolean()) {
                graph.removeVertex(v);
            } else {
                v.remove();
            }
            if ((counter + 1) % 2 == 0 && graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)(edges.size() - (counter + 1) / 2), (int)GraphTestSuite.count(graph.getEdges()));
            }
            if (!graph.getFeatures().supportsVertexIteration.booleanValue()) continue;
            GraphTestSuite.assertEquals((int)(vertices.size() - counter), (int)GraphTestSuite.count(graph.getVertices()));
        }
        GraphTestSuite.printPerformance(graph.toString(), vertexCount, "vertices deleted (with size check on each delete)", this.stopWatch());
        graph.shutdown();
    }

    public void testConnectivityPatterns() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(this.graphTest.convertId("1"));
        Vertex b = graph.addVertex(this.graphTest.convertId("2"));
        Vertex c = graph.addVertex(this.graphTest.convertId("3"));
        Vertex d = graph.addVertex(this.graphTest.convertId("4"));
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)4, (int)GraphTestSuite.count(graph.getVertices()));
        }
        Edge e = graph.addEdge(null, a, b, this.graphTest.convertLabel("knows"));
        Edge f = graph.addEdge(null, b, c, this.graphTest.convertLabel("knows"));
        Edge g = graph.addEdge(null, c, d, this.graphTest.convertLabel("knows"));
        Edge h = graph.addEdge(null, d, a, this.graphTest.convertLabel("knows"));
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            GraphTestSuite.assertEquals((int)4, (int)GraphTestSuite.count(graph.getEdges()));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            for (Vertex v : graph.getVertices()) {
                GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(v.getEdges(Direction.OUT, new String[0])));
                GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(v.getEdges(Direction.IN, new String[0])));
            }
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            for (Edge x : graph.getEdges()) {
                GraphTestSuite.assertEquals((Object)this.graphTest.convertId("knows"), (Object)x.getLabel());
            }
        }
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            a = graph.getVertex(this.graphTest.convertId("1"));
            b = graph.getVertex(this.graphTest.convertId("2"));
            c = graph.getVertex(this.graphTest.convertId("3"));
            d = graph.getVertex(this.graphTest.convertId("4"));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(a.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(a.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(b.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(b.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(c.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(c.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(d.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(d.getEdges(Direction.OUT, new String[0])));
            Edge i = graph.addEdge(null, a, b, this.graphTest.convertLabel("hates"));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(a.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)2, (int)GraphTestSuite.count(a.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)2, (int)GraphTestSuite.count(b.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(b.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(c.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(c.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(d.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(d.getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(a.getEdges(Direction.IN, new String[0])));
            GraphTestSuite.assertEquals((int)2, (int)GraphTestSuite.count(a.getEdges(Direction.OUT, new String[0])));
            for (Edge x : a.getEdges(Direction.OUT, new String[0])) {
                GraphTestSuite.assertTrue((x.getLabel().equals(this.graphTest.convertId("knows")) || x.getLabel().equals(this.graphTest.convertId("hates")) ? 1 : 0) != 0);
            }
            GraphTestSuite.assertEquals((Object)this.graphTest.convertId("hates"), (Object)i.getLabel());
            GraphTestSuite.assertEquals((Object)i.getVertex(Direction.IN).getId().toString(), (Object)this.graphTest.convertId("2"));
            GraphTestSuite.assertEquals((Object)i.getVertex(Direction.OUT).getId().toString(), (Object)this.graphTest.convertId("1"));
        }
        HashSet<Object> vertexIds = new HashSet<Object>();
        vertexIds.add(a.getId());
        vertexIds.add(a.getId());
        vertexIds.add(b.getId());
        vertexIds.add(b.getId());
        vertexIds.add(c.getId());
        vertexIds.add(d.getId());
        vertexIds.add(d.getId());
        vertexIds.add(d.getId());
        GraphTestSuite.assertEquals((int)4, (int)vertexIds.size());
        graph.shutdown();
    }

    public void testVertexEdgeLabels() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        Vertex c = graph.addVertex(null);
        Edge aFriendB = graph.addEdge(null, a, b, this.graphTest.convertLabel("friend"));
        Edge aFriendC = graph.addEdge(null, a, c, this.graphTest.convertLabel("friend"));
        Edge aHateC = graph.addEdge(null, a, c, this.graphTest.convertLabel("hate"));
        Edge cHateA = graph.addEdge(null, c, a, this.graphTest.convertLabel("hate"));
        Edge cHateB = graph.addEdge(null, c, b, this.graphTest.convertLabel("hate"));
        List results = GraphTestSuite.asList(a.getEdges(Direction.OUT, new String[0]));
        GraphTestSuite.assertEquals((int)results.size(), (int)3);
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendB));
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendC));
        GraphTestSuite.assertTrue((boolean)results.contains(aHateC));
        results = GraphTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("friend")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)2);
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendB));
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendC));
        results = GraphTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)1);
        GraphTestSuite.assertTrue((boolean)results.contains(aHateC));
        results = GraphTestSuite.asList(a.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)1);
        GraphTestSuite.assertTrue((boolean)results.contains(cHateA));
        results = GraphTestSuite.asList(a.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("friend")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)0);
        results = GraphTestSuite.asList(b.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)1);
        GraphTestSuite.assertTrue((boolean)results.contains(cHateB));
        results = GraphTestSuite.asList(b.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("friend")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)1);
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendB));
        graph.shutdown();
    }

    public void testVertexEdgeLabels2() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        Vertex c = graph.addVertex(null);
        Edge aFriendB = graph.addEdge(null, a, b, this.graphTest.convertLabel("friend"));
        Edge aFriendC = graph.addEdge(null, a, c, this.graphTest.convertLabel("friend"));
        Edge aHateC = graph.addEdge(null, a, c, this.graphTest.convertLabel("hate"));
        Edge cHateA = graph.addEdge(null, c, a, this.graphTest.convertLabel("hate"));
        Edge cHateB = graph.addEdge(null, c, b, this.graphTest.convertLabel("hate"));
        List results = GraphTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)3);
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendB));
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendC));
        GraphTestSuite.assertTrue((boolean)results.contains(aHateC));
        results = GraphTestSuite.asList(a.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)1);
        GraphTestSuite.assertTrue((boolean)results.contains(cHateA));
        results = GraphTestSuite.asList(b.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("friend"), this.graphTest.convertLabel("hate")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)2);
        GraphTestSuite.assertTrue((boolean)results.contains(aFriendB));
        GraphTestSuite.assertTrue((boolean)results.contains(cHateB));
        results = GraphTestSuite.asList(b.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("blah"), this.graphTest.convertLabel("blah2"), this.graphTest.convertLabel("blah3")}));
        GraphTestSuite.assertEquals((int)results.size(), (int)0);
        graph.shutdown();
    }

    public void testTreeConnectivity() {
        Graph graph = this.graphTest.generateGraph();
        this.stopWatch();
        int branchSize = 11;
        Vertex start = graph.addVertex(null);
        for (int i = 0; i < branchSize; ++i) {
            Vertex a = graph.addVertex(null);
            graph.addEdge(null, start, a, this.graphTest.convertLabel("test1"));
            for (int j = 0; j < branchSize; ++j) {
                Vertex b = graph.addVertex(null);
                graph.addEdge(null, a, b, this.graphTest.convertLabel("test2"));
                for (int k = 0; k < branchSize; ++k) {
                    Vertex c = graph.addVertex(null);
                    graph.addEdge(null, b, c, this.graphTest.convertLabel("test3"));
                }
            }
        }
        GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(start.getEdges(Direction.IN, new String[0])));
        GraphTestSuite.assertEquals((int)branchSize, (int)GraphTestSuite.count(start.getEdges(Direction.OUT, new String[0])));
        for (Edge e : start.getEdges(Direction.OUT, new String[0])) {
            GraphTestSuite.assertEquals((Object)this.graphTest.convertId("test1"), (Object)e.getLabel());
            GraphTestSuite.assertEquals((int)branchSize, (int)GraphTestSuite.count(e.getVertex(Direction.IN).getEdges(Direction.OUT, new String[0])));
            GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(e.getVertex(Direction.IN).getEdges(Direction.IN, new String[0])));
            for (Edge f : e.getVertex(Direction.IN).getEdges(Direction.OUT, new String[0])) {
                GraphTestSuite.assertEquals((Object)this.graphTest.convertId("test2"), (Object)f.getLabel());
                GraphTestSuite.assertEquals((int)branchSize, (int)GraphTestSuite.count(f.getVertex(Direction.IN).getEdges(Direction.OUT, new String[0])));
                GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(f.getVertex(Direction.IN).getEdges(Direction.IN, new String[0])));
                for (Edge g : f.getVertex(Direction.IN).getEdges(Direction.OUT, new String[0])) {
                    GraphTestSuite.assertEquals((Object)this.graphTest.convertId("test3"), (Object)g.getLabel());
                    GraphTestSuite.assertEquals((int)0, (int)GraphTestSuite.count(g.getVertex(Direction.IN).getEdges(Direction.OUT, new String[0])));
                    GraphTestSuite.assertEquals((int)1, (int)GraphTestSuite.count(g.getVertex(Direction.IN).getEdges(Direction.IN, new String[0])));
                }
            }
        }
        int totalVertices = 0;
        for (int i = 0; i < 4; ++i) {
            totalVertices += (int)Math.pow(branchSize, i);
        }
        GraphTestSuite.printPerformance(graph.toString(), totalVertices, "vertices added in a tree structure", this.stopWatch());
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            HashSet<Vertex> vertices = new HashSet<Vertex>();
            for (Vertex v : graph.getVertices()) {
                vertices.add(v);
            }
            GraphTestSuite.assertEquals((int)totalVertices, (int)vertices.size());
            GraphTestSuite.printPerformance(graph.toString(), totalVertices, "vertices iterated", this.stopWatch());
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            HashSet<Edge> edges = new HashSet<Edge>();
            for (Edge e : graph.getEdges()) {
                edges.add(e);
            }
            GraphTestSuite.assertEquals((int)(totalVertices - 1), (int)edges.size());
            GraphTestSuite.printPerformance(graph.toString(), totalVertices - 1, "edges iterated", this.stopWatch());
        }
        graph.shutdown();
    }

    public void testConcurrentModification() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        graph.addVertex(null);
        graph.addVertex(null);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            for (Vertex vertex : graph.getVertices()) {
                graph.addEdge(null, vertex, a, this.graphTest.convertLabel("x"));
                graph.addEdge(null, vertex, a, this.graphTest.convertLabel("y"));
            }
            for (Vertex vertex : graph.getVertices()) {
                GraphTestSuite.assertEquals((int)BaseTest.count(vertex.getEdges(Direction.OUT, new String[0])), (int)2);
                for (Edge edge : vertex.getEdges(Direction.OUT, new String[0])) {
                    graph.removeEdge(edge);
                }
            }
            for (Vertex vertex : graph.getVertices()) {
                graph.removeVertex(vertex);
            }
        } else if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            for (int i = 0; i < 10; ++i) {
                graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("test"));
            }
            for (Edge edge : graph.getEdges()) {
                graph.removeEdge(edge);
            }
        }
        graph.shutdown();
    }

    public void testGraphDataPersists() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().isPersistent.booleanValue()) {
            Vertex v = graph.addVertex(null);
            Vertex u = graph.addVertex(null);
            if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
                v.setProperty("name", (Object)"marko");
                u.setProperty("name", (Object)"pavel");
            }
            Edge e = graph.addEdge(null, v, u, this.graphTest.convertLabel("collaborator"));
            if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
                e.setProperty("location", (Object)"internet");
            }
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices()), (int)2);
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges()), (int)1);
            }
            graph.shutdown();
            this.stopWatch();
            graph = this.graphTest.generateGraph();
            GraphTestSuite.printPerformance(graph.toString(), 1, "graph loaded", this.stopWatch());
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getVertices()), (int)2);
                if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
                    for (Vertex vertex : graph.getVertices()) {
                        GraphTestSuite.assertTrue((vertex.getProperty("name").equals("marko") || vertex.getProperty("name").equals("pavel") ? 1 : 0) != 0);
                    }
                }
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphTestSuite.assertEquals((int)GraphTestSuite.count(graph.getEdges()), (int)1);
                for (Edge edge : graph.getEdges()) {
                    GraphTestSuite.assertEquals((Object)edge.getLabel(), (Object)this.graphTest.convertId("collaborator"));
                    if (!graph.getFeatures().supportsEdgeProperties.booleanValue()) continue;
                    GraphTestSuite.assertEquals((Object)edge.getProperty("location"), (Object)"internet");
                }
            }
        }
        graph.shutdown();
    }

    public void testAutotypingOfProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v = graph.addVertex(null);
            v.setProperty("string", (Object)"marko");
            v.setProperty("integer", (Object)33);
            v.setProperty("boolean", (Object)true);
            String name = (String)v.getProperty("string");
            GraphTestSuite.assertEquals((String)name, (String)"marko");
            Integer age = (Integer)v.getProperty("integer");
            GraphTestSuite.assertEquals((Object)age, (Object)33);
            Boolean best = (Boolean)v.getProperty("boolean");
            GraphTestSuite.assertTrue((boolean)best);
            name = (String)v.removeProperty("string");
            GraphTestSuite.assertEquals((String)name, (String)"marko");
            age = (Integer)v.removeProperty("integer");
            GraphTestSuite.assertEquals((Object)age, (Object)33);
            best = (Boolean)v.removeProperty("boolean");
            GraphTestSuite.assertTrue((boolean)best);
        }
        if (graph.getFeatures().supportsEdgeProperties.booleanValue()) {
            Edge e = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            e.setProperty("string", (Object)"friend");
            e.setProperty("double", (Object)1.0);
            String type = (String)e.getProperty("string");
            GraphTestSuite.assertEquals((String)type, (String)"friend");
            Double weight = (Double)e.getProperty("double");
            GraphTestSuite.assertEquals((Object)weight, (Object)1.0);
            type = (String)e.removeProperty("string");
            GraphTestSuite.assertEquals((String)type, (String)"friend");
            weight = (Double)e.removeProperty("double");
            GraphTestSuite.assertEquals((Object)weight, (Object)1.0);
        }
        graph.shutdown();
    }
}

