/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;

public class KeyIndexableGraphTestSuite
extends TestSuite {
    public KeyIndexableGraphTestSuite() {
    }

    public KeyIndexableGraphTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testAutoIndexKeyManagementWithPersistence() {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)0);
            this.stopWatch();
            graph.createKeyIndex("name", Vertex.class, new Parameter[0]);
            graph.createKeyIndex("location", Vertex.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.printPerformance(graph.toString(), 2, "automatic index keys added", this.stopWatch());
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)2);
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("name"));
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("location"));
        }
        if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)0);
            this.stopWatch();
            graph.createKeyIndex("weight", Edge.class, new Parameter[0]);
            graph.createKeyIndex("since", Edge.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.printPerformance(graph.toString(), 2, "automatic index keys added", this.stopWatch());
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)2);
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("weight"));
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("since"));
        }
        graph.shutdown();
        if (graph.getFeatures().isPersistent.booleanValue()) {
            graph = (KeyIndexableGraph)this.graphTest.generateGraph();
            if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)2);
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("name"));
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("location"));
            }
            if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)2);
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("weight"));
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("since"));
            }
            graph.shutdown();
        }
    }

    public void testAutoIndexKeyDroppingWithPersistence() {
        this.testAutoIndexKeyManagementWithPersistence();
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().isPersistent.booleanValue()) {
            if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
                graph.dropKeyIndex("name", Vertex.class);
            }
            if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
                graph.dropKeyIndex("weight", Edge.class);
            }
            graph.shutdown();
            graph = (KeyIndexableGraph)this.graphTest.generateGraph();
            if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)1);
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("location"));
                graph.dropKeyIndex("location", Vertex.class);
            }
            if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)1);
                KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("since"));
                graph.dropKeyIndex("since", Edge.class);
            }
            graph.shutdown();
            graph = (KeyIndexableGraph)this.graphTest.generateGraph();
            if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)0);
            }
            if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)0);
            }
        }
        graph.shutdown();
    }

    public void testGettingVerticesAndEdgesWithKeyValue() {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue() && graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
            graph.createKeyIndex("name", Vertex.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Vertex.class).size(), (int)1);
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Vertex.class).contains("name"));
            Vertex v1 = graph.addVertex(null);
            v1.setProperty("name", (Object)"marko");
            v1.setProperty("location", (Object)"everywhere");
            Vertex v2 = graph.addVertex(null);
            v2.setProperty("name", (Object)"stephen");
            v2.setProperty("location", (Object)"everywhere");
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices("location", (Object)"everywhere")), (int)2);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices("name", (Object)"marko")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices("name", (Object)"stephen")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getVertices("name", (Object)"marko").iterator().next(), (Object)v1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getVertices("name", (Object)"stephen").iterator().next(), (Object)v2);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue() && graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
            graph.createKeyIndex("place", Edge.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.assertEquals((int)graph.getIndexedKeys(Edge.class).size(), (int)1);
            KeyIndexableGraphTestSuite.assertTrue((boolean)graph.getIndexedKeys(Edge.class).contains("place"));
            Edge e1 = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            e1.setProperty("name", (Object)"marko");
            e1.setProperty("place", (Object)"everywhere");
            Edge e2 = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            e2.setProperty("name", (Object)"stephen");
            e2.setProperty("place", (Object)"everywhere");
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges("place", (Object)"everywhere")), (int)2);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges("name", (Object)"marko")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges("name", (Object)"stephen")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getEdges("name", (Object)"marko").iterator().next(), (Object)e1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getEdges("name", (Object)"stephen").iterator().next(), (Object)e2);
        }
        graph.shutdown();
    }

    public void testReIndexingOfElements() {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexKeyIndex.booleanValue()) {
            Vertex vertex = graph.addVertex(null);
            vertex.setProperty("name", (Object)"marko");
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices("name", (Object)"marko")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getVertices("name", (Object)"marko").iterator().next(), (Object)vertex);
            graph.createKeyIndex("name", Vertex.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices("name", (Object)"marko")), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getVertices("name", (Object)"marko").iterator().next(), (Object)vertex);
        }
        if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
            Edge edge = graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "knows");
            edge.setProperty("date", (Object)2012);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges("date", (Object)2012)), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getEdges("date", (Object)2012).iterator().next(), (Object)edge);
            graph.createKeyIndex("date", Edge.class, new Parameter[0]);
            KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges("date", (Object)2012)), (int)1);
            KeyIndexableGraphTestSuite.assertEquals(graph.getEdges("date", (Object)2012).iterator().next(), (Object)edge);
        }
        graph.shutdown();
    }

    public void testNoConcurrentModificationException() {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeKeyIndex.booleanValue()) {
            graph.createKeyIndex("key", Edge.class, new Parameter[0]);
            for (int i = 0; i < 25; ++i) {
                graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), "test").setProperty("key", (Object)"value");
            }
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices()), (int)50);
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges()), (int)25);
            }
            int counter = 0;
            for (Edge edge : graph.getEdges("key", (Object)"value")) {
                graph.removeEdge(edge);
                ++counter;
            }
            KeyIndexableGraphTestSuite.assertEquals((int)counter, (int)25);
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getVertices()), (int)50);
            }
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                KeyIndexableGraphTestSuite.assertEquals((int)KeyIndexableGraphTestSuite.count(graph.getEdges()), (int)0);
            }
        }
        graph.shutdown();
    }

    public void testKeyIndicesConsistentWithElementRemoval() throws Exception {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        graph.createKeyIndex("foo", Vertex.class, new Parameter[0]);
        Vertex v1 = graph.addVertex(null);
        v1.setProperty("foo", (Object)42);
        this.vertexCount((Graph)graph, 1);
        graph.removeVertex(v1);
        this.vertexCount((Graph)graph, 0);
        KeyIndexableGraphTestSuite.assertEquals((int)0, (int)KeyIndexableGraphTestSuite.count(graph.getVertices("foo", (Object)42)));
        graph.shutdown();
    }

    public void testUpdateValuesInIndexKeys() throws Exception {
        KeyIndexableGraph graph = (KeyIndexableGraph)this.graphTest.generateGraph();
        graph.createKeyIndex("name", Vertex.class, new Parameter[0]);
        if (graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).commit();
        }
        Vertex v1 = graph.addVertex(null);
        v1.setProperty("name", (Object)"marko");
        KeyIndexableGraphTestSuite.assertEquals((Object)v1.getProperty("name"), (Object)"marko");
        this.vertexCount((Graph)graph, 1);
        if (graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).commit();
        }
        v1 = (Vertex)graph.getVertices("name", (Object)"marko").iterator().next();
        KeyIndexableGraphTestSuite.assertEquals((Object)v1.getProperty("name"), (Object)"marko");
        v1.setProperty("name", (Object)"marko a. rodriguez");
        KeyIndexableGraphTestSuite.assertEquals((Object)v1.getProperty("name"), (Object)"marko a. rodriguez");
        this.vertexCount((Graph)graph, 1);
        if (graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).commit();
        }
        KeyIndexableGraphTestSuite.assertFalse((boolean)graph.getVertices("name", (Object)"marko").iterator().hasNext());
        v1 = (Vertex)graph.getVertices("name", (Object)"marko a. rodriguez").iterator().next();
        KeyIndexableGraphTestSuite.assertEquals((Object)v1.getProperty("name"), (Object)"marko a. rodriguez");
        this.vertexCount((Graph)graph, 1);
        if (graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).commit();
        }
        graph.shutdown();
    }
}

