/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.codehaus.jettison.json.JSONObject;

public class TransactionalGraphTestSuite
extends TestSuite {
    public TransactionalGraphTestSuite() {
    }

    public TransactionalGraphTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testTrue() {
        TransactionalGraphTestSuite.assertTrue((boolean)true);
    }

    public void testRepeatedTransactionStopException() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        graph.commit();
        graph.rollback();
        graph.commit();
        graph.shutdown();
    }

    public void testAutoStartTransaction() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        this.vertexCount((Graph)graph, 1);
        TransactionalGraphTestSuite.assertEquals((Object)v1.getId(), (Object)graph.getVertex(v1.getId()).getId());
        graph.commit();
        this.vertexCount((Graph)graph, 1);
        TransactionalGraphTestSuite.assertEquals((Object)v1.getId(), (Object)graph.getVertex(v1.getId()).getId());
        graph.shutdown();
    }

    public void testTransactionsForVertices() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        ArrayList<Vertex> vin = new ArrayList<Vertex>();
        ArrayList<Vertex> vout = new ArrayList<Vertex>();
        vin.add(graph.addVertex(null));
        graph.commit();
        this.vertexCount((Graph)graph, 1);
        this.containsVertices((Graph)graph, vin);
        this.stopWatch();
        vout.add(graph.addVertex(null));
        this.vertexCount((Graph)graph, 2);
        this.containsVertices((Graph)graph, vin);
        this.containsVertices((Graph)graph, vout);
        graph.rollback();
        this.containsVertices((Graph)graph, vin);
        this.vertexCount((Graph)graph, 1);
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex not added in failed transaction", this.stopWatch());
        this.stopWatch();
        vin.add(graph.addVertex(null));
        this.vertexCount((Graph)graph, 2);
        this.containsVertices((Graph)graph, vin);
        graph.commit();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex added in successful transaction", this.stopWatch());
        this.vertexCount((Graph)graph, 2);
        this.containsVertices((Graph)graph, vin);
        graph.shutdown();
    }

    public void testBasicVertexEdgeTransactions() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        Vertex v = graph.addVertex(null);
        graph.addEdge(null, v, v, this.graphTest.convertLabel("self"));
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getEdges(Direction.IN, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getEdges(Direction.OUT, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals(v.getEdges(Direction.IN, new String[0]).iterator().next(), v.getEdges(Direction.OUT, new String[0]).iterator().next());
        graph.commit();
        v = graph.getVertex(v.getId());
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getEdges(Direction.IN, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getEdges(Direction.OUT, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals(v.getEdges(Direction.IN, new String[0]).iterator().next(), v.getEdges(Direction.OUT, new String[0]).iterator().next());
        graph.commit();
        v = graph.getVertex(v.getId());
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getVertices(Direction.IN, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(v.getVertices(Direction.OUT, new String[0])), (int)1);
        TransactionalGraphTestSuite.assertEquals(v.getVertices(Direction.IN, new String[0]).iterator().next(), v.getVertices(Direction.OUT, new String[0]).iterator().next());
        graph.commit();
        graph.shutdown();
    }

    public void testBruteVertexTransactions() {
        int i;
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        ArrayList<Vertex> vin = new ArrayList<Vertex>();
        ArrayList<Vertex> vout = new ArrayList<Vertex>();
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            vin.add(graph.addVertex(null));
            graph.commit();
        }
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "vertices added in 100 successful transactions", this.stopWatch());
        this.vertexCount((Graph)graph, 100);
        this.containsVertices((Graph)graph, vin);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            vout.add(graph.addVertex(null));
            graph.rollback();
        }
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "vertices not added in 100 failed transactions", this.stopWatch());
        this.vertexCount((Graph)graph, 100);
        this.containsVertices((Graph)graph, vin);
        graph.rollback();
        this.vertexCount((Graph)graph, 100);
        this.containsVertices((Graph)graph, vin);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            vin.add(graph.addVertex(null));
        }
        this.vertexCount((Graph)graph, 200);
        this.containsVertices((Graph)graph, vin);
        graph.commit();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "vertices added in 1 successful transactions", this.stopWatch());
        this.vertexCount((Graph)graph, 200);
        this.containsVertices((Graph)graph, vin);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            vout.add(graph.addVertex(null));
        }
        this.vertexCount((Graph)graph, 300);
        this.containsVertices((Graph)graph, vin);
        this.containsVertices((Graph)graph, vout.subList(100, 200));
        graph.rollback();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "vertices not added in 1 failed transactions", this.stopWatch());
        this.vertexCount((Graph)graph, 200);
        this.containsVertices((Graph)graph, vin);
        graph.shutdown();
    }

    public void testTransactionsForEdges() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        Vertex v = graph.addVertex(null);
        Vertex u = graph.addVertex(null);
        graph.commit();
        this.stopWatch();
        Edge e = graph.addEdge(null, graph.getVertex(v.getId()), graph.getVertex(u.getId()), this.graphTest.convertLabel("test"));
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)v);
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(u.getId()), (Object)u);
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((Object)graph.getEdge(e.getId()), (Object)e);
        }
        this.vertexCount((Graph)graph, 2);
        this.edgeCount((Graph)graph, 1);
        graph.rollback();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "edge not added in failed transaction (w/ iteration)", this.stopWatch());
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)v);
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(u.getId()), (Object)u);
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            TransactionalGraphTestSuite.assertNull((Object)graph.getEdge(e.getId()));
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getVertices()), (int)2);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getEdges()), (int)0);
        }
        this.stopWatch();
        e = graph.addEdge(null, graph.getVertex(u.getId()), graph.getVertex(v.getId()), this.graphTest.convertLabel("test"));
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)v);
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(u.getId()), (Object)u);
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((Object)graph.getEdge(e.getId()), (Object)e);
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getVertices()), (int)2);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getEdges()), (int)1);
        }
        TransactionalGraphTestSuite.assertEquals((Object)e, TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(u.getId()).getEdges(Direction.OUT, new String[0])));
        graph.commit();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "edge added in successful transaction (w/ iteration)", this.stopWatch());
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getVertices()), (int)2);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(graph.getEdges()), (int)1);
        }
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)v);
        TransactionalGraphTestSuite.assertEquals((Object)graph.getVertex(u.getId()), (Object)u);
        if (graph.getFeatures().supportsEdgeRetrieval.booleanValue()) {
            TransactionalGraphTestSuite.assertEquals((Object)graph.getEdge(e.getId()), (Object)e);
        }
        TransactionalGraphTestSuite.assertEquals((Object)e, TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(u.getId()).getEdges(Direction.OUT, new String[0])));
        graph.shutdown();
    }

    public void testBruteEdgeTransactions() {
        Vertex u;
        Vertex v;
        int i;
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            v = graph.addVertex(null);
            u = graph.addVertex(null);
            graph.addEdge(null, v, u, this.graphTest.convertLabel("test"));
            graph.commit();
        }
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "edges added in 100 successful transactions (2 vertices added for each edge)", this.stopWatch());
        this.vertexCount((Graph)graph, 200);
        this.edgeCount((Graph)graph, 100);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            v = graph.addVertex(null);
            u = graph.addVertex(null);
            graph.addEdge(null, v, u, this.graphTest.convertLabel("test"));
            graph.rollback();
        }
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "edges not added in 100 failed transactions (2 vertices added for each edge)", this.stopWatch());
        this.vertexCount((Graph)graph, 200);
        this.edgeCount((Graph)graph, 100);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            v = graph.addVertex(null);
            u = graph.addVertex(null);
            graph.addEdge(null, v, u, this.graphTest.convertLabel("test"));
        }
        this.vertexCount((Graph)graph, 400);
        this.edgeCount((Graph)graph, 200);
        graph.commit();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "edges added in 1 successful transactions (2 vertices added for each edge)", this.stopWatch());
        this.vertexCount((Graph)graph, 400);
        this.edgeCount((Graph)graph, 200);
        this.stopWatch();
        for (i = 0; i < 100; ++i) {
            v = graph.addVertex(null);
            u = graph.addVertex(null);
            graph.addEdge(null, v, u, this.graphTest.convertLabel("test"));
        }
        this.vertexCount((Graph)graph, 600);
        this.edgeCount((Graph)graph, 300);
        graph.rollback();
        TransactionalGraphTestSuite.printPerformance(graph.toString(), 100, "edges not added in 1 failed transactions (2 vertices added for each edge)", this.stopWatch());
        this.vertexCount((Graph)graph, 400);
        this.edgeCount((Graph)graph, 200);
        graph.shutdown();
    }

    public void testPropertyTransactions() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsElementProperties()) {
            this.stopWatch();
            Vertex v = graph.addVertex(null);
            Object id = v.getId();
            v.setProperty("name", (Object)"marko");
            graph.commit();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex added with string property in a successful transaction", this.stopWatch());
            this.stopWatch();
            v = graph.getVertex(id);
            TransactionalGraphTestSuite.assertNotNull((Object)v);
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
            v.setProperty("age", (Object)30);
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("age"), (Object)30);
            graph.rollback();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "integer property not added in a failed transaction", this.stopWatch());
            this.stopWatch();
            v = graph.getVertex(id);
            TransactionalGraphTestSuite.assertNotNull((Object)v);
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
            TransactionalGraphTestSuite.assertNull((Object)v.getProperty("age"));
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 2, "vertex properties checked in a successful transaction", this.stopWatch());
            Edge edge = graph.addEdge(null, v, graph.addVertex(null), "test");
            this.edgeCount((Graph)graph, 1);
            graph.commit();
            this.edgeCount((Graph)graph, 1);
            edge = (Edge)TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v.getId()).getEdges(Direction.OUT, new String[0]));
            TransactionalGraphTestSuite.assertNotNull((Object)edge);
            this.stopWatch();
            edge.setProperty("transaction-1", (Object)"success");
            TransactionalGraphTestSuite.assertEquals((Object)edge.getProperty("transaction-1"), (Object)"success");
            graph.commit();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "edge property added and checked in a successful transaction", this.stopWatch());
            edge = (Edge)TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v.getId()).getEdges(Direction.OUT, new String[0]));
            TransactionalGraphTestSuite.assertEquals((Object)edge.getProperty("transaction-1"), (Object)"success");
            this.stopWatch();
            edge.setProperty("transaction-2", (Object)"failure");
            TransactionalGraphTestSuite.assertEquals((Object)edge.getProperty("transaction-1"), (Object)"success");
            TransactionalGraphTestSuite.assertEquals((Object)edge.getProperty("transaction-2"), (Object)"failure");
            graph.rollback();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "edge property added and checked in a failed transaction", this.stopWatch());
            edge = (Edge)TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v.getId()).getEdges(Direction.OUT, new String[0]));
            TransactionalGraphTestSuite.assertEquals((Object)edge.getProperty("transaction-1"), (Object)"success");
            TransactionalGraphTestSuite.assertNull((Object)edge.getProperty("transaction-2"));
        }
        graph.shutdown();
    }

    public void testIndexTransactions() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
            this.stopWatch();
            Index index = ((IndexableGraph)graph).createIndex("txIdx", Vertex.class, new Parameter[0]);
            Vertex v = graph.addVertex(null);
            Object id = v.getId();
            v.setProperty("name", (Object)"marko");
            index.put("name", (Object)"marko", (Element)v);
            this.vertexCount((Graph)graph, 1);
            v = (Vertex)TransactionalGraphTestSuite.getOnlyElement(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"marko"));
            TransactionalGraphTestSuite.assertEquals((Object)v.getId(), (Object)id);
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
            graph.commit();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex added and retrieved from index in a successful transaction", this.stopWatch());
            this.stopWatch();
            this.vertexCount((Graph)graph, 1);
            v = (Vertex)TransactionalGraphTestSuite.getOnlyElement(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"marko"));
            TransactionalGraphTestSuite.assertEquals((Object)v.getId(), (Object)id);
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex retrieved from index outside successful transaction", this.stopWatch());
            this.stopWatch();
            v = graph.addVertex(null);
            v.setProperty("name", (Object)"pavel");
            index.put("name", (Object)"pavel", (Element)v);
            this.vertexCount((Graph)graph, 2);
            v = (Vertex)TransactionalGraphTestSuite.getOnlyElement(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"marko"));
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
            v = (Vertex)TransactionalGraphTestSuite.getOnlyElement(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"pavel"));
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"pavel");
            graph.rollback();
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex not added in a failed transaction", this.stopWatch());
            this.stopWatch();
            this.vertexCount((Graph)graph, 1);
            TransactionalGraphTestSuite.assertEquals((int)TransactionalGraphTestSuite.count(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"pavel")), (int)0);
            TransactionalGraphTestSuite.printPerformance(graph.toString(), 1, "vertex not retrieved in a successful transaction", this.stopWatch());
            v = (Vertex)TransactionalGraphTestSuite.getOnlyElement(((IndexableGraph)graph).getIndex("txIdx", Vertex.class).get("name", (Object)"marko"));
            TransactionalGraphTestSuite.assertEquals((Object)v.getProperty("name"), (Object)"marko");
        }
        graph.shutdown();
    }

    public void testAutomaticSuccessfulTransactionOnShutdown() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().isPersistent.booleanValue() && graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v = graph.addVertex(null);
            Object id = v.getId();
            v.setProperty("count", (Object)"1");
            v.setProperty("count", (Object)"2");
            graph.shutdown();
            graph = (TransactionalGraph)this.graphTest.generateGraph();
            Vertex reloadedV = graph.getVertex(id);
            TransactionalGraphTestSuite.assertEquals((Object)"2", (Object)reloadedV.getProperty("count"));
        }
        graph.shutdown();
    }

    public void testVertexCountOnPreTransactionCommit() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        graph.commit();
        this.vertexCount((Graph)graph, 1);
        Vertex v2 = graph.addVertex(null);
        v1 = graph.getVertex(v1.getId());
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("friend"));
        this.vertexCount((Graph)graph, 2);
        graph.commit();
        this.vertexCount((Graph)graph, 2);
        graph.shutdown();
    }

    public void testVertexPropertiesOnPreTransactionCommit() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v1 = graph.addVertex(null);
            v1.setProperty("name", (Object)"marko");
            TransactionalGraphTestSuite.assertEquals((int)1, (int)v1.getPropertyKeys().size());
            TransactionalGraphTestSuite.assertTrue((boolean)v1.getPropertyKeys().contains("name"));
            TransactionalGraphTestSuite.assertEquals((Object)"marko", (Object)v1.getProperty("name"));
            graph.commit();
            TransactionalGraphTestSuite.assertEquals((Object)"marko", (Object)v1.getProperty("name"));
        }
        graph.shutdown();
    }

    public void testBulkTransactionsOnEdges() {
        int i;
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        for (i = 0; i < 5; ++i) {
            graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("test"));
        }
        this.edgeCount((Graph)graph, 5);
        graph.rollback();
        this.edgeCount((Graph)graph, 0);
        for (i = 0; i < 4; ++i) {
            graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("test"));
        }
        this.edgeCount((Graph)graph, 4);
        graph.rollback();
        this.edgeCount((Graph)graph, 0);
        for (i = 0; i < 3; ++i) {
            graph.addEdge(null, graph.addVertex(null), graph.addVertex(null), this.graphTest.convertLabel("test"));
        }
        this.edgeCount((Graph)graph, 3);
        graph.commit();
        this.edgeCount((Graph)graph, 3);
        graph.shutdown();
    }

    public void testCompetingThreads() {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        int totalThreads = 250;
        final AtomicInteger vertices = new AtomicInteger(0);
        final AtomicInteger edges = new AtomicInteger(0);
        final AtomicInteger completedThreads = new AtomicInteger(0);
        for (int i = 0; i < totalThreads; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Random random = new Random();
                    if (random.nextBoolean()) {
                        Vertex a = graph.addVertex(null);
                        Vertex b = graph.addVertex(null);
                        Edge e = graph.addEdge(null, a, b, TransactionalGraphTestSuite.this.graphTest.convertLabel("friend"));
                        if (graph.getFeatures().supportsElementProperties()) {
                            a.setProperty("test", (Object)this.getId());
                            b.setProperty("blah", (Object)Float.valueOf(random.nextFloat()));
                            e.setProperty("bloop", (Object)random.nextInt());
                        }
                        vertices.getAndAdd(2);
                        edges.getAndAdd(1);
                        graph.commit();
                    } else {
                        Vertex a = graph.addVertex(null);
                        Vertex b = graph.addVertex(null);
                        Edge e = graph.addEdge(null, a, b, TransactionalGraphTestSuite.this.graphTest.convertLabel("friend"));
                        if (graph.getFeatures().supportsElementProperties()) {
                            a.setProperty("test", (Object)this.getId());
                            b.setProperty("blah", (Object)Float.valueOf(random.nextFloat()));
                            e.setProperty("bloop", (Object)random.nextInt());
                        }
                        if (random.nextBoolean()) {
                            graph.commit();
                            vertices.getAndAdd(2);
                            edges.getAndAdd(1);
                        } else {
                            graph.rollback();
                        }
                    }
                    completedThreads.getAndAdd(1);
                }
            }.start();
        }
        while (completedThreads.get() < totalThreads) {
        }
        TransactionalGraphTestSuite.assertEquals((int)completedThreads.get(), (int)250);
        this.edgeCount((Graph)graph, edges.get());
        this.vertexCount((Graph)graph, vertices.get());
        graph.shutdown();
    }

    public void testCompetingThreadsOnMultipleDbInstances() throws Exception {
        this.graphTest.dropGraph("first");
        this.graphTest.dropGraph("second");
        final TransactionalGraph graph1 = (TransactionalGraph)this.graphTest.generateGraph("first");
        final TransactionalGraph graph2 = (TransactionalGraph)this.graphTest.generateGraph("second");
        Thread threadModFirstGraph = new Thread(){

            @Override
            public void run() {
                Vertex v = graph1.addVertex(null);
                graph1.commit();
            }
        };
        threadModFirstGraph.start();
        threadModFirstGraph.join();
        Thread threadReadBothGraphs = new Thread(){

            @Override
            public void run() {
                int counter = 0;
                for (Vertex v : graph1.getVertices()) {
                    ++counter;
                }
                TestCase.assertEquals((int)1, (int)counter);
                counter = 0;
                for (Vertex v : graph2.getVertices()) {
                    ++counter;
                }
                TestCase.assertEquals((int)0, (int)counter);
            }
        };
        threadReadBothGraphs.start();
        threadReadBothGraphs.join();
        graph1.shutdown();
        this.graphTest.dropGraph("first");
        graph2.shutdown();
        this.graphTest.dropGraph("second");
    }

    public void testTransactionIsolationCommitCheck() throws Exception {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        final CountDownLatch latchCommittedInOtherThread = new CountDownLatch(1);
        final CountDownLatch latchCommitInOtherThread = new CountDownLatch(1);
        Thread threadTxStarter = new Thread(){

            @Override
            public void run() {
                Vertex v = graph.addVertex(null);
                latchCommitInOtherThread.countDown();
                try {
                    latchCommittedInOtherThread.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.rollback();
                TestCase.assertFalse((boolean)graph.getVertices().iterator().hasNext());
            }
        };
        threadTxStarter.start();
        Thread threadTryCommitTx = new Thread(){

            @Override
            public void run() {
                try {
                    latchCommitInOtherThread.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.commit();
                latchCommittedInOtherThread.countDown();
            }
        };
        threadTryCommitTx.start();
        threadTxStarter.join();
        threadTryCommitTx.join();
        graph.shutdown();
    }

    public void testRemoveInTransaction() {
        TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        this.edgeCount((Graph)graph, 0);
        Vertex v1 = graph.addVertex(null);
        Object v1id = v1.getId();
        Vertex v2 = graph.addVertex(null);
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("test-edge"));
        graph.commit();
        this.edgeCount((Graph)graph, 1);
        Edge e1 = (Edge)TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v1id).getEdges(Direction.OUT, new String[0]));
        TransactionalGraphTestSuite.assertNotNull((Object)e1);
        graph.removeEdge(e1);
        this.edgeCount((Graph)graph, 0);
        TransactionalGraphTestSuite.assertNull(TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v1id).getEdges(Direction.OUT, new String[0])));
        graph.rollback();
        this.edgeCount((Graph)graph, 1);
        e1 = (Edge)TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v1id).getEdges(Direction.OUT, new String[0]));
        TransactionalGraphTestSuite.assertNotNull((Object)e1);
        graph.removeEdge(e1);
        graph.commit();
        this.edgeCount((Graph)graph, 0);
        TransactionalGraphTestSuite.assertNull(TransactionalGraphTestSuite.getOnlyElement(graph.getVertex(v1id).getEdges(Direction.OUT, new String[0])));
        graph.shutdown();
    }

    public void untestSimulateRexsterIntegrationTests() throws Exception {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsKeyIndices.booleanValue()) {
            String id = "_ID";
            ((KeyIndexableGraph)graph).createKeyIndex("_ID", Vertex.class, new Parameter[0]);
            int numberOfVerticesToCreate = 100;
            final Random rand = new Random(12356L);
            final ArrayList graphAssignedIds = new ArrayList();
            ExecutorService executorService = Executors.newFixedThreadPool(4);
            for (int ix = 0; ix < 100; ++ix) {
                final int id1 = ix;
                final int id2 = ix + 100 + rand.nextInt();
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex v = graph.addVertex(null);
                        v.setProperty("_ID", (Object)id1);
                        graph.commit();
                        graphAssignedIds.add(v.getId().toString());
                    }
                }).get();
                if (ix <= 0) continue;
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex v = graph.addVertex(null);
                        v.setProperty("_ID", (Object)id2);
                        graph.commit();
                        graphAssignedIds.add(v.getId().toString());
                    }
                }).get();
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex vActual1 = graph.getVertex(graphAssignedIds.get(rand.nextInt(graphAssignedIds.size())));
                        Vertex vActual2 = graph.getVertex(graphAssignedIds.get(rand.nextInt(graphAssignedIds.size())));
                        Edge e = graph.addEdge(null, vActual1, vActual2, "knows");
                        e.setProperty("weight", (Object)Float.valueOf(rand.nextFloat()));
                        JSONObject elementJson = null;
                        try {
                            elementJson = GraphSONUtility.jsonFromElement((Element)e, null, (GraphSONMode)GraphSONMode.NORMAL);
                        }
                        catch (Exception ex) {
                            TestCase.fail();
                        }
                        graph.commit();
                        try {
                            if (elementJson != null) {
                                elementJson.put("_ID", e.getId());
                            }
                        }
                        catch (Exception ex) {
                            TestCase.fail();
                        }
                    }
                }).get();
            }
            HashSet<String> ids = new HashSet<String>();
            for (Vertex v : graph.getVertices()) {
                ids.add(v.getId().toString());
            }
            for (final String idToRemove : ids) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex toRemove = graph.getVertex((Object)idToRemove);
                        graph.removeVertex(toRemove);
                        graph.commit();
                    }
                });
            }
            executorService.shutdown();
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        graph.shutdown();
    }

    public void untestSimulateRexsterIntegrationTestsWithRetries() throws Exception {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        if (graph.getFeatures().supportsKeyIndices.booleanValue()) {
            String id = "_ID";
            ((KeyIndexableGraph)graph).createKeyIndex("_ID", Vertex.class, new Parameter[0]);
            int maxRetries = 10;
            int numberOfVerticesToCreate = 100;
            final Random rand = new Random(12356L);
            final ArrayList graphAssignedIds = new ArrayList();
            ExecutorService executorService = Executors.newFixedThreadPool(4);
            for (int ix = 0; ix < 100; ++ix) {
                final int id1 = ix;
                final int id2 = ix + 100 + rand.nextInt();
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex v = graph.addVertex(null);
                        v.setProperty("_ID", (Object)id1);
                        graph.commit();
                        graphAssignedIds.add(v.getId().toString());
                    }
                }).get();
                if (ix <= 0) continue;
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex v = graph.addVertex(null);
                        v.setProperty("_ID", (Object)id2);
                        graph.commit();
                        graphAssignedIds.add(v.getId().toString());
                    }
                }).get();
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        int v1 = rand.nextInt(graphAssignedIds.size());
                        int v2 = rand.nextInt(graphAssignedIds.size());
                        for (int retry = 0; retry < 10; ++retry) {
                            try {
                                Vertex vActual1 = graph.getVertex(graphAssignedIds.get(v1));
                                Vertex vActual2 = graph.getVertex(graphAssignedIds.get(v2));
                                Edge e = graph.addEdge(null, vActual1, vActual2, "knows");
                                e.setProperty("weight", (Object)Float.valueOf(rand.nextFloat()));
                                JSONObject elementJson = GraphSONUtility.jsonFromElement((Element)e, null, (GraphSONMode)GraphSONMode.NORMAL);
                                graph.commit();
                                if (elementJson == null) break;
                                elementJson.put("_ID", e.getId());
                                break;
                            }
                            catch (Exception ex) {
                                if (ex.getClass().getSimpleName().equals("OConcurrentModificationException")) continue;
                                TestCase.fail((String)ex.getMessage());
                                continue;
                            }
                        }
                    }
                }).get();
            }
            HashSet<String> ids = new HashSet<String>();
            for (Vertex v : graph.getVertices()) {
                ids.add(v.getId().toString());
            }
            for (final String idToRemove : ids) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Vertex toRemove = graph.getVertex((Object)idToRemove);
                        graph.removeVertex(toRemove);
                        graph.commit();
                    }
                });
            }
            executorService.shutdown();
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        graph.shutdown();
    }

    public void untestTransactionVertexPropertiesAcrossThreads() throws Exception {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        final AtomicReference v = new AtomicReference();
        Thread thread = new Thread(){

            @Override
            public void run() {
                Vertex vertex = graph.addVertex(null);
                vertex.setProperty("name", (Object)"stephen");
                v.set(vertex);
            }
        };
        thread.start();
        thread.join();
        Set k = ((Vertex)v.get()).getPropertyKeys();
        TransactionalGraphTestSuite.assertTrue((boolean)k.contains("name"));
        TransactionalGraphTestSuite.assertEquals((Object)"stephen", (Object)((Vertex)v.get()).getProperty("name"));
    }

    public void untestTransactionIsolationWithSeparateThreads() throws Exception {
        final TransactionalGraph graph = (TransactionalGraph)this.graphTest.generateGraph();
        final CountDownLatch latchCommit = new CountDownLatch(1);
        final CountDownLatch latchFirstRead = new CountDownLatch(1);
        final CountDownLatch latchSecondRead = new CountDownLatch(1);
        Thread threadMod = new Thread(){

            @Override
            public void run() {
                Vertex v = graph.addVertex(null);
                latchFirstRead.countDown();
                try {
                    latchCommit.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.commit();
                latchSecondRead.countDown();
            }
        };
        threadMod.start();
        Thread threadRead = new Thread(){

            @Override
            public void run() {
                try {
                    latchFirstRead.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                TestCase.assertFalse((boolean)graph.getVertices().iterator().hasNext());
                latchCommit.countDown();
                try {
                    latchSecondRead.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                TestCase.assertTrue((boolean)graph.getVertices().iterator().hasNext());
            }
        };
        threadRead.start();
        threadMod.join();
        threadRead.join();
        graph.shutdown();
    }
}

