/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import java.util.HashSet;
import java.util.UUID;

public class VertexTestSuite
extends TestSuite {
    public VertexTestSuite() {
    }

    public VertexTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testVertexEquality() {
        Vertex u;
        Vertex v;
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            v = graph.addVertex(this.graphTest.convertId("1"));
            u = graph.getVertex(this.graphTest.convertId("1"));
            VertexTestSuite.assertEquals((Object)v, (Object)u);
        }
        this.stopWatch();
        v = graph.addVertex(null);
        VertexTestSuite.assertNotNull((Object)v);
        u = graph.getVertex(v.getId());
        VertexTestSuite.assertNotNull((Object)u);
        VertexTestSuite.assertEquals((Object)v, (Object)u);
        VertexTestSuite.printPerformance(graph.toString(), 1, "vertex added and retrieved", this.stopWatch());
        VertexTestSuite.assertEquals((Object)graph.getVertex(u.getId()), (Object)graph.getVertex(u.getId()));
        VertexTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)graph.getVertex(u.getId()));
        VertexTestSuite.assertEquals((Object)graph.getVertex(v.getId()), (Object)graph.getVertex(v.getId()));
        graph.shutdown();
    }

    public void testVertexEqualityForSuppliedIdsAndHashCode() {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            Vertex v = graph.addVertex(this.graphTest.convertId("1"));
            Vertex u = graph.getVertex(this.graphTest.convertId("1"));
            HashSet<Object> set = new HashSet<Object>();
            set.add(v);
            set.add(v);
            set.add(u);
            set.add(u);
            set.add(graph.getVertex(this.graphTest.convertId("1")));
            set.add(graph.getVertex(this.graphTest.convertId("1")));
            if (graph.getFeatures().supportsVertexIndex.booleanValue()) {
                set.add(graph.getVertices().iterator().next());
            }
            VertexTestSuite.assertEquals((int)1, (int)set.size());
            VertexTestSuite.assertEquals((int)v.hashCode(), (int)u.hashCode());
        }
        graph.shutdown();
    }

    public void testBasicAddVertex() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            graph.addVertex(this.graphTest.convertId("1"));
            graph.addVertex(this.graphTest.convertId("2"));
            VertexTestSuite.assertEquals((int)2, (int)VertexTestSuite.count(graph.getVertices()));
            graph.addVertex(this.graphTest.convertId("3"));
            VertexTestSuite.assertEquals((int)3, (int)VertexTestSuite.count(graph.getVertices()));
        }
        graph.shutdown();
    }

    public void testGetVertexWithNull() {
        Graph graph = this.graphTest.generateGraph();
        try {
            graph.getVertex(null);
            VertexTestSuite.assertFalse((boolean)true);
        }
        catch (IllegalArgumentException e) {
            VertexTestSuite.assertTrue((boolean)true);
        }
        graph.shutdown();
    }

    public void testRemoveVertex() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            VertexTestSuite.assertEquals((Object)graph.getVertex(this.graphTest.convertId("1")), (Object)v1);
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)1, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        graph.removeVertex(v1);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        for (int i = 0; i < 100; ++i) {
            vertices.add(graph.addVertex(null));
        }
        VertexTestSuite.assertEquals((int)vertices.size(), (int)100);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)100, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        for (Vertex v : vertices) {
            graph.removeVertex(v);
        }
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        graph.shutdown();
    }

    public void testRemoveVertexWithEdges() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
        Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
        graph.addEdge(null, v1, v2, this.graphTest.convertLabel("knows"));
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)2, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)1, (int)VertexTestSuite.count(graph.getEdges()));
        }
        graph.removeVertex(v1);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)1, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        graph.removeVertex(v2);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getVertices()));
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getEdges()));
        }
        graph.shutdown();
    }

    public void testGetNonExistantVertices() {
        Graph graph = this.graphTest.generateGraph();
        VertexTestSuite.assertNull((Object)graph.getVertex((Object)"asbv"));
        VertexTestSuite.assertNull((Object)graph.getVertex((Object)12.0));
        graph.shutdown();
    }

    public void testRemoveVertexNullId() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)1, (int)VertexTestSuite.count(graph.getVertices()));
        }
        graph.removeVertex(v1);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getVertices()));
        }
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        this.stopWatch();
        int vertexCount = 100;
        for (int i = 0; i < vertexCount; ++i) {
            vertices.add(graph.addVertex(null));
        }
        VertexTestSuite.printPerformance(graph.toString(), vertexCount, "vertices added", this.stopWatch());
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)vertexCount, (int)VertexTestSuite.count(graph.getVertices()));
        }
        this.stopWatch();
        for (Vertex v : vertices) {
            graph.removeVertex(v);
        }
        VertexTestSuite.printPerformance(graph.toString(), vertexCount, "vertices removed", this.stopWatch());
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)0, (int)VertexTestSuite.count(graph.getVertices()));
        }
        graph.shutdown();
    }

    public void testVertexIterator() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            int vertexCount = 1000;
            HashSet<Object> ids = new HashSet<Object>(1000);
            for (int i = 0; i < vertexCount; ++i) {
                ids.add(graph.addVertex(null).getId());
            }
            VertexTestSuite.printPerformance(graph.toString(), vertexCount, "vertices added", this.stopWatch());
            this.stopWatch();
            VertexTestSuite.assertEquals((int)vertexCount, (int)VertexTestSuite.count(graph.getVertices()));
            VertexTestSuite.printPerformance(graph.toString(), vertexCount, "vertices counted", this.stopWatch());
            VertexTestSuite.assertEquals((int)vertexCount, (int)ids.size());
        }
        graph.shutdown();
    }

    public void testLegalVertexEdgeIterables() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v1 = graph.addVertex(null);
        for (int i = 0; i < 10; ++i) {
            graph.addEdge(null, v1, graph.addVertex(null), this.graphTest.convertLabel("knows"));
        }
        Iterable edges = v1.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")});
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(edges), (int)10);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(edges), (int)10);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(edges), (int)10);
        graph.shutdown();
    }

    public void testAddVertexProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v1 = graph.addVertex(this.graphTest.convertId("1"));
            Vertex v2 = graph.addVertex(this.graphTest.convertId("2"));
            if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                v1.setProperty("key1", (Object)"value1");
                VertexTestSuite.assertEquals((Object)"value1", (Object)v1.getProperty("key1"));
            }
            if (graph.getFeatures().supportsIntegerProperty.booleanValue()) {
                v1.setProperty("key2", (Object)10);
                v2.setProperty("key2", (Object)20);
                VertexTestSuite.assertEquals((Object)10, (Object)v1.getProperty("key2"));
                VertexTestSuite.assertEquals((Object)20, (Object)v2.getProperty("key2"));
            }
        }
        graph.shutdown();
    }

    public void testAddManyVertexProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue() && graph.getFeatures().supportsStringProperty.booleanValue()) {
            HashSet<Vertex> vertices = new HashSet<Vertex>();
            this.stopWatch();
            for (int i = 0; i < 50; ++i) {
                Vertex vertex = graph.addVertex(null);
                for (int j = 0; j < 15; ++j) {
                    vertex.setProperty(UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
                }
                vertices.add(vertex);
            }
            VertexTestSuite.printPerformance(graph.toString(), 750, "vertex properties added (with vertices being added too)", this.stopWatch());
            if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
                VertexTestSuite.assertEquals((int)50, (int)VertexTestSuite.count(graph.getVertices()));
            }
            VertexTestSuite.assertEquals((int)50, (int)vertices.size());
            for (Vertex vertex : vertices) {
                VertexTestSuite.assertEquals((int)15, (int)vertex.getPropertyKeys().size());
            }
        }
        graph.shutdown();
    }

    public void testRemoveVertexProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v1 = graph.addVertex((Object)"1");
            Vertex v2 = graph.addVertex((Object)"2");
            VertexTestSuite.assertNull((Object)v1.removeProperty("key1"));
            VertexTestSuite.assertNull((Object)v1.removeProperty("key2"));
            VertexTestSuite.assertNull((Object)v2.removeProperty("key2"));
            if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                v1.setProperty("key1", (Object)"value1");
                VertexTestSuite.assertEquals((Object)"value1", (Object)v1.removeProperty("key1"));
            }
            if (graph.getFeatures().supportsIntegerProperty.booleanValue()) {
                v1.setProperty("key2", (Object)10);
                v2.setProperty("key2", (Object)20);
                VertexTestSuite.assertEquals((Object)10, (Object)v1.removeProperty("key2"));
                VertexTestSuite.assertEquals((Object)20, (Object)v2.removeProperty("key2"));
            }
            VertexTestSuite.assertNull((Object)v1.removeProperty("key1"));
            VertexTestSuite.assertNull((Object)v1.removeProperty("key2"));
            VertexTestSuite.assertNull((Object)v2.removeProperty("key2"));
            if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                v1.setProperty("key1", (Object)"value1");
            }
            if (graph.getFeatures().supportsIntegerProperty.booleanValue()) {
                v1.setProperty("key2", (Object)10);
                v2.setProperty("key2", (Object)20);
            }
            if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
                v1 = graph.getVertex((Object)"1");
                v2 = graph.getVertex((Object)"2");
                if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                    VertexTestSuite.assertEquals((Object)"value1", (Object)v1.removeProperty("key1"));
                }
                if (graph.getFeatures().supportsIntegerProperty.booleanValue()) {
                    VertexTestSuite.assertEquals((Object)10, (Object)v1.removeProperty("key2"));
                    VertexTestSuite.assertEquals((Object)20, (Object)v2.removeProperty("key2"));
                }
                VertexTestSuite.assertNull((Object)v1.removeProperty("key1"));
                VertexTestSuite.assertNull((Object)v1.removeProperty("key2"));
                VertexTestSuite.assertNull((Object)v2.removeProperty("key2"));
                v1 = graph.getVertex((Object)"1");
                v2 = graph.getVertex((Object)"2");
                if (graph.getFeatures().supportsStringProperty.booleanValue()) {
                    v1.setProperty("key1", (Object)"value2");
                    VertexTestSuite.assertEquals((Object)"value2", (Object)v1.removeProperty("key1"));
                }
                if (graph.getFeatures().supportsIntegerProperty.booleanValue()) {
                    v1.setProperty("key2", (Object)20);
                    v2.setProperty("key2", (Object)30);
                    VertexTestSuite.assertEquals((Object)20, (Object)v1.removeProperty("key2"));
                    VertexTestSuite.assertEquals((Object)30, (Object)v2.removeProperty("key2"));
                }
                VertexTestSuite.assertNull((Object)v1.removeProperty("key1"));
                VertexTestSuite.assertNull((Object)v1.removeProperty("key2"));
                VertexTestSuite.assertNull((Object)v2.removeProperty("key2"));
            }
        }
        graph.shutdown();
    }

    public void testAddingIdProperty() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex vertex = graph.addVertex(null);
            try {
                vertex.setProperty("id", (Object)"123");
                VertexTestSuite.assertTrue((boolean)false);
            }
            catch (IllegalArgumentException e) {
                VertexTestSuite.assertTrue((boolean)true);
            }
        }
        graph.shutdown();
    }

    public void testNoConcurrentModificationException() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            for (int i = 0; i < 25; ++i) {
                graph.addVertex(null);
            }
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getVertices()), (int)25);
            for (Vertex vertex : graph.getVertices()) {
                graph.removeVertex(vertex);
            }
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getVertices()), (int)0);
        }
        graph.shutdown();
    }

    public void testGettingEdgesAndVertices() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        Vertex c = graph.addVertex(null);
        Edge w = graph.addEdge(null, a, b, this.graphTest.convertLabel("knows"));
        Edge x = graph.addEdge(null, b, c, this.graphTest.convertLabel("knows"));
        Edge y = graph.addEdge(null, a, c, this.graphTest.convertLabel("hates"));
        Edge z = graph.addEdge(null, a, b, this.graphTest.convertLabel("hates"));
        Edge zz = graph.addEdge(null, c, c, this.graphTest.convertLabel("hates"));
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getEdges(Direction.OUT, new String[0])), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})), (int)2);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.OUT, new String[0])), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})), (int)2);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.BOTH, new String[0])), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})), (int)2);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(w));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(y));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(z));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[0])).contains(b));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[0])).contains(c));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})).contains(w));
        VertexTestSuite.assertFalse((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})).contains(y));
        VertexTestSuite.assertFalse((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})).contains(z));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})).contains(b));
        VertexTestSuite.assertFalse((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})).contains(c));
        VertexTestSuite.assertFalse((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})).contains(w));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})).contains(y));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})).contains(z));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})).contains(b));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getVertices(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})).contains(c));
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.IN, new String[0])), (int)0);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.IN, new String[]{this.graphTest.convertLabel("knows")})), (int)0);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getVertices(Direction.IN, new String[]{this.graphTest.convertLabel("hates")})), (int)0);
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(w));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(y));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(a.getEdges(Direction.OUT, new String[0])).contains(z));
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(b.getEdges(Direction.BOTH, new String[0])), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(b.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})), (int)2);
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(b.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})).contains(x));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(b.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})).contains(w));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(b.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})).contains(a));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(b.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})).contains(c));
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(c.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(c.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})), (int)3);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(c.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(c.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})).contains(y));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(c.getEdges(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})).contains(zz));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(c.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})).contains(a));
        VertexTestSuite.assertTrue((boolean)VertexTestSuite.asList(c.getVertices(Direction.BOTH, new String[]{this.graphTest.convertLabel("hates")})).contains(c));
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(c.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("hates")})), (int)2);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(c.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("hates")})), (int)1);
        try {
            x.getVertex(Direction.BOTH);
            VertexTestSuite.fail((String)"Getting edge vertex with direction BOTH should fail");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            VertexTestSuite.fail((String)("Getting edge vertex with direction BOTH should should throw " + IllegalArgumentException.class.getSimpleName()));
        }
        graph.shutdown();
    }

    public void testEmptyKeyProperty() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v = graph.addVertex(null);
            try {
                v.setProperty("", (Object)"value");
                VertexTestSuite.fail((String)"Setting a vertex property with an empty string key should fail");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        graph.shutdown();
    }

    public void testVertexCentricLinking() {
        Graph graph = this.graphTest.generateGraph();
        Vertex v = graph.addVertex(null);
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        v.addEdge(this.graphTest.convertLabel("knows"), a);
        v.addEdge(this.graphTest.convertLabel("knows"), b);
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getVertices()), (int)3);
        }
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getEdges()), (int)2);
        }
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(v.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})), (int)2);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})), (int)0);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(a.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(b.getEdges(Direction.OUT, new String[]{this.graphTest.convertLabel("knows")})), (int)0);
        VertexTestSuite.assertEquals((int)VertexTestSuite.count(b.getEdges(Direction.IN, new String[]{this.graphTest.convertLabel("knows")})), (int)1);
        graph.shutdown();
    }

    public void testVertexCentricRemoving() {
        Graph graph = this.graphTest.generateGraph();
        Vertex a = graph.addVertex(null);
        Vertex b = graph.addVertex(null);
        Vertex c = graph.addVertex(null);
        Object cId = c.getId();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getVertices()), (int)3);
        }
        a.remove();
        b.remove();
        VertexTestSuite.assertNotNull((Object)graph.getVertex(cId));
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            VertexTestSuite.assertEquals((int)VertexTestSuite.count(graph.getVertices()), (int)1);
        }
        graph.shutdown();
    }

    public void testConcurrentModificationOnProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex a = graph.addVertex(null);
            a.setProperty("test1", (Object)1);
            a.setProperty("test2", (Object)2);
            a.setProperty("test3", (Object)3);
            a.setProperty("test4", (Object)4);
            for (String key : a.getPropertyKeys()) {
                a.removeProperty(key);
            }
        }
        graph.shutdown();
    }

    public void testSettingBadVertexProperties() {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexProperties.booleanValue()) {
            Vertex v = graph.addVertex(null);
            try {
                v.setProperty(null, (Object)-1);
                VertexTestSuite.assertFalse((boolean)true);
            }
            catch (RuntimeException e) {
                VertexTestSuite.assertTrue((boolean)true);
            }
            try {
                v.setProperty("", (Object)-1);
                VertexTestSuite.assertFalse((boolean)true);
            }
            catch (RuntimeException e) {
                VertexTestSuite.assertTrue((boolean)true);
            }
            try {
                v.setProperty("id", (Object)-1);
                VertexTestSuite.assertFalse((boolean)true);
            }
            catch (RuntimeException e) {
                VertexTestSuite.assertTrue((boolean)true);
            }
            try {
                v.setProperty("good", null);
                VertexTestSuite.assertFalse((boolean)true);
            }
            catch (RuntimeException e) {
                VertexTestSuite.assertTrue((boolean)true);
            }
        }
        graph.shutdown();
    }
}

