/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONReader;
import java.util.HashSet;

public class GraphSONReaderTestSuite
extends TestSuite {
    public GraphSONReaderTestSuite() {
    }

    public GraphSONReaderTestSuite(GraphTest graphTest) {
        super(graphTest);
    }

    public void testReadingTinkerGraph() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (!graph.getFeatures().ignoresSuppliedIds.booleanValue()) {
            this.stopWatch();
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-1.json"));
            GraphSONReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(graph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])), (int)3);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(graph.getVertex((Object)1).getEdges(Direction.IN, new String[0])), (int)0);
            Vertex marko = graph.getVertex((Object)1);
            GraphSONReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphSONReaderTestSuite.assertEquals((Object)marko.getProperty("age"), (Object)29);
            int counter = 0;
            for (Edge e : graph.getVertex((Object)1).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().toString().equals("2")) {
                    GraphSONReaderTestSuite.assertEquals((Object)e.getProperty("weight"), (Object)0.5);
                    GraphSONReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                    GraphSONReaderTestSuite.assertEquals((String)e.getId().toString(), (String)"7");
                    ++counter;
                    continue;
                }
                if (e.getVertex(Direction.IN).getId().toString().equals("3")) {
                    GraphSONReaderTestSuite.assertEquals((long)Math.round((Double)e.getProperty("weight")), (long)0L);
                    GraphSONReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphSONReaderTestSuite.assertEquals((String)e.getId().toString(), (String)"9");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().toString().equals("4")) continue;
                GraphSONReaderTestSuite.assertEquals((long)Math.round((Double)e.getProperty("weight")), (long)1L);
                GraphSONReaderTestSuite.assertEquals((String)e.getLabel(), (String)"knows");
                GraphSONReaderTestSuite.assertEquals((String)e.getId().toString(), (String)"8");
                ++counter;
            }
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(graph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(graph.getVertex((Object)4).getEdges(Direction.IN, new String[0])), (int)1);
            Vertex josh = graph.getVertex((Object)4);
            GraphSONReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphSONReaderTestSuite.assertEquals((Object)josh.getProperty("age"), (Object)32);
            for (Edge e : graph.getVertex((Object)4).getEdges(Direction.OUT, new String[0])) {
                if (e.getVertex(Direction.IN).getId().toString().equals("3")) {
                    GraphSONReaderTestSuite.assertEquals((long)Math.round((Double)e.getProperty("weight")), (long)0L);
                    GraphSONReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                    GraphSONReaderTestSuite.assertEquals((String)e.getId().toString(), (String)"11");
                    ++counter;
                    continue;
                }
                if (!e.getVertex(Direction.IN).getId().toString().equals("5")) continue;
                GraphSONReaderTestSuite.assertEquals((long)Math.round((Double)e.getProperty("weight")), (long)1L);
                GraphSONReaderTestSuite.assertEquals((String)e.getLabel(), (String)"created");
                GraphSONReaderTestSuite.assertEquals((String)e.getId().toString(), (String)"10");
                ++counter;
            }
            GraphSONReaderTestSuite.assertEquals((int)counter, (int)5);
        }
        graph.shutdown();
    }

    public void testTinkerGraphEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
            this.stopWatch();
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-1.json"));
            GraphSONReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> edgeIds = new HashSet<String>();
            HashSet<String> edgeKeys = new HashSet<String>();
            HashSet<String> edgeValues = new HashSet<String>();
            int count = 0;
            for (Edge e : graph.getEdges()) {
                ++count;
                edgeIds.add(e.getId().toString());
                for (String key : e.getPropertyKeys()) {
                    edgeKeys.add(key);
                    edgeValues.add(e.getProperty(key).toString());
                }
            }
            GraphSONReaderTestSuite.assertEquals((int)count, (int)6);
            GraphSONReaderTestSuite.assertEquals((int)edgeIds.size(), (int)6);
            GraphSONReaderTestSuite.assertEquals((int)edgeKeys.size(), (int)1);
            GraphSONReaderTestSuite.assertEquals((int)edgeValues.size(), (int)4);
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-1.json"));
            GraphSONReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<String> vertexNames = new HashSet<String>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                vertexNames.add(v.getProperty("name").toString());
            }
            GraphSONReaderTestSuite.assertEquals((int)count, (int)6);
            GraphSONReaderTestSuite.assertEquals((int)vertexNames.size(), (int)6);
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("marko"));
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("josh"));
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("peter"));
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("vadas"));
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("ripple"));
            GraphSONReaderTestSuite.assertTrue((boolean)vertexNames.contains("lop"));
        }
        graph.shutdown();
    }

    public void testTinkerGraphSoftwareVertices() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-1.json"));
            GraphSONReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            HashSet<Vertex> softwareVertices = new HashSet<Vertex>();
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (!name.equals("lop") && !name.equals("ripple")) continue;
                softwareVertices.add(v);
            }
            GraphSONReaderTestSuite.assertEquals((int)count, (int)6);
            GraphSONReaderTestSuite.assertEquals((int)softwareVertices.size(), (int)2);
            for (Vertex v : softwareVertices) {
                GraphSONReaderTestSuite.assertEquals((Object)v.getProperty("lang"), (Object)"java");
            }
        }
        graph.shutdown();
    }

    public void testTinkerGraphVertexAndEdges() throws Exception {
        Graph graph = this.graphTest.generateGraph();
        if (graph.getFeatures().supportsVertexIteration.booleanValue()) {
            this.stopWatch();
            new GraphSONReader(graph).inputGraph(GraphSONReader.class.getResourceAsStream("graph-example-1.json"));
            GraphSONReaderTestSuite.printPerformance(graph.toString(), null, "graph-example-1 loaded", this.stopWatch());
            Vertex marko = null;
            Vertex peter = null;
            Vertex josh = null;
            Vertex vadas = null;
            Vertex lop = null;
            Vertex ripple = null;
            int count = 0;
            for (Vertex v : graph.getVertices()) {
                ++count;
                String name = v.getProperty("name").toString();
                if (name.equals("marko")) {
                    marko = v;
                    continue;
                }
                if (name.equals("peter")) {
                    peter = v;
                    continue;
                }
                if (name.equals("josh")) {
                    josh = v;
                    continue;
                }
                if (name.equals("vadas")) {
                    vadas = v;
                    continue;
                }
                if (name.equals("lop")) {
                    lop = v;
                    continue;
                }
                if (name.equals("ripple")) {
                    ripple = v;
                    continue;
                }
                GraphSONReaderTestSuite.assertTrue((boolean)false);
            }
            GraphSONReaderTestSuite.assertEquals((int)count, (int)6);
            GraphSONReaderTestSuite.assertTrue((null != marko ? 1 : 0) != 0);
            GraphSONReaderTestSuite.assertTrue((null != peter ? 1 : 0) != 0);
            GraphSONReaderTestSuite.assertTrue((null != josh ? 1 : 0) != 0);
            GraphSONReaderTestSuite.assertTrue((null != vadas ? 1 : 0) != 0);
            GraphSONReaderTestSuite.assertTrue((null != lop ? 1 : 0) != 0);
            GraphSONReaderTestSuite.assertTrue((null != ripple ? 1 : 0) != 0);
            if (graph.getFeatures().supportsEdgeIteration.booleanValue()) {
                GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(graph.getEdges()), (int)6);
            }
            HashSet<Vertex> vertices = new HashSet<Vertex>();
            GraphSONReaderTestSuite.assertEquals((Object)marko.getProperty("name"), (Object)"marko");
            GraphSONReaderTestSuite.assertEquals((int)((Number)marko.getProperty("age")).intValue(), (int)29);
            GraphSONReaderTestSuite.assertEquals((int)marko.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(marko.getEdges(Direction.OUT, new String[0])), (int)3);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(marko.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : marko.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(vadas));
            vertices = new HashSet();
            GraphSONReaderTestSuite.assertEquals((Object)peter.getProperty("name"), (Object)"peter");
            GraphSONReaderTestSuite.assertEquals((int)((Number)peter.getProperty("age")).intValue(), (int)35);
            GraphSONReaderTestSuite.assertEquals((int)peter.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(peter.getEdges(Direction.OUT, new String[0])), (int)1);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(peter.getEdges(Direction.IN, new String[0])), (int)0);
            for (Edge e : peter.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            vertices = new HashSet();
            GraphSONReaderTestSuite.assertEquals((Object)josh.getProperty("name"), (Object)"josh");
            GraphSONReaderTestSuite.assertEquals((int)((Number)josh.getProperty("age")).intValue(), (int)32);
            GraphSONReaderTestSuite.assertEquals((int)josh.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(josh.getEdges(Direction.OUT, new String[0])), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(josh.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : josh.getEdges(Direction.OUT, new String[0])) {
                vertices.add(e.getVertex(Direction.IN));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)2);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(lop));
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(ripple));
            vertices = new HashSet();
            for (Edge e : josh.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GraphSONReaderTestSuite.assertEquals((Object)vadas.getProperty("name"), (Object)"vadas");
            GraphSONReaderTestSuite.assertEquals((int)((Number)vadas.getProperty("age")).intValue(), (int)27);
            GraphSONReaderTestSuite.assertEquals((int)vadas.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(vadas.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(vadas.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : vadas.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            vertices = new HashSet();
            GraphSONReaderTestSuite.assertEquals((Object)lop.getProperty("name"), (Object)"lop");
            GraphSONReaderTestSuite.assertEquals((Object)lop.getProperty("lang"), (Object)"java");
            GraphSONReaderTestSuite.assertEquals((int)lop.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(lop.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(lop.getEdges(Direction.IN, new String[0])), (int)3);
            for (Edge e : lop.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)3);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(marko));
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(peter));
            vertices = new HashSet();
            GraphSONReaderTestSuite.assertEquals((Object)ripple.getProperty("name"), (Object)"ripple");
            GraphSONReaderTestSuite.assertEquals((Object)ripple.getProperty("lang"), (Object)"java");
            GraphSONReaderTestSuite.assertEquals((int)ripple.getPropertyKeys().size(), (int)2);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(ripple.getEdges(Direction.OUT, new String[0])), (int)0);
            GraphSONReaderTestSuite.assertEquals((int)GraphSONReaderTestSuite.count(ripple.getEdges(Direction.IN, new String[0])), (int)1);
            for (Edge e : ripple.getEdges(Direction.IN, new String[0])) {
                vertices.add(e.getVertex(Direction.OUT));
            }
            GraphSONReaderTestSuite.assertEquals((int)vertices.size(), (int)1);
            GraphSONReaderTestSuite.assertTrue((boolean)vertices.contains(josh));
        }
        graph.shutdown();
    }
}

