/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.annotations;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import java.lang.reflect.Method;

public class AdjacencyAnnotationHandler
implements AnnotationHandler<Adjacency> {
    @Override
    public Class<Adjacency> getAnnotationType() {
        return Adjacency.class;
    }

    @Override
    public Object processElement(Adjacency annotation, Method method, Object[] arguments, FramedGraph framedGraph, Element element, Direction direction) {
        if (element instanceof Vertex) {
            return this.processVertex(annotation, method, arguments, framedGraph, (Vertex)element);
        }
        throw new UnsupportedOperationException();
    }

    public Object processVertex(Adjacency adjacency, Method method, Object[] arguments, FramedGraph framedGraph, Vertex vertex) {
        if (ClassUtilities.isGetMethod(method)) {
            FramedVertexIterable r = new FramedVertexIterable(framedGraph, vertex.getVertices(adjacency.direction(), new String[]{adjacency.label()}), ClassUtilities.getGenericClass(method));
            if (ClassUtilities.returnsIterable(method)) {
                return r;
            }
            return r.iterator().hasNext() ? r.iterator().next() : null;
        }
        if (ClassUtilities.isAddMethod(method)) {
            Vertex newVertex;
            Class<?> returnType = method.getReturnType();
            Object returnValue = null;
            if (arguments == null) {
                returnValue = framedGraph.addVertex(returnType, returnType);
                newVertex = ((VertexFrame)returnValue).asVertex();
            } else {
                newVertex = ((VertexFrame)arguments[0]).asVertex();
            }
            this.addEdges(adjacency, framedGraph, vertex, newVertex);
            if (returnType.isPrimitive()) {
                return null;
            }
            return returnValue;
        }
        if (ClassUtilities.isRemoveMethod(method)) {
            this.removeEdges(adjacency.direction(), adjacency.label(), vertex, ((VertexFrame)arguments[0]).asVertex(), framedGraph);
            return null;
        }
        if (ClassUtilities.isSetMethod(method)) {
            this.removeEdges(adjacency.direction(), adjacency.label(), vertex, null, framedGraph);
            if (ClassUtilities.acceptsIterable(method)) {
                for (Object o : (Iterable)arguments[0]) {
                    Vertex v = ((VertexFrame)o).asVertex();
                    this.addEdges(adjacency, framedGraph, vertex, v);
                }
                return null;
            }
            if (null != arguments[0]) {
                Vertex newVertex = ((VertexFrame)arguments[0]).asVertex();
                this.addEdges(adjacency, framedGraph, vertex, newVertex);
            }
            return null;
        }
        return null;
    }

    private void addEdges(Adjacency adjacency, FramedGraph framedGraph, Vertex vertex, Vertex newVertex) {
        switch (adjacency.direction()) {
            case OUT: {
                framedGraph.addEdge(null, vertex, newVertex, adjacency.label());
                break;
            }
            case IN: {
                framedGraph.addEdge(null, newVertex, vertex, adjacency.label());
                break;
            }
            case BOTH: {
                throw new UnsupportedOperationException("Direction.BOTH it not supported on 'add' or 'set' methods");
            }
        }
    }

    private void removeEdges(Direction direction, String label, Vertex element, Vertex otherVertex, FramedGraph framedGraph) {
        for (Edge edge : element.getEdges(direction, new String[]{label})) {
            if (null != otherVertex && !edge.getVertex(direction.opposite()).equals(otherVertex)) continue;
            framedGraph.removeEdge(edge);
        }
    }
}

