/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.javahandler;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.javahandler.Initializer;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerException;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import com.tinkerpop.frames.util.ExceptionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

class JavaFrameInitializer
implements FrameInitializer {
    private JavaHandlerModule module;

    JavaFrameInitializer(JavaHandlerModule module) {
        this.module = module;
    }

    @Override
    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        Object framedElement = element instanceof Vertex ? framedGraph.frame((Vertex)element, kind) : framedGraph.frame((Edge)element, kind);
        ArrayList classes = new ArrayList();
        this.depthFirstClassSearch(classes, kind);
        Collections.reverse(classes);
        LinkedHashSet hierarcy = new LinkedHashSet(classes);
        for (Class clazz : hierarcy) {
            try {
                try {
                    Class<?> implKind = this.module.getHandlerClass(clazz);
                    for (Method method : implKind.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(Initializer.class)) continue;
                        if (method.getParameterTypes().length != 0) {
                            throw new JavaHandlerException("Java handler initializer " + method + "cannot have parameters");
                        }
                        Object handler = this.module.createHandler(framedElement, framedGraph, element, clazz, method);
                        method.invoke(handler, new Object[0]);
                    }
                }
                catch (ClassNotFoundException e) {
                }
            }
            catch (IllegalArgumentException e) {
                throw new JavaHandlerException("Problem calling Java handler", e);
            }
            catch (IllegalAccessException e) {
                throw new JavaHandlerException("Problem calling Java handler", e);
            }
            catch (InvocationTargetException e) {
                ExceptionUtils.sneakyThrow(e.getTargetException());
            }
        }
    }

    private void depthFirstClassSearch(List<Class<?>> initializers, Class<?> kind) {
        if (kind == null || kind == Object.class) {
            return;
        }
        initializers.add(kind);
        for (Class<?> i : kind.getInterfaces()) {
            this.depthFirstClassSearch(initializers, i);
        }
        this.depthFirstClassSearch(initializers, kind.getSuperclass());
    }
}

