/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.javahandler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.javahandler.JavaFrameInitializer;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerClass;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContextImpl;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerException;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerFactory;
import com.tinkerpop.frames.modules.javahandler.JavaMethodHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutionException;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;

public class JavaHandlerModule
implements Module {
    private LoadingCache<Class<?>, Class<?>> classCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Class<?>>(){

        public Class<?> load(final Class<?> handlerClass) throws Exception {
            ProxyFactory proxyFactory = new ProxyFactory(){

                protected ClassLoader getClassLoader() {
                    return handlerClass.getClassLoader();
                }
            };
            proxyFactory.setUseCache(false);
            proxyFactory.setSuperclass(handlerClass);
            Class proxyClass = proxyFactory.createClass();
            return proxyClass;
        }
    });
    private JavaHandlerFactory factory = new JavaHandlerFactory(){

        @Override
        public <T> T create(Class<T> handlerClass) throws InstantiationException, IllegalAccessException {
            return handlerClass.newInstance();
        }
    };

    public JavaHandlerModule withFactory(JavaHandlerFactory factory) {
        this.factory = factory;
        return this;
    }

    @Override
    public Graph configure(Graph baseGraph, FramedGraphConfiguration config) {
        config.addMethodHandler(new JavaMethodHandler(this));
        config.addFrameInitializer(new JavaFrameInitializer(this));
        return baseGraph;
    }

    Class<?> getHandlerClass(Class<?> frameClass) throws ClassNotFoundException {
        JavaHandlerClass handlerClass = frameClass.getAnnotation(JavaHandlerClass.class);
        if (handlerClass != null) {
            return handlerClass.value();
        }
        return frameClass.getClassLoader().loadClass(frameClass.getName() + "$Impl");
    }

    <T> T createHandler(final Object framedElement, final FramedGraph<?> graph, final Element element, Class<?> frameClass, final Method method) {
        try {
            Class<?> handlerClass = this.getHandlerClass(frameClass);
            Class implClass = (Class)this.classCache.get(handlerClass);
            Object handler = this.factory.create(implClass);
            ((Proxy)handler).setHandler(new MethodHandler(){
                private JavaHandlerContextImpl<Element> defaultJavahandlerImpl;
                {
                    this.defaultJavahandlerImpl = new JavaHandlerContextImpl<Element>(graph, method, element);
                }

                public Object invoke(Object o, Method m, Method proceed, Object[] args) throws Throwable {
                    if (!Modifier.isAbstract(m.getModifiers())) {
                        return proceed.invoke(o, args);
                    }
                    if (m.getAnnotation(JavaHandler.class) != null) {
                        throw new JavaHandlerException("Method " + m + " is marked with @JavaHandler but is not implemented");
                    }
                    if (m.getDeclaringClass() == JavaHandlerContext.class) {
                        return m.invoke(this.defaultJavahandlerImpl, args);
                    }
                    return m.invoke(framedElement, args);
                }
            });
            return handler;
        }
        catch (ExecutionException e) {
            throw new JavaHandlerException("Cannot create class for handling framed method", e);
        }
        catch (InstantiationException e) {
            throw new JavaHandlerException("Problem instantiating handler class", e);
        }
        catch (IllegalAccessException e) {
            throw new JavaHandlerException("Problem instantiating handler class", e);
        }
        catch (ClassNotFoundException e) {
            throw new JavaHandlerException("Problem locating handler class for " + frameClass, e);
        }
    }
}

