/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.typedgraph;

import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import com.tinkerpop.frames.util.Validate;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    Map<Class<?>, Class<?>> typeFields = new HashMap();
    Map<TypeDiscriminator, Class<?>> typeDiscriminators = new HashMap();

    public Class<?> getTypeHoldingTypeField(Class<?> type) {
        if (type.getAnnotation(TypeField.class) != null) {
            return type;
        }
        return this.typeFields.get(type);
    }

    public Class<?> getType(Class<?> typeHoldingTypeField, String typeValue) {
        Class<?> result = this.typeDiscriminators.get(new TypeDiscriminator(typeHoldingTypeField, typeValue));
        return result;
    }

    public TypeRegistry add(Class<?> type) {
        Validate.assertArgument(type.isInterface(), "Not an interface: %s", type.getName());
        if (!this.typeFields.containsKey(type)) {
            Class<?> typeHoldingTypeField = this.findTypeHoldingTypeField(type);
            Validate.assertArgument(typeHoldingTypeField != null, "The type and its supertypes don't have a @TypeField annotation: %s", type.getName());
            this.typeFields.put(type, typeHoldingTypeField);
            this.registerTypeValue(type, typeHoldingTypeField);
        }
        return this;
    }

    private Class<?> findTypeHoldingTypeField(Class<?> type) {
        Class<?> typeHoldingTypeField = type.getAnnotation(TypeField.class) == null ? null : type;
        for (Class<?> parentType : type.getInterfaces()) {
            Class<?> parentTypeHoldingTypeField = this.findTypeHoldingTypeField(parentType);
            Validate.assertArgument(parentTypeHoldingTypeField == null || typeHoldingTypeField == null || parentTypeHoldingTypeField == typeHoldingTypeField, "You have multiple TypeField annotations in your class-hierarchy for %s", type.getName());
            if (typeHoldingTypeField != null) continue;
            typeHoldingTypeField = parentTypeHoldingTypeField;
        }
        return typeHoldingTypeField;
    }

    private void registerTypeValue(Class<?> type, Class<?> typeHoldingTypeField) {
        TypeValue typeValue = type.getAnnotation(TypeValue.class);
        Validate.assertArgument(typeValue != null, "The type does not have a @TypeValue annotation: %s", type.getName());
        this.typeDiscriminators.put(new TypeDiscriminator(typeHoldingTypeField, typeValue.value()), type);
    }

    static final class TypeDiscriminator {
        private Class<?> typeHoldingTypeField;
        private String value;

        TypeDiscriminator(Class<?> typeHoldingTypeField, String value) {
            Validate.assertNotNull(typeHoldingTypeField, value);
            this.typeHoldingTypeField = typeHoldingTypeField;
            this.value = value;
        }

        public int hashCode() {
            return 31 * (31 + this.typeHoldingTypeField.hashCode()) + this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeDiscriminator) {
                TypeDiscriminator other = (TypeDiscriminator)obj;
                return this.typeHoldingTypeField.equals(other.typeHoldingTypeField) && this.value.equals(other.value);
            }
            return false;
        }
    }
}

