/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.algorithm.generator;

import com.tinkerpop.gremlin.algorithm.generator.AbstractGenerator;
import com.tinkerpop.gremlin.algorithm.generator.CopyDistribution;
import com.tinkerpop.gremlin.algorithm.generator.Distribution;
import com.tinkerpop.gremlin.algorithm.generator.SizableIterable;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DistributionGenerator
extends AbstractGenerator {
    private final Distribution outDistribution;
    private final Distribution inDistribution;
    private final Iterable<Vertex> out;
    private final Iterable<Vertex> in;
    private final int expectedNumEdges;
    private final boolean allowLoops;

    private DistributionGenerator(Graph g, String label, Optional<Consumer<Edge>> edgeProcessor, Optional<BiConsumer<Vertex, Map<String, Object>>> vertexProcessor, Supplier<Long> seedGenerator, Iterable<Vertex> out, Iterable<Vertex> in, int expectedNumEdges, Distribution outDistribution, Distribution inDistribution, boolean allowLoops) {
        super(g, label, edgeProcessor, vertexProcessor, seedGenerator);
        this.out = out;
        this.in = in;
        this.outDistribution = outDistribution;
        this.inDistribution = inDistribution;
        this.expectedNumEdges = expectedNumEdges;
        this.allowLoops = allowLoops;
    }

    @Override
    public int generate() {
        long seed = (Long)this.seedSupplier.get();
        Random outRandom = new Random(seed);
        ArrayList outStubs = new ArrayList(this.expectedNumEdges);
        for (Vertex v : this.out) {
            this.processVertex(v, Collections.EMPTY_MAP);
            int degree = this.outDistribution.nextValue(outRandom);
            IntStream.range(0, degree).forEach(i -> outStubs.add(v));
        }
        outRandom = new Random(seed);
        Collections.shuffle(outStubs, outRandom);
        outRandom = new Random(seed);
        Random inRandom = new Random((Long)this.seedSupplier.get());
        int addedEdges = 0;
        int position = 0;
        for (Vertex v : this.in) {
            this.processVertex(v, Collections.EMPTY_MAP);
            int degree = this.inDistribution.nextConditionalValue(inRandom, this.outDistribution.nextValue(outRandom));
            for (int i2 = 0; i2 < degree; ++i2) {
                Vertex other = null;
                while (null == other) {
                    if (position >= outStubs.size()) {
                        return addedEdges;
                    }
                    other = (Vertex)outStubs.get(position);
                    ++position;
                    if (this.allowLoops || !v.equals(other)) continue;
                    other = null;
                }
                this.addEdge(other, v);
                ++addedEdges;
            }
        }
        return addedEdges;
    }

    public static Builder build(Graph g) {
        return new Builder(g);
    }

    public static class Builder
    extends AbstractGenerator.AbstractGeneratorBuilder<Builder> {
        private final Graph g;
        private Distribution outDistribution;
        private Distribution inDistribution;
        private Iterable<Vertex> out;
        private Iterable<Vertex> in;
        private int expectedNumEdges;
        private boolean allowLoops = true;

        private Builder(Graph g) {
            super(Builder.class);
            List allVertices;
            this.g = g;
            this.out = allVertices = IteratorUtils.list((Iterator)g.iterators().vertexIterator(new Object[0]));
            this.in = allVertices;
            this.expectedNumEdges = allVertices.size() * 2;
        }

        public Builder inVertices(Iterable<Vertex> vertices) {
            this.in = vertices;
            return this;
        }

        public Builder outVertices(Iterable<Vertex> vertices) {
            this.out = vertices;
            return this;
        }

        public Builder expectedNumEdges(int expectedNumEdges) {
            this.expectedNumEdges = expectedNumEdges;
            return this;
        }

        public void allowLoops(boolean allowLoops) {
            this.allowLoops = allowLoops;
        }

        public Builder outDistribution(Distribution distribution) {
            this.outDistribution = distribution;
            return this;
        }

        public Builder inDistribution(Distribution distribution) {
            this.inDistribution = distribution;
            return this;
        }

        public DistributionGenerator create() {
            Distribution inDist;
            if (null == this.outDistribution) {
                throw new IllegalStateException("Must set out-distribution before generating edges");
            }
            Distribution outDist = this.outDistribution.initialize(SizableIterable.sizeOf(this.out), this.expectedNumEdges);
            if (null == this.inDistribution) {
                if (this.out != this.in) {
                    throw new IllegalArgumentException("Need to specify in-distribution");
                }
                inDist = new CopyDistribution();
            } else {
                inDist = this.inDistribution.initialize(SizableIterable.sizeOf(this.in), this.expectedNumEdges);
            }
            return new DistributionGenerator(this.g, this.label, this.edgeProcessor, this.vertexProcessor, this.seedSupplier, this.out, this.in, this.expectedNumEdges, outDist, inDist, this.allowLoops);
        }
    }
}

