/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy;

import com.tinkerpop.gremlin.algorithm.generator.AbstractGenerator;
import com.tinkerpop.gremlin.groovy.ImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.function.GFunction;
import com.tinkerpop.gremlin.groovy.loaders.GremlinLoader;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.clustering.peerpressure.PeerPressureVertexProgram;
import com.tinkerpop.gremlin.process.computer.lambda.LambdaVertexProgram;
import com.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import com.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import com.tinkerpop.gremlin.process.graph.AnonymousGraphTraversal;
import com.tinkerpop.gremlin.process.util.TraversalMetrics;
import com.tinkerpop.gremlin.structure.Compare;
import com.tinkerpop.gremlin.structure.Contains;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Operator;
import com.tinkerpop.gremlin.structure.Order;
import com.tinkerpop.gremlin.structure.io.GraphReader;
import com.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import com.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import com.tinkerpop.gremlin.structure.io.kryo.KryoReader;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.util.GraphFactory;
import com.tinkerpop.gremlin.structure.util.batch.BatchGraph;
import com.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import com.tinkerpop.gremlin.util.Gremlin;
import com.tinkerpop.gremlin.util.function.FunctionUtils;
import groovy.grape.Grape;
import groovy.json.JsonBuilder;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public abstract class AbstractImportCustomizerProvider
implements ImportCustomizerProvider {
    protected static final String DOT_STAR = ".*";
    protected static final String EMPTY_STRING = "";
    protected static final String PERIOD = ".";
    protected final Set<String> extraImports = new HashSet<String>();
    protected final Set<String> extraStaticImports = new HashSet<String>();
    private static final Set<String> imports = new HashSet<String>();
    private static final Set<String> staticImports = new HashSet<String>();

    @Override
    public CompilationCustomizer getCompilationCustomizer() {
        ImportCustomizer ic = new ImportCustomizer();
        AbstractImportCustomizerProvider.processImports(ic, imports);
        AbstractImportCustomizerProvider.processStaticImports(ic, staticImports);
        AbstractImportCustomizerProvider.processImports(ic, this.extraImports);
        AbstractImportCustomizerProvider.processStaticImports(ic, this.extraStaticImports);
        return ic;
    }

    @Override
    public Set<String> getImports() {
        return imports;
    }

    @Override
    public Set<String> getStaticImports() {
        return staticImports;
    }

    @Override
    public Set<String> getExtraImports() {
        return this.extraImports;
    }

    @Override
    public Set<String> getExtraStaticImports() {
        return this.extraStaticImports;
    }

    public Set<String> getAllImports() {
        HashSet<String> allImports = new HashSet<String>();
        allImports.addAll(imports);
        allImports.addAll(staticImports);
        allImports.addAll(this.extraImports);
        allImports.addAll(this.extraStaticImports);
        return allImports;
    }

    protected static void processStaticImports(ImportCustomizer ic, Set<String> staticImports) {
        for (String staticImport : staticImports) {
            if (staticImport.endsWith(DOT_STAR)) {
                ic.addStaticStars(new String[]{staticImport.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            int place = staticImport.lastIndexOf(PERIOD);
            ic.addStaticImport(staticImport.substring(0, place), staticImport.substring(place + 1));
        }
    }

    protected static void processImports(ImportCustomizer ic, Set<String> imports) {
        for (String imp : imports) {
            if (imp.endsWith(DOT_STAR)) {
                ic.addStarImports(new String[]{imp.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            ic.addImports(new String[]{imp});
        }
    }

    static {
        imports.add(Graph.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphStrategy.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphFactory.class.getPackage().getName() + DOT_STAR);
        imports.add(BatchGraph.class.getPackage().getName() + DOT_STAR);
        imports.add(DetachedElement.class.getPackage().getName() + DOT_STAR);
        imports.add(Traversal.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphComputer.class.getPackage().getName() + DOT_STAR);
        staticImports.add(AnonymousGraphTraversal.Tokens.class.getCanonicalName() + DOT_STAR);
        imports.add(Gremlin.class.getPackage().getName() + DOT_STAR);
        imports.add(GremlinLoader.class.getPackage().getName() + DOT_STAR);
        imports.add(FunctionUtils.class.getPackage().getName() + DOT_STAR);
        imports.add(GFunction.class.getPackage().getName() + DOT_STAR);
        imports.add(TraversalMetrics.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphReader.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphMLReader.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphSONReader.class.getPackage().getName() + DOT_STAR);
        imports.add(KryoReader.class.getPackage().getName() + DOT_STAR);
        imports.add(AbstractGenerator.class.getPackage().getName() + DOT_STAR);
        imports.add(PeerPressureVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(PageRankVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(TraversalVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(LambdaVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(Grape.class.getCanonicalName());
        imports.add(JsonBuilder.class.getPackage().getName() + DOT_STAR);
        imports.add(Configuration.class.getPackage().getName() + DOT_STAR);
        staticImports.add(T.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Direction.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Compare.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Contains.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Order.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Operator.class.getCanonicalName() + DOT_STAR);
    }
}

