/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.engine;

import com.tinkerpop.gremlin.groovy.engine.ScriptEngines;
import com.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import com.tinkerpop.gremlin.structure.Graph;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinExecutor.class);
    private ScriptEngines scriptEngines;
    private final Map<String, EngineSettings> settings;
    private final long scriptEvaluationTimeout;
    private final Bindings globalBindings;
    private final List<List<String>> use;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Consumer<Bindings> beforeEval;
    private final Consumer<Bindings> afterSuccess;
    private final Consumer<Bindings> afterTimeout;
    private final BiConsumer<Bindings, Exception> afterFailure;
    private final Set<String> enabledPlugins;

    private GremlinExecutor(Map<String, EngineSettings> settings, List<List<String>> use, long scriptEvaluationTimeout, Bindings globalBindings, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, Consumer<Bindings> beforeEval, Consumer<Bindings> afterSuccess, Consumer<Bindings> afterTimeout, BiConsumer<Bindings, Exception> afterFailure, Set<String> enabledPlugins) {
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.beforeEval = beforeEval;
        this.afterSuccess = afterSuccess;
        this.afterTimeout = afterTimeout;
        this.afterFailure = afterFailure;
        this.use = use;
        this.settings = settings;
        this.scriptEvaluationTimeout = scriptEvaluationTimeout;
        this.globalBindings = globalBindings;
        this.enabledPlugins = enabledPlugins;
        this.scriptEngines = this.createScriptEngines();
    }

    public CompletableFuture<Object> eval(String script) {
        return this.eval(script, Optional.empty(), new SimpleBindings());
    }

    public CompletableFuture<Object> eval(String script, Bindings boundVars) {
        return this.eval(script, Optional.empty(), boundVars);
    }

    public CompletableFuture<Object> eval(String script, Map<String, Object> boundVars) {
        return this.eval(script, Optional.empty(), new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, Optional<String> language, Map<String, Object> boundVars) {
        return this.eval(script, language, new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, Optional<String> language, Bindings boundVars) {
        String lang = language.orElse("gremlin-groovy");
        logger.debug("Preparing to evaluate script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
        AtomicBoolean abort = new AtomicBoolean(false);
        CompletableFuture<Object> evaluationFuture = CompletableFuture.supplyAsync(() -> {
            SimpleBindings bindings2 = new SimpleBindings();
            bindings2.putAll(this.globalBindings);
            bindings2.putAll(boundVars);
            try {
                logger.debug("Evaluating script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
                this.beforeEval.accept(bindings2);
                Object o = this.scriptEngines.eval(script, (Bindings)bindings2, lang);
                if (abort.get()) {
                    this.afterTimeout.accept(bindings2);
                } else {
                    this.afterSuccess.accept(bindings2);
                }
                return o;
            }
            catch (Exception ex) {
                this.afterFailure.accept(bindings2, ex);
                throw new RuntimeException(ex);
            }
        }, this.executorService);
        this.scheduleTimeout(evaluationFuture, script, abort);
        return evaluationFuture;
    }

    public ScriptEngines getScriptEngines() {
        return this.scriptEngines;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Bindings getGlobalBindings() {
        return this.globalBindings;
    }

    @Override
    public void close() throws Exception {
        this.scriptEngines.close();
    }

    private void scheduleTimeout(CompletableFuture<Object> evaluationFuture, String script, AtomicBoolean abort) {
        if (this.scriptEvaluationTimeout > 0L) {
            ScheduledFuture<?> sf = this.scheduledExecutorService.schedule(() -> {
                logger.info("Timing out script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
                if (!evaluationFuture.isDone()) {
                    abort.set(true);
                    evaluationFuture.completeExceptionally(new TimeoutException(String.format("Script evaluation exceeded the configured threshold of %s ms for request [%s]", this.scriptEvaluationTimeout, script)));
                }
            }, this.scriptEvaluationTimeout, TimeUnit.MILLISECONDS);
            evaluationFuture.handleAsync((v, t) -> {
                logger.debug("Killing scheduled timeout on script evaluation as the eval completed (possibly with exception).");
                return sf.cancel(true);
            });
        }
    }

    private ScriptEngines createScriptEngines() {
        ArrayList globalPlugins = new ArrayList();
        ServiceLoader.load(GremlinPlugin.class).forEach(globalPlugins::add);
        return new ScriptEngines(se -> {
            for (Map.Entry<String, EngineSettings> config : this.settings.entrySet()) {
                String language = config.getKey();
                se.reload(language, new HashSet<String>(config.getValue().getImports()), new HashSet<String>(config.getValue().getStaticImports()), config.getValue().getConfig());
            }
            ArrayList pluginsToLoad = new ArrayList(globalPlugins);
            this.use.forEach(u -> {
                if (u.size() != 3) {
                    logger.warn("Could not resolve dependencies for [{}].  Each entry for the 'use' configuration must include [groupId, artifactId, version]", u);
                } else {
                    logger.info("Getting dependencies for [{}]", u);
                    pluginsToLoad.addAll(se.use((String)u.get(0), (String)u.get(1), (String)u.get(2)));
                }
            });
            se.loadPlugins(pluginsToLoad.stream().filter(plugin -> this.enabledPlugins.contains(plugin.getName())).collect(Collectors.toList()));
            for (Map.Entry<String, EngineSettings> config : this.settings.entrySet()) {
                String language = config.getKey();
                AtomicBoolean hasErrors = new AtomicBoolean(false);
                config.getValue().getScripts().stream().map(File::new).filter(f -> {
                    if (!f.exists()) {
                        logger.warn("Could not initialize {} ScriptEngine with {} as file does not exist", (Object)language, f);
                        hasErrors.set(true);
                    }
                    return f.exists();
                }).map(f -> {
                    try {
                        return Pair.with((Object)f, Optional.of(new FileReader((File)f)));
                    }
                    catch (IOException ioe) {
                        logger.warn("Could not initialize {} ScriptEngine with {} as file could not be read - {}", new Object[]{language, f, ioe.getMessage()});
                        hasErrors.set(true);
                        return Pair.with((Object)f, Optional.empty());
                    }
                }).filter(p -> ((Optional)p.getValue1()).isPresent()).map(p -> Pair.with((Object)p.getValue0(), ((Optional)p.getValue1()).get())).forEachOrdered(p -> {
                    try {
                        SimpleBindings bindings = new SimpleBindings();
                        bindings.putAll(this.globalBindings);
                        bindings.put("#jsr223.groovy.engine.keep.globals", (Object)"hard");
                        se.eval((Reader)p.getValue1(), (Bindings)bindings, language);
                        bindings.entrySet().stream().filter(kv -> kv.getValue() instanceof Graph).forEach(kv -> this.globalBindings.put((String)kv.getKey(), kv.getValue()));
                        logger.info("Initialized {} ScriptEngine with {}", (Object)language, p.getValue0());
                    }
                    catch (ScriptException sx) {
                        hasErrors.set(true);
                        logger.warn("Could not initialize {} ScriptEngine with {} as script could not be evaluated - {}", new Object[]{language, p.getValue0(), sx.getMessage()});
                    }
                });
            }
        });
    }

    public static Builder build() {
        return new Builder().addEngineSettings("gremlin-groovy", new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, Object>());
    }

    public static Builder build(String engineName, List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
        return new Builder().addEngineSettings(engineName, imports, staticImports, scripts, config);
    }

    private static class EngineSettings {
        private List<String> imports;
        private List<String> staticImports;
        private List<String> scripts;
        private Map<String, Object> config;

        public EngineSettings(List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
            this.imports = imports;
            this.staticImports = staticImports;
            this.scripts = scripts;
            this.config = config;
        }

        private List<String> getImports() {
            return this.imports;
        }

        private List<String> getStaticImports() {
            return this.staticImports;
        }

        private List<String> getScripts() {
            return this.scripts;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }
    }

    public static class Builder {
        private long scriptEvaluationTimeout = 8000L;
        private Map<String, EngineSettings> settings = new HashMap<String, EngineSettings>();
        private ExecutorService executorService;
        private ScheduledExecutorService scheduledExecutorService;
        private Set<String> enabledPlugins = new HashSet<String>();
        private Consumer<Bindings> beforeEval = b -> {};
        private Consumer<Bindings> afterSuccess = b -> {};
        private Consumer<Bindings> afterTimeout = b -> {};
        private BiConsumer<Bindings, Exception> afterFailure = (b, e) -> {};
        private List<List<String>> use = new ArrayList<List<String>>();
        private Bindings globalBindings = new SimpleBindings();

        private Builder() {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-executor-%d").build();
            this.scheduledExecutorService = Executors.newScheduledThreadPool(4, (ThreadFactory)threadFactory);
            this.executorService = this.scheduledExecutorService;
        }

        public Builder addEngineSettings(String engineName, List<String> imports, List<String> staticImports, List<String> scripts, Map<String, Object> config) {
            if (null == imports) {
                throw new IllegalArgumentException("imports cannot be null");
            }
            if (null == staticImports) {
                throw new IllegalArgumentException("staticImports cannot be null");
            }
            if (null == scripts) {
                throw new IllegalArgumentException("scripts cannot be null");
            }
            Map<String, Object> m = null == config ? Collections.emptyMap() : config;
            this.settings.put(engineName, new EngineSettings(imports, staticImports, scripts, m));
            return this;
        }

        public Builder globalBindings(Bindings bindings) {
            this.globalBindings = bindings;
            return this;
        }

        public Builder scriptEvaluationTimeout(long scriptEvaluationTimeout) {
            this.scriptEvaluationTimeout = scriptEvaluationTimeout;
            return this;
        }

        public Builder engineSettings(Map<String, EngineSettings> settings) {
            this.settings = settings;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder beforeEval(Consumer<Bindings> beforeEval) {
            this.beforeEval = beforeEval;
            return this;
        }

        public Builder afterSuccess(Consumer<Bindings> afterSuccess) {
            this.afterSuccess = afterSuccess;
            return this;
        }

        public Builder afterTimeout(Consumer<Bindings> afterTimeout) {
            this.afterTimeout = afterTimeout;
            return this;
        }

        public Builder afterFailure(BiConsumer<Bindings, Exception> afterFailure) {
            this.afterFailure = afterFailure;
            return this;
        }

        public Builder use(List<List<String>> use) {
            this.use = use;
            return this;
        }

        public Builder enabledPlugins(Set<String> enabledPlugins) {
            this.enabledPlugins = enabledPlugins;
            return this;
        }

        public GremlinExecutor create() {
            return new GremlinExecutor(this.settings, this.use, this.scriptEvaluationTimeout, this.globalBindings, this.executorService, this.scheduledExecutorService, this.beforeEval, this.afterSuccess, this.afterTimeout, this.afterFailure, this.enabledPlugins);
        }
    }
}

