/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.engine;

import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import com.tinkerpop.gremlin.groovy.loaders.SugarLoader;
import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.TraversalEngine;
import com.tinkerpop.gremlin.process.computer.ComputerResult;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.traversal.TraversalScript;
import com.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import com.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import com.tinkerpop.gremlin.process.graph.util.DefaultGraphTraversal;
import com.tinkerpop.gremlin.structure.Graph;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.configuration.Configuration;

public class GroovyTraversalScript<S, E>
implements TraversalScript<S, E> {
    private static final String ENGINE_NAME = new GremlinGroovyScriptEngineFactory().getEngineName();
    protected String openGraphScript;
    protected String traversalScript;
    protected String withSugarScript;
    protected String graphComputerScript;
    private GraphComputer graphComputer;

    private GroovyTraversalScript(String traversalScript) {
        this.traversalScript = "traversal = ".concat(traversalScript.replaceAll("\\.v\\((.*)\\)\\.", ".V().has(id, $1).").replaceAll("\\.e\\((.*)\\)\\.", ".E().has(id, $1).")).concat("\n");
    }

    public static <S, E> GroovyTraversalScript<S, E> of(String traversalScript) {
        return new GroovyTraversalScript<S, E>(traversalScript);
    }

    public GroovyTraversalScript<S, E> over(Graph graph) {
        Configuration configuration = graph.configuration();
        StringBuilder configurationMap = new StringBuilder("g = GraphFactory.open([");
        configuration.getKeys().forEachRemaining(key -> configurationMap.append("'").append((String)key).append("':'").append(configuration.getProperty(key)).append("',"));
        configurationMap.deleteCharAt(configurationMap.length() - 1).append("])\n");
        this.openGraphScript = configurationMap.toString();
        return this;
    }

    public GroovyTraversalScript<S, E> using(GraphComputer graphComputer) {
        this.graphComputer = graphComputer;
        this.graphComputerScript = "traversal.applyStrategies(" + TraversalEngine.class.getCanonicalName() + "." + TraversalEngine.COMPUTER + ")\n";
        return this;
    }

    public GroovyTraversalScript<S, E> withSugar() {
        this.withSugarScript = SugarLoader.class.getCanonicalName() + ".load()\n";
        return this;
    }

    public Future<ComputerResult> result() {
        return this.graphComputer.program((VertexProgram)this.program()).submit();
    }

    public Future<Traversal<S, E>> traversal() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                TraversalVertexProgram vertexProgram = this.program();
                ComputerResult result = (ComputerResult)this.graphComputer.program((VertexProgram)vertexProgram).submit().get();
                DefaultGraphTraversal traversal = new DefaultGraphTraversal(result.graph().getClass());
                return traversal.asAdmin().addStep((Step)new ComputerResultStep((Traversal)traversal, result, vertexProgram, true));
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
    }

    public TraversalVertexProgram program() {
        return (TraversalVertexProgram)TraversalVertexProgram.build().traversal(ENGINE_NAME, this.makeFullScript()).create();
    }

    private String makeFullScript() {
        StringBuilder builder = new StringBuilder();
        if (null != this.withSugarScript) {
            builder.append(this.withSugarScript);
        }
        if (null != this.openGraphScript) {
            builder.append(this.openGraphScript);
        }
        if (null != this.traversalScript) {
            builder.append(this.traversalScript);
        }
        if (null != this.graphComputerScript) {
            builder.append(this.graphComputerScript);
        }
        builder.append("traversal\n");
        return builder.toString();
    }
}

