/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.engine;

import com.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.SecurityCustomizerProvider;
import com.tinkerpop.gremlin.groovy.jsr223.DependencyManager;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import com.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import com.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngines
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ScriptEngines.class);
    private final Map<String, ScriptEngine> scriptEngines = new ConcurrentHashMap<String, ScriptEngine>();
    private final AtomicInteger evaluationCount = new AtomicInteger(0);
    private volatile boolean controlOperationExecuting = false;
    private static final GremlinGroovyScriptEngineFactory gremlinGroovyScriptEngineFactory = new GremlinGroovyScriptEngineFactory();
    private final Consumer<ScriptEngines> initializer;

    public ScriptEngines(Consumer<ScriptEngines> initializer) {
        this.initializer = initializer;
        this.initializer.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, Bindings bindings, String language) throws ScriptException {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException(String.format("Language [%s] not supported", language));
        }
        try {
            this.awaitControlOp();
            this.evaluationCount.incrementAndGet();
            Object object = this.scriptEngines.get(language).eval(script, bindings);
            return object;
        }
        finally {
            this.evaluationCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(Reader reader, Bindings bindings, String language) throws ScriptException {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException("Language [%s] not supported");
        }
        try {
            this.evaluationCount.incrementAndGet();
            Object object = this.scriptEngines.get(language).eval(reader, bindings);
            return object;
        }
        finally {
            this.evaluationCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String language, Set<String> imports, Set<String> staticImports, Map<String, Object> config) {
        this.signalControlOp();
        try {
            if (this.scriptEngines.containsKey(language)) {
                this.scriptEngines.remove(language);
            }
            ScriptEngine scriptEngine = ScriptEngines.createScriptEngine(language, imports, staticImports, config).orElseThrow(() -> new IllegalArgumentException("Language [%s] not supported"));
            this.scriptEngines.put(language, scriptEngine);
            logger.info("Loaded {} ScriptEngine", (Object)language);
        }
        finally {
            this.controlOperationExecuting = false;
        }
    }

    public void addImports(Set<String> imports) {
        this.signalControlOp();
        try {
            this.getDependencyManagers().forEach(dm -> dm.addImports(imports));
        }
        finally {
            this.controlOperationExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GremlinPlugin> use(String group, String artifact, String version) {
        this.signalControlOp();
        ArrayList<GremlinPlugin> pluginsToLoad = new ArrayList<GremlinPlugin>();
        try {
            this.getDependencyManagers().forEach(dm -> {
                try {
                    pluginsToLoad.addAll(dm.use(group, artifact, version));
                }
                catch (Exception ex) {
                    logger.warn("Could not get dependency for [{}, {}, {}] - {}", new Object[]{group, artifact, version, ex.getMessage()});
                }
            });
        }
        finally {
            this.controlOperationExecuting = false;
        }
        return pluginsToLoad;
    }

    public void loadPlugins(List<GremlinPlugin> plugins) {
        this.signalControlOp();
        this.getDependencyManagers().forEach(dm -> {
            try {
                dm.loadPlugins(plugins);
            }
            catch (IllegalEnvironmentException iee) {
                logger.warn("Some plugins may not have been loaded to {} - {}", (Object)dm.getClass().getSimpleName(), (Object)iee.getMessage());
            }
            catch (Exception ex) {
                logger.error(String.format("Some plugins may not have been loaded to %s", dm.getClass().getSimpleName()), (Throwable)ex);
            }
            finally {
                this.controlOperationExecuting = false;
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.signalControlOp();
        try {
            this.scriptEngines.values().stream().filter(se -> se instanceof Closeable).map(se -> (Closeable)((Object)se)).forEach(c -> {
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            this.scriptEngines.clear();
        }
        finally {
            this.controlOperationExecuting = false;
        }
    }

    public void reset() {
        this.signalControlOp();
        try {
            this.getDependencyManagers().forEach(DependencyManager::reset);
        }
        finally {
            this.controlOperationExecuting = false;
            this.initializer.accept(this);
        }
    }

    public Map<String, List<Map>> dependencies() {
        HashMap<String, List<Map>> m = new HashMap<String, List<Map>>();
        this.scriptEngines.entrySet().stream().filter(kv -> kv.getValue() instanceof DependencyManager).forEach(kv -> m.put((String)kv.getKey(), Arrays.asList(((DependencyManager)kv.getValue()).dependencies())));
        return m;
    }

    public Map<String, List<Map>> imports() {
        HashMap<String, List<Map>> m = new HashMap<String, List<Map>>();
        this.scriptEngines.entrySet().stream().filter(kv -> kv.getValue() instanceof DependencyManager).forEach(kv -> m.put((String)kv.getKey(), Arrays.asList(((DependencyManager)kv.getValue()).imports())));
        return m;
    }

    private Set<DependencyManager> getDependencyManagers() {
        return this.scriptEngines.entrySet().stream().map(Map.Entry::getValue).filter(se -> se instanceof DependencyManager).map(se -> (DependencyManager)((Object)se)).collect(Collectors.toSet());
    }

    private void signalControlOp() {
        this.awaitControlOp();
        this.controlOperationExecuting = true;
        this.awaitEvalOp();
    }

    private void awaitControlOp() {
        while (this.controlOperationExecuting) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private void awaitEvalOp() {
        while (this.evaluationCount.get() > 0) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private static synchronized Optional<ScriptEngine> createScriptEngine(String language, Set<String> imports, Set<String> staticImports, Map<String, Object> config) {
        if (language.equals(gremlinGroovyScriptEngineFactory.getLanguageName())) {
            String clazz = (String)config.getOrDefault("sandbox", "");
            SecurityCustomizerProvider securityCustomizerProvider = null;
            if (!clazz.isEmpty()) {
                try {
                    Class<?> providerClass = Class.forName(clazz);
                    GroovyInterceptor interceptor = (GroovyInterceptor)providerClass.newInstance();
                    securityCustomizerProvider = new SecurityCustomizerProvider(interceptor);
                }
                catch (Exception ex) {
                    logger.warn("Could not instantiate GroovyInterceptor implementation [%s] for the SecurityCustomizerProvider.  It will not be applied.", (Object)clazz);
                    securityCustomizerProvider = null;
                }
            }
            return Optional.of(new GremlinGroovyScriptEngine(new DefaultImportCustomizerProvider(imports, staticImports), securityCustomizerProvider));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        return Optional.ofNullable(manager.getEngineByName(language));
    }
}

