/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.jsr223;

import com.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.EmptyImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.ImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.SecurityCustomizerProvider;
import com.tinkerpop.gremlin.groovy.jsr223.DependencyManager;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyClassLoader;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import com.tinkerpop.gremlin.groovy.jsr223.ManagedConcurrentValueMap;
import com.tinkerpop.gremlin.groovy.jsr223.ScriptEnginePluginAcceptor;
import com.tinkerpop.gremlin.groovy.loaders.GremlinLoader;
import com.tinkerpop.gremlin.groovy.plugin.Artifact;
import com.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import com.tinkerpop.gremlin.groovy.plugin.GremlinPluginException;
import groovy.grape.Grape;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.lang.Tuple;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.util.ReferenceBundle;

public class GremlinGroovyScriptEngine
extends GroovyScriptEngineImpl
implements DependencyManager,
AutoCloseable {
    public static final String KEY_REFERENCE_TYPE = "#jsr223.groovy.engine.keep.globals";
    public static final String REFERENCE_TYPE_PHANTOM = "phantom";
    public static final String REFERENCE_TYPE_WEAK = "weak";
    public static final String REFERENCE_TYPE_SOFT = "soft";
    public static final String REFERENCE_TYPE_HARD = "hard";
    private static final Pattern patternImportStatic = Pattern.compile("\\Aimport\\sstatic.*");
    private ThreadLocal<Boolean> registeredSandbox = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ManagedConcurrentValueMap<String, Class> classMap = new ManagedConcurrentValueMap(ReferenceBundle.getSoftBundle());
    private ManagedConcurrentValueMap<String, Closure> globalClosures = new ManagedConcurrentValueMap(ReferenceBundle.getHardBundle());
    protected GremlinGroovyClassLoader loader;
    private AtomicLong counter = new AtomicLong(0L);
    private final Set<String> loadedPlugins = new HashSet<String>();
    private volatile GremlinGroovyScriptEngineFactory factory;
    private static final String STATIC = "static";
    private static final String SCRIPT = "Script";
    private static final String DOT_GROOVY = ".groovy";
    private static final String GROOVY_LANG_SCRIPT = "groovy.lang.Script";
    private ImportCustomizerProvider importCustomizerProvider;
    private Optional<SecurityCustomizerProvider> securityProvider;
    private final Set<Artifact> artifactsToUse = new HashSet<Artifact>();

    public GremlinGroovyScriptEngine() {
        this(new DefaultImportCustomizerProvider());
    }

    public GremlinGroovyScriptEngine(ImportCustomizerProvider importCustomizerProvider) {
        this(importCustomizerProvider, null);
    }

    public GremlinGroovyScriptEngine(ImportCustomizerProvider importCustomizerProvider, SecurityCustomizerProvider securityCustomizerProvider) {
        GremlinLoader.load();
        this.importCustomizerProvider = importCustomizerProvider;
        this.securityProvider = Optional.ofNullable(securityCustomizerProvider);
        this.createClassLoader();
    }

    @Override
    public synchronized List<GremlinPlugin> use(final String group, final String artifact, final String version) {
        HashMap<String, Object> dependency = new HashMap<String, Object>(){
            {
                this.put("group", group);
                this.put("module", artifact);
                this.put("version", version);
            }
        };
        HashMap<String, Object> args = new HashMap<String, Object>(){
            {
                this.put("classLoader", GremlinGroovyScriptEngine.this.loader);
            }
        };
        Grape.grab((Map)args, (Map[])new Map[]{dependency});
        ArrayList<GremlinPlugin> pluginsFound = new ArrayList<GremlinPlugin>();
        ServiceLoader.load(GremlinPlugin.class, (ClassLoader)((Object)this.loader)).forEach(pluginsFound::add);
        this.artifactsToUse.add(new Artifact(group, artifact, version));
        return pluginsFound;
    }

    @Override
    public void loadPlugins(List<GremlinPlugin> plugins) throws GremlinPluginException {
        for (GremlinPlugin gremlinPlugin : plugins) {
            if (this.loadedPlugins.contains(gremlinPlugin.getName())) continue;
            gremlinPlugin.pluginTo(new ScriptEnginePluginAcceptor((ScriptEngine)((Object)this)));
            this.loadedPlugins.add(gremlinPlugin.getName());
        }
    }

    @Override
    public Map[] dependencies() {
        return Grape.listDependencies((ClassLoader)((Object)this.loader));
    }

    @Override
    public Map<String, Set<String>> imports() {
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        m.put("imports", this.importCustomizerProvider.getImports());
        m.put("staticImports", this.importCustomizerProvider.getStaticImports());
        m.put("extraImports", this.importCustomizerProvider.getExtraImports());
        m.put("extraStaticImports", this.importCustomizerProvider.getExtraStaticImports());
        return m;
    }

    @Override
    public synchronized void addImports(Set<String> importStatements) {
        HashSet<String> staticImports = new HashSet<String>();
        HashSet<String> imports = new HashSet<String>();
        importStatements.forEach(s -> {
            String trimmed = s.trim();
            if (patternImportStatic.matcher(trimmed).matches()) {
                int pos = trimmed.indexOf(STATIC);
                staticImports.add(s.substring(pos + 6).trim());
            } else {
                imports.add(s.substring(6).trim());
            }
        });
        this.importCustomizerProvider = new EmptyImportCustomizerProvider(this.importCustomizerProvider, imports, staticImports);
        this.reset();
    }

    public Set plugins() {
        return this.loadedPlugins;
    }

    @Override
    public void close() throws Exception {
        this.securityProvider.ifPresent(SecurityCustomizerProvider::unregisterInterceptors);
    }

    @Override
    public void reset() {
        this.securityProvider.ifPresent(SecurityCustomizerProvider::unregisterInterceptors);
        this.createClassLoader();
        this.classMap.clear();
        this.globalClosures.clear();
        this.loadedPlugins.clear();
        HashSet<Artifact> toReuse = new HashSet<Artifact>(this.artifactsToUse);
        toReuse.forEach(this::use);
        this.getContext().getBindings(100).clear();
    }

    private void use(Artifact artifact) {
        this.use(artifact.getGroup(), artifact.getArtifact(), artifact.getVersion());
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        try {
            String val = (String)context.getAttribute(KEY_REFERENCE_TYPE, 100);
            ReferenceBundle bundle = ReferenceBundle.getHardBundle();
            if (val != null && val.length() > 0) {
                if (val.equalsIgnoreCase(REFERENCE_TYPE_SOFT)) {
                    bundle = ReferenceBundle.getSoftBundle();
                } else if (val.equalsIgnoreCase(REFERENCE_TYPE_WEAK)) {
                    bundle = ReferenceBundle.getWeakBundle();
                } else if (val.equalsIgnoreCase(REFERENCE_TYPE_PHANTOM)) {
                    bundle = ReferenceBundle.getPhantomBundle();
                }
            }
            this.globalClosures.setBundle(bundle);
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        try {
            Class clazz = this.getScriptClass(script);
            if (null == clazz) {
                throw new ScriptException("Script class is null");
            }
            return this.eval(clazz, context);
        }
        catch (SyntaxException e) {
            throw new ScriptException(e.getMessage(), e.getSourceLocator(), e.getLine());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            GremlinGroovyScriptEngine gremlinGroovyScriptEngine = this;
            synchronized (gremlinGroovyScriptEngine) {
                if (this.factory == null) {
                    this.factory = new GremlinGroovyScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public CompiledScript compile(String scriptSource) throws ScriptException {
        try {
            return new GroovyCompiledScript((GroovyScriptEngineImpl)this, this.getScriptClass(scriptSource));
        }
        catch (SyntaxException e) {
            throw new ScriptException(e.getMessage(), e.getSourceLocator(), e.getLine());
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (CompilationFailedException ee) {
            throw new ScriptException((Exception)((Object)ee));
        }
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object invokeFunction(String name, Object[] args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    public Object invokeMethod(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("Script object can not be null");
        }
        return this.invokeImpl(thiz, name, args);
    }

    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    public <T> T getInterface(Object thiz, Class<T> clazz) {
        if (null == thiz) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(thiz, clazz);
    }

    Class getScriptClass(String script) throws SyntaxException, CompilationFailedException, IOException {
        this.ensureSandbox();
        Class clazz = this.classMap.get(script);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.loader.parseClass(script, this.generateScriptName());
        this.classMap.put(script, clazz);
        return clazz;
    }

    Object eval(Class scriptClass, final ScriptContext context) throws ScriptException {
        this.ensureSandbox();
        context.setAttribute("context", context, 100);
        Writer writer = context.getWriter();
        context.setAttribute("out", writer instanceof PrintWriter ? writer : new PrintWriter(writer), 100);
        Binding binding = new Binding(){

            public Object getVariable(String name) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope != -1) {
                        return context.getAttribute(name, scope);
                    }
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setVariable(String name, Object value) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    context.setAttribute(name, value, scope);
                }
            }
        };
        try {
            Script scriptObject = InvokerHelper.createScript((Class)scriptClass, (Binding)binding);
            Stream.of(scriptClass.getMethods()).forEach(m -> {
                String name = m.getName();
                this.globalClosures.put(name, (Closure)new MethodClosure((Object)scriptObject, name));
            });
            MetaClass oldMetaClass = scriptObject.getMetaClass();
            scriptObject.setMetaClass((MetaClass)new DelegatingMetaClass(oldMetaClass){

                public Object invokeMethod(Object object, String name, Object args) {
                    if (args == null) {
                        return this.invokeMethod(object, name, MetaClassHelper.EMPTY_ARRAY);
                    }
                    if (args instanceof Tuple) {
                        return this.invokeMethod(object, name, ((Tuple)args).toArray());
                    }
                    if (args instanceof Object[]) {
                        return this.invokeMethod(object, name, (Object[])args);
                    }
                    return this.invokeMethod(object, name, new Object[]{args});
                }

                public Object invokeMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }

                public Object invokeStaticMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeStaticMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }
            });
            return scriptObject.run();
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private void ensureSandbox() {
        if (this.securityProvider.isPresent() && !this.registeredSandbox.get().booleanValue()) {
            this.securityProvider.get().registerInterceptors();
            this.registeredSandbox.set(true);
        }
    }

    private Object invokeImpl(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("Method name can not be null");
        }
        try {
            if (thiz != null) {
                return InvokerHelper.invokeMethod((Object)thiz, (String)name, (Object)args);
            }
        }
        catch (MissingMethodException mme) {
            throw new NoSuchMethodException(mme.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.callGlobal(name, args);
    }

    private synchronized void createClassLoader() {
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.addCompilationCustomizers(new CompilationCustomizer[]{this.importCustomizerProvider.getCompilationCustomizer()});
        if (this.securityProvider.isPresent()) {
            conf.addCompilationCustomizers(new CompilationCustomizer[]{this.securityProvider.get().getCompilationCustomizer()});
        }
        this.loader = new GremlinGroovyClassLoader(this.getParentLoader(), conf);
        this.securityProvider.ifPresent(SecurityCustomizerProvider::registerInterceptors);
    }

    private Object callGlobal(String name, Object[] args) {
        return this.callGlobal(name, args, this.context);
    }

    private Object callGlobal(String name, Object[] args, ScriptContext ctx) {
        Closure closure = this.globalClosures.get(name);
        if (closure != null) {
            return closure.call(args);
        }
        Object value = ctx.getAttribute(name);
        if (value instanceof Closure) {
            return ((Closure)value).call(args);
        }
        throw new MissingMethodException(name, this.getClass(), args);
    }

    private synchronized String generateScriptName() {
        return SCRIPT + this.counter.incrementAndGet() + DOT_GROOVY;
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (null == clazz || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, m, args) -> this.invokeImpl(obj, m.getName(), args));
    }

    protected ClassLoader getParentLoader() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = ctxtLoader.loadClass(GROOVY_LANG_SCRIPT);
            if (c == Script.class) {
                return ctxtLoader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Script.class.getClassLoader();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }
}

