/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.GraphProvider;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.TestHelper;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.io.kryo.KryoReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractGraphProvider
implements GraphProvider {
    public abstract Map<String, Object> getBaseConfiguration(String var1, Class<?> var2, String var3);

    @Override
    public Configuration newGraphConfiguration(String graphName, Class<?> test, String testMethodName, Map<String, Object> configurationOverrides) {
        BaseConfiguration conf = new BaseConfiguration();
        this.getBaseConfiguration(graphName, test, testMethodName).entrySet().stream().forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$12((Configuration)conf, arg_0));
        configurationOverrides.entrySet().stream().filter(c -> !((String)c.getKey()).equals("gremlin.graph")).forEach(arg_0 -> AbstractGraphProvider.lambda$newGraphConfiguration$14((Configuration)conf, arg_0));
        return conf;
    }

    @Override
    public void loadGraphData(Graph g, LoadGraphWith loadGraphWith, Class testClass, String testName) {
        try {
            if (loadGraphWith != null) {
                this.readIntoGraph(g, loadGraphWith.value().location());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Graph could not be loaded with data for test: " + ioe.getMessage());
        }
    }

    protected static void deleteDirectory(File directory) {
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    AbstractGraphProvider.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
        if (directory.exists()) {
            System.err.println("unable to delete directory " + directory.getAbsolutePath());
        }
    }

    protected String getWorkingDirectory() {
        return TestHelper.makeTestDataPath(this.getClass(), "graph-provider-data").getAbsolutePath();
    }

    protected void readIntoGraph(Graph g, String path) throws IOException {
        File workingDirectory = TestHelper.makeTestDataPath(this.getClass(), "kryo-working-directory");
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        KryoReader reader = KryoReader.build().workingDirectory(workingDirectory.getAbsolutePath()).mapper(g.io().kryoMapper().create()).create();
        try (InputStream stream = AbstractGremlinTest.class.getResourceAsStream(path);){
            reader.readGraph(stream, g);
        }
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$14(Configuration configuration, Map.Entry e) {
        configuration.setProperty((String)e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$newGraphConfiguration$12(Configuration configuration, Map.Entry e) {
        configuration.setProperty((String)e.getKey(), e.getValue());
    }
}

