/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.GraphManager;
import com.tinkerpop.gremlin.GraphProvider;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.javatuples.Pair;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public abstract class AbstractGremlinSuite
extends Suite {
    private static final Set<Class> STRUCTURE_INTERFACES = new HashSet<Class>(){
        {
            this.add(Edge.class);
            this.add(Edge.Iterators.class);
            this.add(Element.class);
            this.add(Element.Iterators.class);
            this.add(Graph.class);
            this.add(Graph.Variables.class);
            this.add(Property.class);
            this.add(Vertex.class);
            this.add(Vertex.Iterators.class);
            this.add(VertexProperty.class);
            this.add(VertexProperty.Iterators.class);
        }
    };
    private final boolean gremlinFlavorSuite;

    public AbstractGremlinSuite(Class<?> klass, RunnerBuilder builder, Class<?>[] testsToExecute) throws InitializationError {
        this(klass, builder, testsToExecute, null);
    }

    public AbstractGremlinSuite(Class<?> klass, RunnerBuilder builder, Class<?>[] testsToExecute, Class<?>[] testsToEnforce) throws InitializationError {
        this(klass, builder, testsToExecute, testsToEnforce, false);
    }

    public AbstractGremlinSuite(Class<?> klass, RunnerBuilder builder, Class<?>[] testsToExecute, Class<?>[] testsToEnforce, boolean gremlinFlavorSuite) throws InitializationError {
        super(builder, klass, (Class[])AbstractGremlinSuite.enforce(testsToExecute, testsToEnforce));
        this.gremlinFlavorSuite = gremlinFlavorSuite;
        Pair<Class<? extends GraphProvider>, Class<? extends Graph>> pair = AbstractGremlinSuite.getGraphProviderClass(klass);
        this.validateOptInToSuite((Class)pair.getValue1());
        AbstractGremlinSuite.validateOptInAndOutAnnotationsOnGraph((Class)pair.getValue1());
        this.registerOptOuts((Class)pair.getValue1());
        try {
            GraphProvider graphProvider = (GraphProvider)((Class)pair.getValue0()).newInstance();
            this.validateStructureInterfacesRegistered(graphProvider);
            this.validateHelpersNotImplemented(graphProvider);
            GraphManager.set(graphProvider);
        }
        catch (Exception ex) {
            throw new InitializationError((Throwable)ex);
        }
    }

    private void validateStructureInterfacesRegistered(GraphProvider graphProvider) throws Exception {
        Set<Class> implementations = graphProvider.getImplementations();
        HashSet noImplementationRegistered = new HashSet();
        Configuration conf = graphProvider.newGraphConfiguration("prototype", AbstractGremlinSuite.class, "validateStructureInterfacesRegistered");
        Graph g = graphProvider.openTestGraph(conf);
        HashSet<Class> structureInterfaces = new HashSet<Class>(STRUCTURE_INTERFACES);
        if (!g.features().graph().variables().supportsVariables()) {
            structureInterfaces.remove(Graph.Variables.class);
        }
        if (!g.features().vertex().supportsMultiProperties()) {
            structureInterfaces.remove(VertexProperty.Iterators.class);
        }
        graphProvider.clear(g, conf);
        boolean missingImplementations = structureInterfaces.stream().anyMatch(iface -> {
            boolean noneMatch = implementations.stream().noneMatch(c -> iface.isAssignableFrom((Class<?>)c));
            if (noneMatch) {
                noImplementationRegistered.add(iface);
            }
            return noneMatch;
        });
        if (missingImplementations) {
            throw new RuntimeException(String.format("Implementations must register their implementations for the following interfaces %s", String.join((CharSequence)",", noImplementationRegistered.stream().map(Class::getName).collect(Collectors.toList()))));
        }
    }

    private void validateHelpersNotImplemented(GraphProvider graphProvider) {
        ArrayList overridenMethods = new ArrayList();
        graphProvider.getImplementations().forEach(clazz -> Stream.of(clazz.getDeclaredMethods()).filter(AbstractGremlinSuite::isHelperMethodOverriden).map(m -> m.getDeclaringClass().getName() + "." + m.getName()).forEach(overridenMethods::add));
        if (overridenMethods.size() > 0) {
            throw new RuntimeException(String.format("Implementations cannot override methods marked by @Helper annotation - check the following methods [%s]", String.join((CharSequence)",", overridenMethods)));
        }
    }

    private void validateOptInToSuite(Class<? extends Graph> klass) throws InitializationError {
        Graph.OptIn[] optIns = (Graph.OptIn[])klass.getAnnotationsByType(Graph.OptIn.class);
        if (!this.gremlinFlavorSuite && !Arrays.stream(optIns).anyMatch(optIn -> optIn.value().equals(((Object)((Object)this)).getClass().getCanonicalName()))) {
            throw new InitializationError("The suite will not run for this Graph until it is publicly acknowledged with the @OptIn annotation on the Graph instance itself");
        }
    }

    private void registerOptOuts(Class<? extends Graph> klass) throws InitializationError {
        Graph.OptOut[] optOuts = (Graph.OptOut[])klass.getAnnotationsByType(Graph.OptOut.class);
        if (optOuts != null && optOuts.length > 0) {
            if (!Arrays.stream(optOuts).allMatch(ignore -> ignore.test() != null && ignore.reason() != null && !ignore.reason().isEmpty())) {
                throw new InitializationError("Check @IgnoreTest annotations - all must have a 'test' and 'reason' set");
            }
            try {
                this.filter(new OptOutTestFilter(optOuts));
            }
            catch (NoTestsRemainException ex) {
                throw new InitializationError((Throwable)ex);
            }
        }
    }

    private static Class<?>[] enforce(Class<?>[] testsToExecute, Class<?>[] testsToEnforce) {
        if (null == testsToEnforce) {
            return testsToExecute;
        }
        List notSupplied = Stream.of(testsToEnforce).filter(t -> Stream.of(testsToExecute).noneMatch(t::isAssignableFrom)).collect(Collectors.toList());
        if (notSupplied.size() > 0) {
            System.err.println(String.format("Review the testsToExecute given to the test suite as the following are missing: %s", notSupplied));
        }
        return testsToExecute;
    }

    public static boolean isHelperMethodOverriden(Method myMethod) {
        Class<?> declaringClass = myMethod.getDeclaringClass();
        for (Class<?> iface : declaringClass.getInterfaces()) {
            try {
                return iface.getMethod(myMethod.getName(), myMethod.getParameterTypes()).isAnnotationPresent(Graph.Helper.class);
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        return false;
    }

    public static Pair<Class<? extends GraphProvider>, Class<? extends Graph>> getGraphProviderClass(Class<?> klass) throws InitializationError {
        GraphProviderClass annotation = klass.getAnnotation(GraphProviderClass.class);
        if (null == annotation) {
            throw new InitializationError(String.format("class '%s' must have a GraphProviderClass annotation", klass.getName()));
        }
        return Pair.with(annotation.provider(), annotation.graph());
    }

    public static void validateOptInAndOutAnnotationsOnGraph(Class<? extends Graph> klass) throws InitializationError {
        Graph.OptOut[] optOuts;
        for (Graph.OptOut optOut : optOuts = (Graph.OptOut[])klass.getAnnotationsByType(Graph.OptOut.class)) {
            Class<?> testClass;
            try {
                testClass = Class.forName(optOut.test());
            }
            catch (Exception ex) {
                throw new InitializationError(String.format("Invalid @OptOut on Graph instance.  Could not instantiate test class (it may have been renamed): %s", optOut.test()));
            }
            if (Arrays.stream(testClass.getMethods()).anyMatch(m -> m.getName().equals(optOut.method()))) continue;
            throw new InitializationError(String.format("Invalid @OptOut on Graph instance.  Could not match @OptOut test name %s on test class %s (it may have been renamed)", optOut.method(), optOut.test()));
        }
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        if (this.beforeTestExecution(runner.getDescription().getTestClass())) {
            super.runChild(runner, notifier);
        }
        this.afterTestExecution(runner.getDescription().getTestClass());
    }

    public boolean beforeTestExecution(Class<? extends AbstractGremlinTest> testClass) {
        return true;
    }

    public void afterTestExecution(Class<? extends AbstractGremlinTest> testClass) {
    }

    public static class OptOutTestFilter
    extends Filter {
        private final List<Description> testsToIgnore;

        public OptOutTestFilter(Graph.OptOut[] optOuts) {
            this.testsToIgnore = Arrays.stream(optOuts).map(ignoreTest -> Pair.with((Object)ignoreTest.test(), (Object)(ignoreTest.specific().isEmpty() ? ignoreTest.method() : String.format("%s[%s]", ignoreTest.method(), ignoreTest.specific())))).map(p -> Description.createTestDescription((String)p.getValue0().toString(), (String)p.getValue1().toString(), (Annotation[])new Annotation[0])).collect(Collectors.toList());
        }

        public boolean shouldRun(Description description) {
            if (description.isTest()) {
                return !this.testsToIgnore.contains(description);
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return String.format("Method %s", String.join((CharSequence)",", this.testsToIgnore.stream().map(Description::getDisplayName).collect(Collectors.toList())));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface GraphProviderClass {
        public Class<? extends Graph> graph();

        public Class<? extends GraphProvider> provider();
    }
}

