/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin;

import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.structure.Graph;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface LoadGraphWith {
    public static final String RESOURCE_PATH_PREFIX = "/com/tinkerpop/gremlin/structure/io/kryo/";

    public GraphData value() default GraphData.CLASSIC;

    public static enum GraphData {
        CLASSIC,
        MODERN,
        CREW,
        GRATEFUL;

        private static final List<FeatureRequirement> featuresRequiredByClassic;
        private static final List<FeatureRequirement> featuresRequiredByCrew;
        private static final List<FeatureRequirement> featuresRequiredByClassicDouble;
        private static final List<FeatureRequirement> featuresRequiredByGrateful;

        public String location() {
            switch (this) {
                case CLASSIC: {
                    return "/com/tinkerpop/gremlin/structure/io/kryo/tinkerpop-classic.gio";
                }
                case CREW: {
                    return "/com/tinkerpop/gremlin/structure/io/kryo/tinkerpop-crew.gio";
                }
                case MODERN: {
                    return "/com/tinkerpop/gremlin/structure/io/kryo/tinkerpop-modern.gio";
                }
                case GRATEFUL: {
                    return "/com/tinkerpop/gremlin/structure/io/kryo/grateful-dead.gio";
                }
            }
            throw new RuntimeException("No file for this GraphData type");
        }

        public List<FeatureRequirement> featuresRequired() {
            switch (this) {
                case CLASSIC: {
                    return featuresRequiredByClassic;
                }
                case CREW: {
                    return featuresRequiredByCrew;
                }
                case MODERN: {
                    return featuresRequiredByClassicDouble;
                }
                case GRATEFUL: {
                    return featuresRequiredByGrateful;
                }
            }
            throw new RuntimeException("No features for this GraphData type");
        }

        static {
            featuresRequiredByClassic = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("FloatValues", Graph.Features.EdgePropertyFeatures.class));
                }
            };
            featuresRequiredByCrew = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("BooleanValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("MetaProperties", Graph.Features.VertexFeatures.class));
                    this.add(FeatureRequirement.Factory.create("MultiProperties", Graph.Features.VertexFeatures.class));
                }
            };
            featuresRequiredByClassicDouble = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("DoubleValues", Graph.Features.EdgePropertyFeatures.class));
                }
            };
            featuresRequiredByGrateful = new ArrayList<FeatureRequirement>(){
                {
                    this.add(FeatureRequirement.Factory.create("StringValues", Graph.Features.VertexPropertyFeatures.class));
                    this.add(FeatureRequirement.Factory.create("IntegerValues", Graph.Features.VertexPropertyFeatures.class));
                }
            };
        }
    }
}

