/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class TestHelper {
    public static File makeTestDataPath(Class clazz, String childPath) {
        String buildDirectory = System.getProperty("build.dir");
        File root = null == buildDirectory ? new File(TestHelper.computePath(clazz)).getParentFile() : new File(buildDirectory);
        return new File(root, TestHelper.cleanPathSegment(childPath));
    }

    private static String computePath(Class clazz) {
        String clsUri = clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getClassLoader().getResource(clsUri);
        String clsPath = url.getPath();
        return clsPath.substring(0, clsPath.length() - clsUri.length());
    }

    public static File generateTempFile(Class clazz, String fileName, String fileNameSuffix) throws IOException {
        File path = TestHelper.makeTestDataPath(clazz, "temp");
        if (!path.exists()) {
            path.mkdirs();
        }
        return File.createTempFile(fileName, fileNameSuffix, path);
    }

    public static File generateTempFileFromResource(Class resourceClass, String resourceName, String extension) throws IOException {
        int data;
        File temp = TestHelper.makeTestDataPath(resourceClass, "resources");
        if (!temp.exists()) {
            temp.mkdirs();
        }
        File tempFile = new File(temp, resourceName + extension);
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        InputStream inputStream = resourceClass.getResourceAsStream(resourceName);
        while ((data = inputStream.read()) != -1) {
            outputStream.write(data);
        }
        outputStream.close();
        inputStream.close();
        return tempFile;
    }

    public static String cleanPathSegment(String toClean) {
        String cleaned = toClean.replaceAll("[.\\\\/:*?\"<>|\\[\\]\\(\\)]", "");
        if (cleaned.length() == 0) {
            throw new IllegalStateException("Path segment " + toClean + " has not valid characters and is thus empty");
        }
        return cleaned;
    }
}

