/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process;

import com.tinkerpop.gremlin.ExceptionCoverage;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Step;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.graph.AnonymousGraphTraversal;
import com.tinkerpop.gremlin.process.graph.GraphTraversal;
import com.tinkerpop.gremlin.process.util.BulkSet;
import com.tinkerpop.gremlin.structure.Contains;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Transaction;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverage(exceptionClass=Traversal.Exceptions.class, methods={"traversalIsLocked"})
public class CoreTraversalTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveNextAndToCollectionWorkProperly() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)(traversal.next() instanceof Vertex));
        Assert.assertEquals((long)4L, (long)traversal.next(4).size());
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        GraphTraversal intTraversal = AnonymousGraphTraversal.Tokens.__.inject(new Object[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        List list = intTraversal.toList();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)list.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(4)).intValue());
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = AnonymousGraphTraversal.Tokens.__.inject(new Object[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        Set set = intTraversal.toSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(7));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertTrue((boolean)set.contains(6));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = AnonymousGraphTraversal.Tokens.__.inject(new Object[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        BulkSet bulkSet = intTraversal.toBulkSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)bulkSet.uniqueSize());
        Assert.assertEquals((long)5L, (long)bulkSet.longSize());
        Assert.assertEquals((long)5L, (long)bulkSet.size());
        Assert.assertTrue((boolean)bulkSet.contains((Object)7));
        Assert.assertTrue((boolean)bulkSet.contains((Object)2));
        Assert.assertTrue((boolean)bulkSet.contains((Object)3));
        Assert.assertTrue((boolean)bulkSet.contains((Object)6));
        Assert.assertEquals((long)2L, (long)bulkSet.get((Object)7));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHavePropertyForEachRemainingBehaviorEvenWithStrategyRewrite() {
        GraphTraversal traversal = this.g.V(new Object[0]).out(new String[0]).groupCount();
        traversal.forEachRemaining(Map.class, map -> Assert.assertTrue((boolean)(map instanceof Map)));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAlterTraversalAfterTraversalBecomesLocked() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)traversal.hasNext());
        try {
            traversal.count().next();
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked()));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)Traversal.Exceptions.traversalIsLocked().getMessage(), (Object)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked() + " not " + e + ":" + e.getMessage()));
        }
        traversal.iterate();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAddStartsProperly() {
        GraphTraversal traversal = AnonymousGraphTraversal.Tokens.__.out(new String[0]).out(new String[0]);
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)traversal));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldTraversalResetProperly() {
        GraphTraversal traversal = AnonymousGraphTraversal.Tokens.__.as("a").out(new String[0]).out(new String[0]).has("name", (BiPredicate)Contains.within, Arrays.asList("ripple", "lop")).as("b");
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.next();
        Assert.assertTrue((boolean)traversal.hasNext());
        traversal.asAdmin().reset();
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal.asAdmin().addStarts(traversal.asAdmin().getTraverserGenerator().generateIterator((Iterator)this.g.V(new Object[0]), (Step)traversal.asAdmin().getSteps().get(0), 1L));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)traversal));
        Assert.assertFalse((boolean)traversal.hasNext());
        if (new Random().nextBoolean()) {
            traversal.asAdmin().reset();
        }
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfAutoTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.AUTO);
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfManualTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
        this.g.tx().rollback();
    }
}

