/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.graph.GraphTraversal;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Vertex;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;

public class GraphTraversalCoverageTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    public void shouldHaveSameTraversalReturnTypesForAllMethods() {
        HashSet allReturnTypes = new HashSet();
        List<Pair> vendorsClasses = Arrays.asList(Pair.with((Object)"g.V Traversal", (Object)this.g.V(new Object[0])), Pair.with((Object)"g.E Traversal", (Object)this.g.E(new Object[0])), Pair.with((Object)"v.identity Traversal", (Object)((Vertex)this.g.V(new Object[0]).next()).identity()), Pair.with((Object)"e.identity Traversal", (Object)((Edge)this.g.E(new Object[0]).next()).identity()), Pair.with((Object)"v", (Object)this.g.V(new Object[0]).next()), Pair.with((Object)"e", (Object)this.g.E(new Object[0]).next()));
        vendorsClasses.forEach(triplet -> {
            String situation = (String)triplet.getValue0();
            Class<?> vendorClass = triplet.getValue1().getClass();
            HashSet returnTypes = new HashSet();
            Arrays.asList(vendorClass.getMethods()).stream().filter(m -> GraphTraversal.class.isAssignableFrom(m.getReturnType())).filter(m -> !Modifier.isStatic(m.getModifiers())).map(m -> GraphTraversalCoverageTest.getDeclaredVersion(m, vendorClass)).forEach(m -> {
                returnTypes.add(m.getReturnType().getCanonicalName());
                allReturnTypes.add(m.getReturnType().getCanonicalName());
            });
            if (returnTypes.size() > 1) {
                boolean muted = Boolean.parseBoolean(System.getProperty("muteTestLogs", "false"));
                if (!muted) {
                    System.out.println("FAILURE: " + vendorClass.getCanonicalName() + " methods do not return in full fluency for [" + situation + "]");
                }
                Assert.fail((String)("The return types of all traversal methods should be the same to ensure proper fluency: " + returnTypes));
            } else {
                boolean muted = Boolean.parseBoolean(System.getProperty("muteTestLogs", "false"));
                if (!muted) {
                    System.out.println("SUCCESS: " + vendorClass.getCanonicalName() + " methods return in full fluency for [" + situation + "]");
                }
            }
        });
        if (allReturnTypes.size() > 1) {
            Assert.fail((String)("All traversals possible do not maintain the same return types and thus, not fully fluent for entire graph system: " + allReturnTypes));
        }
    }

    private static Method getDeclaredVersion(Method method, Class vendorClass) {
        return Arrays.asList(vendorClass.getMethods()).stream().filter(m -> !GraphTraversal.class.equals(m.getReturnType())).filter(m -> !Traversal.class.equals(m.getReturnType())).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> m.getName().equals(method.getName())).filter(m -> Arrays.asList(m.getParameterTypes()).toString().equals(Arrays.asList(method.getParameterTypes()).toString())).findAny().orElseGet(() -> {
            boolean muted = Boolean.parseBoolean(System.getProperty("muteTestLogs", "false"));
            if (!muted) {
                System.out.println("IGNORE IF TEST PASSES: Can not find native implementation of: " + method);
            }
            return method;
        });
    }
}

