/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.computer;

import com.tinkerpop.gremlin.ExceptionCoverage;
import com.tinkerpop.gremlin.ExceptionCoverageSet;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.computer.ComputerResult;
import com.tinkerpop.gremlin.process.computer.GraphComputer;
import com.tinkerpop.gremlin.process.computer.KeyValue;
import com.tinkerpop.gremlin.process.computer.MapReduce;
import com.tinkerpop.gremlin.process.computer.Memory;
import com.tinkerpop.gremlin.process.computer.VertexProgram;
import com.tinkerpop.gremlin.process.computer.lambda.LambdaMapReduce;
import com.tinkerpop.gremlin.process.computer.lambda.LambdaVertexProgram;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.util.StringFactory;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=GraphComputer.Exceptions.class, methods={"providedKeyIsNotAMemoryComputeKey", "computerHasNoVertexProgramNorMapReducers", "computerHasAlreadyBeenSubmittedAVertexProgram", "providedKeyIsNotAnElementComputeKey", "isolationNotSupported"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"graphDoesNotSupportProvidedGraphComputer", "onlyOneOrNoGraphComputerClass"})})
public abstract class GraphComputerTest
extends AbstractGremlinProcessTest {
    public abstract GraphComputer get_g_compute();

    public abstract GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX();

    public abstract GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXset_incr_and_orX();

    public abstract GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXnullX();

    public abstract GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysX_X();

    public abstract GraphComputer get_g_compute_setupXsetXa_trueXX_executeXX_terminateXtrueX();

    public abstract GraphComputer get_g_compute_setupXX_executeXv_blah_m_incrX_terminateX1X_elementKeysXnameLengthCounterX_memoryKeysXa_bX();

    public abstract GraphComputer get_g_compute_setupXabcdeX_executeXtestMemoryX_terminateXtestMemoryXmemoryKeysXabcdeX();

    public abstract GraphComputer get_g_compute_mapXageX_reduceXsumX_memoryXnextX_memoryKeyXageSumX();

    public abstract GraphComputer get_g_compute_executeXcounterX_terminateX8X_mapreduceXcounter_aX_mapreduceXcounter_bX();

    public abstract GraphComputer get_g_compute_mapXidX_reduceXidX_reduceKeySortXreverseX_memoryKeyXidsX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveStandardStringRepresentation() {
        GraphComputer computer = this.get_g_compute();
        Assert.assertEquals((Object)StringFactory.graphComputerString((GraphComputer)computer), (Object)computer.toString());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowWithNoVertexProgramNorMapReducers() throws Exception {
        try {
            this.get_g_compute().submit().get();
            Assert.fail((String)"Should throw an IllegalStateException when there is no vertex program nor map reducers");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(GraphComputer.Exceptions.computerHasNoVertexProgramNorMapReducers(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFailIfIsolationIsNotSupported() {
        GraphComputer computer = this.get_g_compute();
        if (!computer.features().supportsIsolation(GraphComputer.Isolation.BSP)) {
            try {
                computer.isolation(GraphComputer.Isolation.BSP);
                Assert.fail((String)"GraphComputer.isolation() should throw an exception if the isolation is not supported");
            }
            catch (Exception ex) {
                GraphComputerTest.validateException(GraphComputer.Exceptions.isolationNotSupported((GraphComputer.Isolation)GraphComputer.Isolation.BSP), ex);
            }
        }
        if (!computer.features().supportsIsolation(GraphComputer.Isolation.DIRTY_BSP)) {
            try {
                computer.isolation(GraphComputer.Isolation.DIRTY_BSP);
                Assert.fail((String)"GraphComputer.isolation() should throw an exception if the isolation is not supported");
            }
            catch (Exception ex) {
                GraphComputerTest.validateException(GraphComputer.Exceptions.isolationNotSupported((GraphComputer.Isolation)GraphComputer.Isolation.DIRTY_BSP), ex);
            }
        }
        Assert.assertEquals((Object)StringFactory.graphComputerString((GraphComputer)computer), (Object)computer.toString());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowBadGraphComputers() {
        try {
            this.g.compute(new Class[]{BadGraphComputer.class});
            Assert.fail((String)"Providing a bad graph computer class should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(BadGraphComputer.class), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveImmutableComputeResultMemory() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXset_incr_and_orX().submit().get();
        try {
            results.memory().set("set", (Object)"test");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().incr("incr", 1L);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().and("and", true);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
        try {
            results.memory().or("or", false);
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryIsCurrentlyImmutable(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowNullMemoryKeys() throws Exception {
        try {
            this.get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXnullX().submit().get();
            Assert.fail((String)"Providing null memory key should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowEmptyMemoryKeys() throws Exception {
        try {
            this.get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysX_X().submit().get();
            Assert.fail((String)"Providing empty memory key should fail");
        }
        catch (Exception ex) {
            GraphComputerTest.validateException(Memory.Exceptions.memoryKeyCanNotBeEmpty(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowSettingUndeclaredMemoryKeys() throws Exception {
        try {
            this.get_g_compute_setupXsetXa_trueXX_executeXX_terminateXtrueX().submit().get();
            Assert.fail((String)"Setting a memory key that wasn't declared should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOnlyAllowOneOrNoGraphComputerClass() throws Exception {
        try {
            this.g.compute(new Class[]{BadGraphComputer.class, BadGraphComputer.class}).submit().get();
            Assert.fail((String)"Should throw an IllegalArgument when two graph computers are passed in");
        }
        catch (Exception ex) {
            IllegalArgumentException expectedException = Graph.Exceptions.onlyOneOrNoGraphComputerClass();
            Assert.assertEquals(expectedException.getClass(), ex.getClass());
            Assert.assertEquals((Object)expectedException.getMessage(), (Object)ex.getMessage());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAllowTheSameComputerToExecutedTwice() throws Exception {
        GraphComputer computer = this.get_g_compute_setupXX_executeXX_terminateXtrueX();
        computer.submit().get();
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
        try {
            computer.submit();
            Assert.fail((String)"Using the same graph computer to compute again should not be possible");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should yield an illegal state exception for graph computer being executed twice");
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveConsistentMemoryVertexPropertiesAndExceptions() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_setupXX_executeXv_blah_m_incrX_terminateX1X_elementKeysXnameLengthCounterX_memoryKeysXa_bX().submit().get();
        Assert.assertEquals((long)1L, (long)results.memory().getIteration());
        Assert.assertEquals((long)2L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)2L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((results.memory().getRuntime() >= 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)12L, (Object)results.memory().get("a"));
        Assert.assertEquals((Object)28L, (Object)results.memory().get("b"));
        try {
            results.memory().get("BAD");
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)Memory.Exceptions.memoryDoesNotExist((String)"BAD").getMessage(), (Object)e.getMessage());
        }
        Assert.assertEquals((Object)6L, (Object)results.graph().V(new Object[0]).count().next());
        results.graph().V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)v.property("nameLengthCounter").isPresent());
            Assert.assertEquals((Object)(((String)v.value("name")).length() * 2), (Object)((Integer)v.value("nameLengthCounter")));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAndOrIncrCorrectlyThroughSubStages() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_setupXabcdeX_executeXtestMemoryX_terminateXtestMemoryXmemoryKeysXabcdeX().submit().get();
        Assert.assertEquals((long)2L, (long)results.memory().getIteration());
        Assert.assertEquals((long)5L, (long)results.memory().asMap().size());
        Assert.assertEquals((long)5L, (long)results.memory().keys().size());
        Assert.assertTrue((boolean)results.memory().keys().contains("a"));
        Assert.assertTrue((boolean)results.memory().keys().contains("b"));
        Assert.assertTrue((boolean)results.memory().keys().contains("c"));
        Assert.assertTrue((boolean)results.memory().keys().contains("d"));
        Assert.assertTrue((boolean)results.memory().keys().contains("e"));
        Assert.assertEquals((Object)18L, (Object)results.memory().get("a"));
        Assert.assertEquals((Object)0L, (Object)results.memory().get("b"));
        Assert.assertFalse((boolean)((Boolean)results.memory().get("c")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("d")));
        Assert.assertTrue((boolean)((Boolean)results.memory().get("e")));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowMapReduceWithNoVertexProgram() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_mapXageX_reduceXsumX_memoryXnextX_memoryKeyXageSumX().submit().get();
        Assert.assertEquals((long)123L, (long)((Integer)results.memory().get("ageSum")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportMultipleMapReduceJobs() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_executeXcounterX_terminateX8X_mapreduceXcounter_aX_mapreduceXcounter_bX().submit().get();
        Assert.assertEquals((long)60L, (long)((Integer)results.memory().get("a")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)results.memory().get("b")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSortReduceOutput() throws Exception {
        ComputerResult results = (ComputerResult)this.get_g_compute_mapXidX_reduceXidX_reduceKeySortXreverseX_memoryKeyXidsX().submit().get();
        List ids = (List)results.memory().get("ids");
        Assert.assertEquals((long)6L, (long)ids.size());
        for (int i = 1; i < ids.size(); ++i) {
            Assert.assertTrue(((Long)ids.get(i) < (Long)ids.get(i - 1) ? 1 : 0) != 0);
        }
    }

    class BadGraphComputer
    implements GraphComputer {
        BadGraphComputer() {
        }

        public GraphComputer isolation(GraphComputer.Isolation isolation) {
            return null;
        }

        public GraphComputer program(VertexProgram vertexProgram) {
            return null;
        }

        public GraphComputer mapReduce(MapReduce mapReduce) {
            return null;
        }

        public Future<ComputerResult> submit() {
            return null;
        }
    }

    public static class ComputerTest
    extends GraphComputerTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public GraphComputer get_g_compute() {
            return this.g.compute(new Class[0]);
        }

        @Override
        public GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().create());
        }

        @Override
        public GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXset_incr_and_orX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().memoryComputeKeys(new String[]{"set", "incr", "and", "or"}).create());
        }

        @Override
        public GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysXnullX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().memoryComputeKeys((Set)new HashSet<String>(){
                {
                    this.add(null);
                }
            }).create());
        }

        @Override
        public GraphComputer get_g_compute_setupXX_executeXX_terminateXtrueX_memoryKeysX_X() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().memoryComputeKeys(new String[]{""}).create());
        }

        @Override
        public GraphComputer get_g_compute_setupXsetXa_trueXX_executeXX_terminateXtrueX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().setup(m -> m.set("a", (Object)true)).create());
        }

        @Override
        public GraphComputer get_g_compute_setupXX_executeXv_blah_m_incrX_terminateX1X_elementKeysXnameLengthCounterX_memoryKeysXa_bX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().setup(memory -> {}).execute((vertex, messenger, memory) -> {
                try {
                    vertex.property("blah", (Object)"blah");
                    Assert.fail((String)"Should throw an IllegalArgumentException");
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)"blah").getMessage(), (Object)e.getMessage());
                }
                catch (Exception e) {
                    Assert.fail((String)("Should throw an IllegalArgumentException: " + e));
                }
                memory.incr("a", 1L);
                if (memory.isInitialIteration()) {
                    vertex.property("nameLengthCounter", (Object)((String)vertex.value("name")).length());
                    memory.incr("b", (long)((String)vertex.value("name")).length());
                } else {
                    vertex.singleProperty("nameLengthCounter", (Object)(((String)vertex.value("name")).length() + (Integer)vertex.value("nameLengthCounter")), new Object[0]);
                }
            }).terminate(memory -> memory.getIteration() == 1).elementComputeKeys(new String[]{"nameLengthCounter"}).memoryComputeKeys(new String[]{"a", "b"}).create());
        }

        @Override
        public GraphComputer get_g_compute_setupXabcdeX_executeXtestMemoryX_terminateXtestMemoryXmemoryKeysXabcdeX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().setup(memory -> {
                memory.set("a", (Object)0L);
                memory.set("b", (Object)0L);
                memory.set("c", (Object)true);
                memory.set("d", (Object)false);
                memory.set("e", (Object)true);
            }).execute((vertex, messenger, memory) -> {
                Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
                Assert.assertEquals((Object)0L, (Object)memory.get("b"));
                if (memory.isInitialIteration()) {
                    Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                    Assert.assertFalse((boolean)((Boolean)memory.get("d")));
                } else {
                    Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                    Assert.assertTrue((boolean)((Boolean)memory.get("d")));
                }
                Assert.assertTrue((boolean)((Boolean)memory.get("e")));
                Assert.assertEquals((long)(Long.valueOf(6 * memory.getIteration()) + 1L), (long)memory.incr("a", 1L));
                Assert.assertEquals((long)(Long.valueOf(0L) + 1L), (long)memory.incr("b", 1L));
                Assert.assertFalse((boolean)memory.and("c", false));
                Assert.assertTrue((boolean)memory.or("d", true));
                Assert.assertFalse((boolean)memory.and("e", false));
                Assert.assertEquals((Object)(6 * memory.getIteration()), (Object)memory.get("a"));
                Assert.assertEquals((Object)0L, (Object)memory.get("b"));
                if (memory.isInitialIteration()) {
                    Assert.assertTrue((boolean)((Boolean)memory.get("c")));
                    Assert.assertFalse((boolean)((Boolean)memory.get("d")));
                } else {
                    Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                    Assert.assertTrue((boolean)((Boolean)memory.get("d")));
                }
                Assert.assertTrue((boolean)((Boolean)memory.get("e")));
            }).terminate(memory -> {
                Assert.assertEquals((Object)(6 * (memory.getIteration() + 1)), (Object)memory.get("a"));
                Assert.assertEquals((Object)6L, (Object)memory.get("b"));
                Assert.assertFalse((boolean)((Boolean)memory.get("c")));
                Assert.assertTrue((boolean)((Boolean)memory.get("d")));
                Assert.assertFalse((boolean)((Boolean)memory.get("e")));
                memory.set("b", (Object)0L);
                memory.set("e", (Object)true);
                return memory.getIteration() > 1;
            }).memoryComputeKeys(new String[]{"a", "b", "c", "d", "e"}).create());
        }

        @Override
        public GraphComputer get_g_compute_mapXageX_reduceXsumX_memoryXnextX_memoryKeyXageSumX() {
            return this.g.compute(new Class[0]).mapReduce((MapReduce)LambdaMapReduce.build().map((v, e) -> v.property("age").ifPresent(age -> e.emit((Object)MapReduce.NullObject.instance(), age))).reduce((k, vv, e) -> e.emit((Object)StreamFactory.stream((Iterator)vv).mapToInt(i -> i).sum())).memory(i -> (Integer)((KeyValue)i.next()).getValue()).memoryKey("ageSum").create());
        }

        @Override
        public GraphComputer get_g_compute_executeXcounterX_terminateX8X_mapreduceXcounter_aX_mapreduceXcounter_bX() {
            return this.g.compute(new Class[0]).program(LambdaVertexProgram.build().execute((vertex, messenger, memory) -> vertex.singleProperty("counter", (Object)(memory.isInitialIteration() ? 1 : (Integer)vertex.value("counter") + 1), new Object[0])).terminate(memory -> memory.getIteration() > 8).elementComputeKeys(new HashSet<String>(Arrays.asList("counter"))).create()).mapReduce((MapReduce)LambdaMapReduce.build().map((v, e) -> e.emit(v.value("counter"))).reduce((k, vv, e) -> {
                int counter = 0;
                while (vv.hasNext()) {
                    counter += ((Integer)vv.next()).intValue();
                }
                e.emit((Object)MapReduce.NullObject.instance(), (Object)counter);
            }).memory(i -> (Integer)((KeyValue)i.next()).getValue()).memoryKey("a").create()).mapReduce((MapReduce)LambdaMapReduce.build().map((v, e) -> e.emit((Object)MapReduce.NullObject.instance(), v.value("counter"))).combine((k, vv, e) -> e.emit((Object)1)).reduce((k, vv, e) -> e.emit((Object)1)).memory(i -> (Integer)((KeyValue)i.next()).getValue()).memoryKey("b").create());
        }

        @Override
        public GraphComputer get_g_compute_mapXidX_reduceXidX_reduceKeySortXreverseX_memoryKeyXidsX() {
            return this.g.compute(new Class[0]).mapReduce((MapReduce)LambdaMapReduce.build().map((vertex, emitter) -> emitter.emit((Object)Long.valueOf(vertex.id().toString()), (Object)Long.valueOf(vertex.id().toString()))).reduce((key, values, emitter) -> values.forEachRemaining(id -> emitter.emit(id, id))).memoryKey("ids").reduceKeySort(Comparator::reverseOrder).memory(itty -> {
                ArrayList list = new ArrayList();
                itty.forEachRemaining(id -> list.add(id.getKey()));
                return list;
            }).create());
        }
    }
}

