/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.computer.util;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.process.computer.util.ComputerDataStrategy;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ComputerDataStrategyTest
extends AbstractGremlinTest {
    @Test
    public void shouldFilterHiddenProperties() {
        StrategyGraph sg = this.g.strategy(new GraphStrategy[]{new ComputerDataStrategy(new HashSet<String>(Arrays.asList("***hidden-guy")))});
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Iterator props = v.iterators().propertyIterator(new String[0]);
        VertexProperty v1 = (VertexProperty)props.next();
        Assert.assertEquals((Object)"Y", (Object)v1.value());
        Assert.assertEquals((Object)"not-hidden-guy", (Object)v1.key());
        Assert.assertFalse((boolean)props.hasNext());
        Iterator values = v.iterators().valueIterator(new String[0]);
        Assert.assertEquals((Object)"Y", values.next());
        Assert.assertFalse((boolean)values.hasNext());
    }

    @Test
    public void shouldAccessHiddenProperties() {
        StrategyGraph sg = this.g.strategy(new GraphStrategy[]{new ComputerDataStrategy(new HashSet<String>(Arrays.asList("***hidden-guy")))});
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Iterator props = v.iterators().propertyIterator(new String[]{"***hidden-guy"});
        VertexProperty v1 = (VertexProperty)props.next();
        Assert.assertEquals((Object)"X", (Object)v1.value());
        Assert.assertEquals((Object)"***hidden-guy", (Object)v1.key());
        Assert.assertFalse((boolean)props.hasNext());
        Iterator values = v.iterators().valueIterator(new String[]{"***hidden-guy"});
        Assert.assertEquals((Object)"X", values.next());
        Assert.assertFalse((boolean)values.hasNext());
    }

    @Test
    public void shouldHideHiddenKeys() {
        StrategyGraph sg = this.g.strategy(new GraphStrategy[]{new ComputerDataStrategy(new HashSet<String>(Arrays.asList("***hidden-guy")))});
        Vertex v = sg.addVertex(new Object[]{"***hidden-guy", "X", "not-hidden-guy", "Y"});
        Set keys = v.keys();
        Assert.assertTrue((boolean)keys.contains("not-hidden-guy"));
        Assert.assertFalse((boolean)keys.contains("***hidden-guy"));
    }
}

