/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.filter;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Vertex;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public abstract class FilterTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_V_filterXfalseX();

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXtrueX();

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXlang_eq_javaX();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_filterXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_filterXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX();

    public abstract Traversal<Edge, Edge> get_g_E_filterXfalseX();

    public abstract Traversal<Edge, Edge> get_g_E_filterXtrueX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXfalseX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXfalseX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXtrueX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXtrueX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> vertices = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            vertices.add(traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
        Assert.assertEquals((long)6L, (long)vertices.size());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXlang_eq_javaX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXlang_eq_javaX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("ripple") || vertex.value("name").equals("lop") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)counter);
        Assert.assertEquals((long)2L, (long)vertices.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_filterXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_filterXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_filterXage_gt_30X(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)32, (Object)((Vertex)traversal.next()).value("age"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_filterXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_filterXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)32, (Object)((Vertex)traversal.next()).value("age"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_filterXname_startsWith_m_OR_name_startsWith_pX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        while (traversal.hasNext()) {
            ++counter;
            Vertex vertex = (Vertex)traversal.next();
            vertices.add(vertex);
            Assert.assertTrue((vertex.value("name").equals("marko") || vertex.value("name").equals("peter") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)counter, (long)2L);
        Assert.assertEquals((long)vertices.size(), (long)2L);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_filterXfalseX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_filterXfalseX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_filterXtrueX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_filterXtrueX();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> edges = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            edges.add(traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
        Assert.assertEquals((long)6L, (long)edges.size());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class ComputerTest
    extends FilterTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXfalseX() {
            return this.g.V(new Object[0]).filter(v -> false).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXtrueX() {
            return this.g.V(new Object[0]).filter(v -> true).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXlang_eq_javaX() {
            return this.g.V(new Object[0]).filter(v -> ((String)((Vertex)v.get()).property("lang").orElse((Object)"none")).equals("java")).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXfalseX() {
            return this.g.E(new Object[0]).filter(v -> false).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXtrueX() {
            return this.g.E(new Object[0]).filter(v -> true).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX() {
            return this.g.V(new Object[0]).filter(v -> {
                String name = (String)((Vertex)v.get()).value("name");
                return name.startsWith("m") || name.startsWith("p");
            }).submit(this.g.compute(new Class[0]));
        }
    }

    public static class StandardTest
    extends FilterTest {
        public StandardTest() {
            this.requiresGraphComputer = false;
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXfalseX() {
            return this.g.V(new Object[0]).filter(v -> false);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXtrueX() {
            return this.g.V(new Object[0]).filter(v -> true);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXlang_eq_javaX() {
            return this.g.V(new Object[0]).filter(v -> ((String)((Vertex)v.get()).property("lang").orElse((Object)"none")).equals("java"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_filterXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).filter(v -> (Integer)((Vertex)v.get()).property("age").orElse((Object)0) > 30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_filterXname_startsWith_m_OR_name_startsWith_pX() {
            return this.g.V(new Object[0]).filter(v -> {
                String name = (String)((Vertex)v.get()).value("name");
                return name.startsWith("m") || name.startsWith("p");
            });
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXfalseX() {
            return this.g.E(new Object[0]).filter(e -> false);
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_filterXtrueX() {
            return this.g.E(new Object[0]).filter(e -> true);
        }
    }
}

