/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.filter;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.structure.Compare;
import com.tinkerpop.gremlin.structure.Contains;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class HasTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object var1, String var2);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_markoX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_blahX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXblahX();

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object var1);

    public abstract Traversal<Vertex, Vertex> get_g_VX1X_out_hasXid_2X(Object var1, Object var2);

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X();

    public abstract Traversal<Edge, Edge> get_g_EX7X_hasXlabelXknowsX(Object var1);

    public abstract Traversal<Edge, Edge> get_g_E_hasXlabelXknowsX();

    public abstract Traversal<Edge, Edge> get_g_E_hasXlabelXuses_traversesX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXlabelXperson_software_blahX();

    public abstract Traversal<Vertex, Vertex> get_g_V_hasXname_equalspredicate_markoX();

    public abstract Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXkeyX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "name");
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXkeyX(this.convertToVertexId("marko"), "circumference");
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXname_markoX(this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_markoX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_blahX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXage_gt_30X();
        this.printTraversalForm(traversal);
        List list = StreamFactory.stream(traversal).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)list.size());
        for (Element v : list) {
            Assert.assertTrue(((Integer)v.value("age") > 30 ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_hasXage_gt_30X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = this.get_g_VX1X_hasXage_gt_30X(this.convertToVertexId("josh"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_out_hasXid_2X() {
        Traversal<Vertex, Vertex> traversal = this.get_g_VX1X_out_hasXid_2X(this.convertToVertexId("marko"), this.convertToVertexId("vadas"));
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)((Vertex)traversal.next()).id());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXblahX() {
        Assume.assumeTrue((boolean)this.graphMeetsTestRequirements());
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXblahX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX7X_hasXlabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_EX7X_hasXlabelXknowsX(this.convertToEdgeId("marko", "knows", "vadas"));
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_E_hasXlabelXknowsX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasXlabelXknowsX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Assert.assertEquals((Object)"knows", (Object)((Edge)traversal.next()).label());
        }
        Assert.assertEquals((long)2L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_E_hasXlabelXuses_traversesX() {
        Traversal<Edge, Edge> traversal = this.get_g_E_hasXlabelXuses_traversesX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Edge)traversal.next()).label();
            Assert.assertTrue((label.equals("uses") || label.equals("traverses") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)9L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void g_V_hasXlabelXperson_software_blahX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXlabelXperson_software_blahX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String label = ((Vertex)traversal.next()).label();
            Assert.assertTrue((label.equals("software") || label.equals("person") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXname_equalspredicate_markoX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_hasXname_equalspredicate_markoX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"marko", (Object)((Vertex)traversal.next()).value("name"));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasXperson_name_markoX_age() {
        Traversal<Vertex, Integer> traversal = this.get_g_V_hasXperson_name_markoX_age();
        this.printTraversalForm(traversal);
        Assert.assertEquals((long)29L, (long)((Integer)traversal.next()).intValue());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class ComputerTest
    extends HasTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object v1Id, String key) {
            return this.g.V(new Object[]{v1Id}).has(key).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("name", (Object)"marko").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_markoX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_blahX() {
            return this.g.V(new Object[0]).has("name", (Object)"blah").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXblahX() {
            return this.g.V(new Object[0]).has("blah").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("age", (BiPredicate)Compare.gt, (Object)30).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasXid_2X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).has(T.id, v2Id).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X() {
            return this.g.V(new Object[0]).has("age", (BiPredicate)Compare.gt, (Object)30).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Edge, Edge> get_g_EX7X_hasXlabelXknowsX(Object e7Id) {
            return this.g.E(new Object[]{e7Id}).has(T.label, (Object)"knows").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasXlabelXknowsX() {
            return this.g.E(new Object[0]).has(T.label, (Object)"knows").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasXlabelXuses_traversesX() {
            return this.g.E(new Object[0]).has(T.label, (BiPredicate)Contains.within, Arrays.asList("uses", "traverses")).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXlabelXperson_software_blahX() {
            return this.g.V(new Object[0]).has(T.label, (BiPredicate)Contains.within, Arrays.asList("person", "software", "blah"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_equalspredicate_markoX() {
            return this.g.V(new Object[0]).has("name", (a, b) -> a.equals(b), (Object)"marko").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age() {
            return this.g.V(new Object[0]).has("person", "name", (Object)"marko").values(new String[]{"age"}).submit(this.g.compute(new Class[0]));
        }
    }

    public static class StandardTest
    extends HasTest {
        public StandardTest() {
            this.requiresGraphComputer = false;
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXkeyX(Object v1Id, String key) {
            return this.g.V(new Object[]{v1Id}).has(key);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXname_markoX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_markoX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_blahX() {
            return this.g.V(new Object[0]).has("name", (Object)"blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXblahX() {
            return this.g.V(new Object[0]).has("blah");
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_hasXage_gt_30X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).has("age", (BiPredicate)Compare.gt, (Object)30);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_VX1X_out_hasXid_2X(Object v1Id, Object v2Id) {
            return this.g.V(new Object[]{v1Id}).out(new String[0]).has(T.id, v2Id);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXage_gt_30X() {
            return this.g.V(new Object[0]).has("age", (BiPredicate)Compare.gt, (Object)30);
        }

        @Override
        public Traversal<Edge, Edge> get_g_EX7X_hasXlabelXknowsX(Object e7Id) {
            return this.g.E(new Object[]{e7Id}).has(T.label, (Object)"knows");
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasXlabelXknowsX() {
            return this.g.E(new Object[0]).has(T.label, (Object)"knows");
        }

        @Override
        public Traversal<Edge, Edge> get_g_E_hasXlabelXuses_traversesX() {
            return this.g.E(new Object[0]).has(T.label, (BiPredicate)Contains.within, Arrays.asList("uses", "traverses"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXlabelXperson_software_blahX() {
            return this.g.V(new Object[0]).has(T.label, (BiPredicate)Contains.within, Arrays.asList("person", "software", "blah"));
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_hasXname_equalspredicate_markoX() {
            return this.g.V(new Object[0]).has("name", (a, b) -> a.equals(b), (Object)"marko");
        }

        @Override
        public Traversal<Vertex, Integer> get_g_V_hasXperson_name_markoX_age() {
            return this.g.V(new Object[0]).has("person", "name", (Object)"marko").values(new String[]{"age"});
        }
    }
}

