/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.map;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.structure.Order;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public abstract class OrderTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> get_g_V_name_order();

    public abstract Traversal<Vertex, String> get_g_V_name_order_byXabX();

    public abstract Traversal<Vertex, String> get_g_V_name_order_byXa1_b1X_byXb2_a2X();

    public abstract Traversal<Vertex, String> get_g_V_order_byXname_incrX_name();

    public abstract Traversal<Vertex, String> get_g_V_order_byXnameX_name();

    public abstract Traversal<Vertex, Double> get_g_V_outE_order_byXweight_decrX_weight();

    public abstract Traversal<Vertex, String> get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_name_order() {
        Traversal<Vertex, String> traversal = this.get_g_V_name_order();
        this.printTraversalForm(traversal);
        List names = traversal.toList();
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"josh", names.get(0));
        Assert.assertEquals((Object)"lop", names.get(1));
        Assert.assertEquals((Object)"marko", names.get(2));
        Assert.assertEquals((Object)"peter", names.get(3));
        Assert.assertEquals((Object)"ripple", names.get(4));
        Assert.assertEquals((Object)"vadas", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_name_orderXabX() {
        Traversal<Vertex, String> traversal = this.get_g_V_name_order_byXabX();
        this.printTraversalForm(traversal);
        List names = StreamFactory.stream(traversal).collect(Collectors.toList());
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"josh", names.get(5));
        Assert.assertEquals((Object)"lop", names.get(4));
        Assert.assertEquals((Object)"marko", names.get(3));
        Assert.assertEquals((Object)"peter", names.get(2));
        Assert.assertEquals((Object)"ripple", names.get(1));
        Assert.assertEquals((Object)"vadas", names.get(0));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_name_orderXa1_b1__a2_b2X() {
        Traversal<Vertex, String> traversal = this.get_g_V_name_order_byXa1_b1X_byXb2_a2X();
        this.printTraversalForm(traversal);
        List names = StreamFactory.stream(traversal).collect(Collectors.toList());
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"marko", names.get(0));
        Assert.assertEquals((Object)"vadas", names.get(1));
        Assert.assertEquals((Object)"peter", names.get(2));
        Assert.assertEquals((Object)"ripple", names.get(3));
        Assert.assertEquals((Object)"josh", names.get(4));
        Assert.assertEquals((Object)"lop", names.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_orderByXname_incrX_name() {
        Arrays.asList(this.get_g_V_order_byXname_incrX_name(), this.get_g_V_order_byXnameX_name()).forEach(traversal -> {
            this.printTraversalForm((Traversal)traversal);
            List names = StreamFactory.stream((Iterator)traversal).collect(Collectors.toList());
            Assert.assertEquals((long)names.size(), (long)6L);
            Assert.assertEquals((Object)"josh", names.get(0));
            Assert.assertEquals((Object)"lop", names.get(1));
            Assert.assertEquals((Object)"marko", names.get(2));
            Assert.assertEquals((Object)"peter", names.get(3));
            Assert.assertEquals((Object)"ripple", names.get(4));
            Assert.assertEquals((Object)"vadas", names.get(5));
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_outE_orderXweight_decrX_weight() {
        Traversal<Vertex, Double> traversal = this.get_g_V_outE_order_byXweight_decrX_weight();
        this.printTraversalForm(traversal);
        List weights = StreamFactory.stream(traversal).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)weights.size());
        Assert.assertEquals((Object)1.0, weights.get(0));
        Assert.assertEquals((Object)1.0, weights.get(1));
        Assert.assertEquals((Object)0.5, weights.get(2));
        Assert.assertEquals((Object)0.4, weights.get(3));
        Assert.assertEquals((Object)0.4, weights.get(4));
        Assert.assertEquals((Object)0.2, weights.get(5));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_orderByXname_decr__a2_b2X_name() {
        Traversal<Vertex, String> traversal = this.get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name();
        this.printTraversalForm(traversal);
        List names = StreamFactory.stream(traversal).collect(Collectors.toList());
        Assert.assertEquals((long)names.size(), (long)6L);
        Assert.assertEquals((Object)"marko", names.get(0));
        Assert.assertEquals((Object)"vadas", names.get(1));
        Assert.assertEquals((Object)"peter", names.get(2));
        Assert.assertEquals((Object)"ripple", names.get(3));
        Assert.assertEquals((Object)"josh", names.get(4));
        Assert.assertEquals((Object)"lop", names.get(5));
    }

    public static class ComputerTest
    extends OrderTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order_byXabX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().by((a, b) -> b.compareTo((String)a)).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order_byXa1_b1X_byXb2_a2X() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().by((a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by((a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3))).submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_incrX_name() {
            return this.g.V(new Object[0]).order().by("name", (Comparator)Order.incr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXnameX_name() {
            return this.g.V(new Object[0]).order().by("name", (Comparator)Order.incr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_outE_order_byXweight_decrX_weight() {
            return this.g.V(new Object[0]).outE(new String[0]).order().by("weight", (Comparator)Order.decr).values(new String[]{"weight"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name() {
            return this.g.V(new Object[0]).order().by("name", (a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by("name", (a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3))).values(new String[]{"name"});
        }
    }

    public static class StandardTest
    extends OrderTest {
        @Override
        public Traversal<Vertex, String> get_g_V_name_order() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order();
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order_byXabX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().by((a, b) -> b.compareTo((String)a));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_name_order_byXa1_b1X_byXb2_a2X() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).order().by((a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by((a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3)));
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_incrX_name() {
            return this.g.V(new Object[0]).order().by("name", (Comparator)Order.incr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXnameX_name() {
            return this.g.V(new Object[0]).order().by("name", (Comparator)Order.incr).values(new String[]{"name"});
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_outE_order_byXweight_decrX_weight() {
            return this.g.V(new Object[0]).outE(new String[0]).order().by("weight", (Comparator)Order.decr).values(new String[]{"weight"});
        }

        @Override
        public Traversal<Vertex, String> get_g_V_order_byXname_a1_b1X_byXname_b2_a2X_name() {
            return this.g.V(new Object[0]).order().by("name", (a, b) -> a.substring(1, 2).compareTo(b.substring(1, 2))).by("name", (a, b) -> b.substring(2, 3).compareTo(a.substring(2, 3))).values(new String[]{"name"});
        }
    }
}

