/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.map;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Vertex;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class UnfoldTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Edge> get_g_V_mapXoutEX_unfold();

    public abstract Traversal<Vertex, String> get_V_valueMap_unfold_mapXkeyX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_mapXoutEX_unfold() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_mapXoutEX_unfold();
        this.printTraversalForm(traversal);
        int counter = 0;
        HashSet<Object> edges = new HashSet<Object>();
        while (traversal.hasNext()) {
            ++counter;
            edges.add(traversal.next());
        }
        Assert.assertEquals((long)6L, (long)counter);
        Assert.assertEquals((long)6L, (long)edges.size());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_valueMap_unfold_mapXkeyX() {
        Traversal<Vertex, String> traversal = this.get_V_valueMap_unfold_mapXkeyX();
        this.printTraversalForm(traversal);
        int counter = 0;
        int ageCounter = 0;
        int nameCounter = 0;
        int langCounter = 0;
        while (traversal.hasNext()) {
            ++counter;
            String key = (String)traversal.next();
            if (key.equals("name")) {
                ++nameCounter;
                continue;
            }
            if (key.equals("age")) {
                ++ageCounter;
                continue;
            }
            if (key.equals("lang")) {
                ++langCounter;
                continue;
            }
            Assert.fail((String)("The provided key is not known: " + key));
        }
        Assert.assertEquals((long)12L, (long)counter);
        Assert.assertEquals((long)4L, (long)ageCounter);
        Assert.assertEquals((long)2L, (long)langCounter);
        Assert.assertEquals((long)6L, (long)nameCounter);
        Assert.assertEquals((long)counter, (long)(ageCounter + langCounter + nameCounter));
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class ComputerTest
    extends UnfoldTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_mapXoutEX_unfold() {
            return this.g.V(new Object[0]).map(v -> ((Vertex)v.get()).outE(new String[0])).unfold().submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, String> get_V_valueMap_unfold_mapXkeyX() {
            return this.g.V(new Object[0]).valueMap(new String[0]).unfold().map(m -> (String)((Map.Entry)m.get()).getKey()).submit(this.g.compute(new Class[0]));
        }
    }

    public static class StandardTest
    extends UnfoldTest {
        @Override
        public Traversal<Vertex, Edge> get_g_V_mapXoutEX_unfold() {
            return this.g.V(new Object[0]).map(v -> ((Vertex)v.get()).outE(new String[0])).unfold();
        }

        @Override
        public Traversal<Vertex, String> get_V_valueMap_unfold_mapXkeyX() {
            return this.g.V(new Object[0]).valueMap(new String[0]).unfold().map(m -> (String)((Map.Entry)m.get()).getKey());
        }
    }
}

