/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.sideEffect;

import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import com.tinkerpop.gremlin.process.Path;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.process.util.MapHelper;
import com.tinkerpop.gremlin.structure.Vertex;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class AggregateTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, List<String>> get_g_V_name_aggregate();

    public abstract Traversal<Vertex, List<String>> get_g_V_aggregate_byXnameX();

    public abstract Traversal<Vertex, Path> get_g_V_out_aggregateXaX_path();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_valueXnameX_aggregate() {
        Traversal<Vertex, List<String>> traversal = this.get_g_V_name_aggregate();
        this.printTraversalForm(traversal);
        Collection names = (Collection)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        this.checkListOfNames(names);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_aggregate_byXnameX() {
        Traversal<Vertex, List<String>> traversal = this.get_g_V_aggregate_byXnameX();
        this.printTraversalForm(traversal);
        Collection names = (Collection)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        this.checkListOfNames(names);
    }

    private void checkListOfNames(Collection<String> names) {
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("peter"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("vadas"));
        Assert.assertTrue((boolean)names.contains("ripple"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_aggregateXaX_path() {
        Traversal<Vertex, Path> traversal = this.get_g_V_out_aggregateXaX_path();
        this.printTraversalForm(traversal);
        int count = 0;
        HashMap firstStepCounts = new HashMap();
        HashMap secondStepCounts = new HashMap();
        while (traversal.hasNext()) {
            ++count;
            Path path = (Path)traversal.next();
            String first = path.get(0).toString();
            String second = path.get(1).toString();
            Assert.assertThat((Object)first, (Matcher)CoreMatchers.not((Object)second));
            MapHelper.incr(firstStepCounts, (Object)first, (Long)1L);
            MapHelper.incr(secondStepCounts, (Object)second, (Long)1L);
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertEquals((long)3L, (long)firstStepCounts.size());
        Assert.assertEquals((long)4L, (long)secondStepCounts.size());
        Assert.assertTrue((boolean)firstStepCounts.values().contains(3L));
        Assert.assertTrue((boolean)firstStepCounts.values().contains(2L));
        Assert.assertTrue((boolean)firstStepCounts.values().contains(1L));
        Assert.assertTrue((boolean)secondStepCounts.values().contains(3L));
        Assert.assertTrue((boolean)secondStepCounts.values().contains(1L));
    }

    public static class ComputerTest
    extends AggregateTest {
        public ComputerTest() {
            this.requiresGraphComputer = true;
        }

        @Override
        public Traversal<Vertex, List<String>> get_g_V_name_aggregate() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).aggregate().submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, List<String>> get_g_V_aggregate_byXnameX() {
            return this.g.V(new Object[0]).aggregate().by("name").submit(this.g.compute(new Class[0]));
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_out_aggregateXaX_path() {
            return this.g.V(new Object[0]).out(new String[0]).aggregate("a").path().submit(this.g.compute(new Class[0]));
        }
    }

    public static class StandardTest
    extends AggregateTest {
        @Override
        public Traversal<Vertex, List<String>> get_g_V_name_aggregate() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).aggregate();
        }

        @Override
        public Traversal<Vertex, List<String>> get_g_V_aggregate_byXnameX() {
            return this.g.V(new Object[0]).aggregate().by("name");
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_out_aggregateXaX_path() {
            return this.g.V(new Object[0]).out(new String[0]).aggregate("a").path();
        }
    }
}

