/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.process.graph.step.sideEffect;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.Traversal;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;

public abstract class SubgraphTest
extends AbstractGremlinTest {
    public abstract Traversal<Vertex, Graph> get_g_VX1X_outE_subgraphXknowsX_name_capXsgX(Object var1, Graph var2);

    public abstract Traversal<Vertex, String> get_g_V_inE_subgraphXcreatedX_name(Graph var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void g_VX1X_outE_subgraphXknowsX_name_capXsgX() throws Exception {
        Configuration config = this.graphProvider.newGraphConfiguration("subgraph", this.getClass(), this.name.getMethodName());
        this.graphProvider.clear(config);
        Graph subgraph = this.graphProvider.openTestGraph(config);
        Traversal<Vertex, Graph> traversal = this.get_g_VX1X_outE_subgraphXknowsX_name_capXsgX(this.convertToVertexId("marko"), subgraph);
        this.printTraversalForm(traversal);
        subgraph = (Graph)traversal.next();
        SubgraphTest.assertVertexEdgeCounts(3, 2).accept(subgraph);
        subgraph.E(new Object[0]).forEachRemaining(e -> {
            Assert.assertEquals((Object)"knows", (Object)e.label());
            Assert.assertEquals((Object)"marko", (Object)e.outV().values(new String[]{"name"}).next());
            Assert.assertEquals((Object)new Integer(29), (Object)e.outV().values(new String[]{"age"}).next());
            Assert.assertEquals((Object)"person", (Object)e.outV().label().next());
            String name = (String)e.inV().values(new String[]{"name"}).next();
            if (name.equals("vadas")) {
                Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-4);
            } else if (name.equals("josh")) {
                Assert.assertEquals((double)1.0, (double)((Double)e.value("weight")), (double)1.0E-4);
            } else {
                Assert.fail((String)"There's a vertex present that should not be in the subgraph");
            }
        });
        this.graphProvider.clear(subgraph, config);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void g_V_inE_subgraphXcreatedX_name() throws Exception {
        Configuration config = this.graphProvider.newGraphConfiguration("subgraph", this.getClass(), this.name.getMethodName());
        this.graphProvider.clear(config);
        Graph subgraph = this.graphProvider.openTestGraph(config);
        Traversal<Vertex, String> traversal = this.get_g_V_inE_subgraphXcreatedX_name(subgraph);
        this.printTraversalForm(traversal);
        traversal.iterate();
        SubgraphTest.assertVertexEdgeCounts(5, 4).accept((Graph)traversal.asAdmin().getSideEffects().get("sg"));
        this.graphProvider.clear(subgraph, config);
    }

    public static class StandardTest
    extends SubgraphTest {
        @Override
        public Traversal<Vertex, Graph> get_g_VX1X_outE_subgraphXknowsX_name_capXsgX(Object v1Id, Graph subgraph) {
            return this.g.V(new Object[]{v1Id}).withSideEffect("sg", () -> subgraph).outE(new String[0]).subgraph("sg", e -> e.label().equals("knows")).values(new String[]{"name"}).cap("sg");
        }

        @Override
        public Traversal<Vertex, String> get_g_V_inE_subgraphXcreatedX_name(Graph subgraph) {
            return this.g.V(new Object[0]).withSideEffect("sg", () -> subgraph).inE(new String[0]).subgraph("sg", e -> e.label().equals("created")).values(new String[]{"name"});
        }
    }
}

