/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.GraphManager;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.util.batch.BatchGraph;
import com.tinkerpop.gremlin.structure.util.batch.Exists;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.junit.Test;

public class BatchTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifier() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).bufferSize(1L).create();
        Object id1 = GraphManager.get().convertId("1");
        Object id2 = GraphManager.get().convertId("2");
        graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifier() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierThrowOnExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.THROW, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.get().convertId("1");
        graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        try {
            graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierThrowOnExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.THROW, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        try {
            graph.addVertex(new Object[]{T.id, "marko", "age", 34});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierOverwriteSingleExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE_SINGLE, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.get().convertId("1");
        Object id2 = GraphManager.get().convertId("2");
        graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)34, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierOverwriteSingleExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE_SINGLE, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)34, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadVerticesIncrementallyWithSuppliedIdentifierOverwriteExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE, (BiConsumer)Exists.IGNORE).bufferSize(1L).create();
        Object id1 = GraphManager.get().convertId("1");
        Object id2 = GraphManager.get().convertId("2");
        graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, id2, "name", "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, id1, "name", "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)2L, (long)((Long)vMarko.properties(new String[]{"age"}).count().next()).intValue());
        Assert.assertEquals((long)2L, (long)((Long)vMarko.properties(new String[]{"name"}).count().next()).intValue());
        Assert.assertTrue((boolean)((List)((Map)vMarko.valueMap(new String[0]).next()).get("age")).contains(29));
        Assert.assertTrue((boolean)((List)((Map)vMarko.valueMap(new String[0]).next()).get("age")).contains(34));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")})
    public void shouldLoadVerticesIncrementallyWithNamedIdentifierAddMultiPropertyExistingVertex() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.OVERWRITE, (BiConsumer)Exists.IGNORE).vertexIdKey("name").bufferSize(1L).create();
        graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 34});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((long)2L, (long)((Long)vMarko.properties(new String[]{"age"}).count().next()).intValue());
        Assert.assertEquals((long)2L, (long)((Long)vMarko.properties(new String[]{"name"}).count().next()).intValue());
        Assert.assertTrue((boolean)((List)((Map)vMarko.valueMap(new String[0]).next()).get("age")).contains(29));
        Assert.assertTrue((boolean)((List)((Map)vMarko.valueMap(new String[0]).next()).get("age")).contains(34));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifier() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.get().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifier() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierOverwriteSingleExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE_SINGLE).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.get().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierOverwriteSingleExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE_SINGLE).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierOverwriteExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.get().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierOverwriteExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.OVERWRITE).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(0L), (Object)vStephen.outE(new String[]{"knows"}).has("uid", (Object)"abcde").has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")})
    public void shouldLoadEdgesIncrementallyWithSuppliedIdentifierThrowOnExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.THROW).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        Object id1 = GraphManager.get().convertId("1");
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, id1});
        try {
            v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, id1});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierThrowOnExistingEdge() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true, (BiConsumer)Exists.IGNORE, (BiConsumer)Exists.THROW).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0, T.id, "abcde"});
        try {
            v1.addEdge("knows", v2, new Object[]{"weight", 0.5, T.id, "abcde"});
            Assert.fail((String)"Should have thrown an error because the vertex already exists");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IllegalStateException));
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyNoIdSpecified() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).vertexIdKey("name").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")})
    public void shouldLoadEdgesIncrementallyWithNamedIdentifierAndNoIdSpecified() {
        BatchGraph graph = BatchGraph.build((Graph)this.g).incrementalLoading(true).vertexIdKey("name").edgeIdKey("uid").bufferSize(1L).create();
        Vertex v2 = graph.addVertex(new Object[]{T.id, "marko", "age", 29});
        Vertex v1 = graph.addVertex(new Object[]{T.id, "stephen", "age", 37});
        v1.addEdge("knows", v2, new Object[]{"weight", 1.0});
        v1.addEdge("knows", v2, new Object[]{"weight", 0.5});
        this.tryCommit((Graph)graph);
        Vertex vStephen = (Vertex)this.g.V(new Object[0]).has("name", (Object)"stephen").next();
        Assert.assertEquals((Object)37, (Object)vStephen.property("age").value());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)1.0).inV().has("name", (Object)"marko").count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)vStephen.outE(new String[]{"knows"}).has("weight", (Object)0.5).inV().has("name", (Object)"marko").count().next());
        Vertex vMarko = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Assert.assertEquals((Object)29, (Object)vMarko.property("age").value());
    }
}

