/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.util.GraphFactory;
import com.tinkerpop.gremlin.util.StreamFactory;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class GraphConstructionTest
extends AbstractGremlinTest {
    @Test
    public void shouldOpenGraphThroughGraphFactoryViaApacheConfig() throws Exception {
        Graph expectedGraph = this.g;
        Configuration c = this.graphProvider.newGraphConfiguration("temp1", this.getClass(), this.name.getMethodName());
        Graph createdGraph = GraphFactory.open((Configuration)c);
        Assert.assertNotNull((Object)createdGraph);
        Assert.assertEquals(expectedGraph.getClass(), createdGraph.getClass());
        this.graphProvider.clear(createdGraph, c);
    }

    @Test
    public void shouldConstructAnEmptyGraph() {
        GraphConstructionTest.assertVertexEdgeCounts(0, 0).accept(this.g);
    }

    @Test
    public void shouldMaintainOriginalConfigurationObjectGivenToFactory() {
        Configuration originalConfig = this.graphProvider.newGraphConfiguration("temp2", this.getClass(), this.name.getMethodName());
        Graph createdGraph = GraphFactory.open((Configuration)originalConfig);
        Configuration configInGraph = createdGraph.configuration();
        AtomicInteger keyCount = new AtomicInteger(0);
        originalConfig.getKeys().forEachRemaining(k -> {
            Assert.assertTrue((boolean)configInGraph.containsKey(k));
            keyCount.incrementAndGet();
        });
        Assert.assertTrue((keyCount.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)keyCount.get(), (long)StreamFactory.stream((Iterator)configInGraph.getKeys()).count());
    }
}

