/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.ExceptionCoverage;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.GraphManager;
import com.tinkerpop.gremlin.GraphProvider;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.IoTest;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.StreamFactory;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"vertexWithIdAlreadyExists", "elementNotFound"})
public class GraphTest
extends AbstractGremlinTest {
    @Test
    public void shouldImplementAndExposeFeatures() {
        Graph.Features features = this.g.features();
        Assert.assertNotNull((Object)features);
        AtomicInteger counter = new AtomicInteger(0);
        List<Method> methods = Arrays.asList(features.getClass().getMethods()).stream().filter(m -> Graph.Features.FeatureSet.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
        methods.forEach(m -> {
            try {
                Assert.assertNotNull((Object)m.invoke((Object)features, new Object[0]));
                counter.incrementAndGet();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)"Exception while dynamically checking compliance on Feature implementation");
            }
        });
        Assert.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)methods.size(), (long)counter.get());
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindVertexByIdThatIsNonExistentViaTraversal() {
        try {
            this.g.V(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.V(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Vertex.class, (Object)10000L).getClass()));
        }
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindVertexByIdThatIsNonExistentViaIterator() {
        try {
            this.g.iterators().vertexIterator(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.V(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Vertex.class, (Object)10000L).getClass()));
        }
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindEdgeByIdThatIsNonExistentViaTraversal() {
        try {
            this.g.E(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.E(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Edge.class, (Object)10000L).getClass()));
        }
    }

    @Test
    public void shouldHaveExceptionConsistencyWhenFindEdgeByIdThatIsNonExistentViaIterator() {
        try {
            this.g.iterators().edgeIterator(new Object[]{10000L}).next();
            Assert.fail((String)"Call to g.E(10000l) should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.elementNotFound(Edge.class, (Object)10000L).getClass()));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")})
    public void shouldHaveExceptionConsistencyWhenAssigningSameIdOnVertex() {
        Object o = GraphManager.get().convertId("1");
        this.g.addVertex(new Object[]{T.id, o});
        try {
            this.g.addVertex(new Object[]{T.id, o});
            Assert.fail((String)"Assigning the same ID to an Element should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)CoreMatchers.instanceOf(Graph.Exceptions.vertexWithIdAlreadyExists((Object)0).getClass()));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="NumericIds")})
    public void shouldAddVertexWithUserSuppliedNumericId() {
        this.g.addVertex(new Object[]{T.id, 1000L});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{1000L}).next();
            Assert.assertEquals((Object)1000L, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="StringIds")})
    public void shouldAddVertexWithUserSuppliedStringId() {
        this.g.addVertex(new Object[]{T.id, "1000"});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{"1000"}).next();
            Assert.assertEquals((Object)"1000", (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UuidIds")})
    public void shouldAddVertexWithUserSuppliedUuidId() {
        UUID uuid = UUID.randomUUID();
        this.g.addVertex(new Object[]{T.id, uuid});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AnyIds")})
    public void shouldAddVertexWithUserSuppliedAnyId() {
        UUID uuid = UUID.randomUUID();
        this.g.addVertex(new Object[]{T.id, uuid});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{uuid}).next();
            Assert.assertEquals((Object)uuid, (Object)v.id());
        });
        this.g.addVertex(new Object[]{T.id, uuid.toString()});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{uuid.toString()}).next();
            Assert.assertEquals((Object)uuid.toString(), (Object)v.id());
        });
        IoTest.CustomId customId = new IoTest.CustomId("test", uuid);
        this.g.addVertex(new Object[]{T.id, customId});
        this.tryCommit(this.g, graph -> {
            Vertex v = (Vertex)this.g.iterators().vertexIterator(new Object[]{customId}).next();
            Assert.assertEquals((Object)customId, (Object)v.id());
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties", supported=false)})
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfNoMultiProperty() {
        Vertex v = this.g.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.g, graph -> {
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"test"})));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.iterators().valueIterator(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")})
    public void shouldOverwriteEarlierKeyValuesWithLaterKeyValuesOnAddVertexIfMultiProperty() {
        Vertex v = this.g.addVertex(new Object[]{"test", "A", "test", "B", "test", "C"});
        this.tryCommit(this.g, graph -> {
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"test"})));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.iterators().valueIterator(new String[]{"test"})).anyMatch(t -> t.equals("A")));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.iterators().valueIterator(new String[]{"test"})).anyMatch(t -> t.equals("B")));
            Assert.assertTrue((boolean)StreamFactory.stream((Iterator)v.iterators().valueIterator(new String[]{"test"})).anyMatch(t -> t.equals("C")));
        });
    }

    @Test
    public void shouldHaveStandardStringRepresentation() throws Exception {
        Assert.assertTrue((boolean)this.g.toString().matches(".*\\[.*\\]"));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")})
    public void shouldRemoveEdges() {
        int vertexCount = 100;
        int edgeCount = 200;
        ArrayList vertices = new ArrayList();
        ArrayList edges = new ArrayList();
        Random random = new Random();
        IntStream.range(0, 100).forEach(i -> vertices.add(this.g.addVertex(new Object[0])));
        this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(100, 0));
        IntStream.range(0, 200).forEach(i -> {
            boolean created = false;
            while (!created) {
                Vertex b;
                Vertex a = (Vertex)vertices.get(random.nextInt(vertices.size()));
                if (a == (b = (Vertex)vertices.get(random.nextInt(vertices.size())))) continue;
                edges.add(a.addEdge(GraphManager.get().convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
                created = true;
            }
        });
        this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(100, 200));
        int counter = 0;
        for (Edge e : edges) {
            e.remove();
            int currentCounter = ++counter;
            this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(100, 200 - currentCounter));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldRemoveVertices() {
        int vertexCount = 500;
        ArrayList vertices = new ArrayList();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        IntStream.range(0, 500).forEach(i -> vertices.add(this.g.addVertex(new Object[0])));
        this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(500, 0));
        for (int i2 = 0; i2 < 500; i2 += 2) {
            Vertex a = (Vertex)vertices.get(i2);
            Vertex b = (Vertex)vertices.get(i2 + 1);
            edges.add(a.addEdge(GraphManager.get().convertLabel("a" + UUID.randomUUID()), b, new Object[0]));
        }
        this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(500, 250));
        int counter = 0;
        for (Vertex v : vertices) {
            v.remove();
            if ((++counter + 1) % 2 != 0) continue;
            int currentCounter = counter;
            this.tryCommit(this.g, GraphTest.assertVertexEdgeCounts(500 - currentCounter, edges.size() - (currentCounter + 1) / 2));
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldEvaluateConnectivityPatterns() {
        Vertex d;
        Vertex c;
        Vertex b;
        Vertex a;
        GraphProvider graphProvider = GraphManager.get();
        Graph graph = this.g;
        if (graph.features().vertex().supportsUserSuppliedIds()) {
            a = graph.addVertex(new Object[]{T.id, graphProvider.convertId("1")});
            b = graph.addVertex(new Object[]{T.id, graphProvider.convertId("2")});
            c = graph.addVertex(new Object[]{T.id, graphProvider.convertId("3")});
            d = graph.addVertex(new Object[]{T.id, graphProvider.convertId("4")});
        } else {
            a = graph.addVertex(new Object[0]);
            b = graph.addVertex(new Object[0]);
            c = graph.addVertex(new Object[0]);
            d = graph.addVertex(new Object[0]);
        }
        this.tryCommit(graph, GraphTest.assertVertexEdgeCounts(4, 0));
        Edge e = a.addEdge(graphProvider.convertLabel("knows"), b, new Object[0]);
        Edge f = b.addEdge(graphProvider.convertLabel("knows"), c, new Object[0]);
        Edge g = c.addEdge(graphProvider.convertLabel("knows"), d, new Object[0]);
        Edge h = d.addEdge(graphProvider.convertLabel("knows"), a, new Object[0]);
        this.tryCommit(graph, GraphTest.assertVertexEdgeCounts(4, 4));
        graph.iterators().vertexIterator(new Object[0]).forEachRemaining(v -> {
            Assert.assertEquals((Object)new Long(1L), (Object)v.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)v.inE(new String[0]).count().next());
        });
        graph.iterators().edgeIterator(new Object[0]).forEachRemaining(x -> Assert.assertEquals((Object)graphProvider.convertLabel("knows"), (Object)x.label()));
        if (graph.features().vertex().supportsUserSuppliedIds()) {
            Vertex va = (Vertex)graph.iterators().vertexIterator(new Object[]{graphProvider.convertId("1")}).next();
            Vertex vb = (Vertex)graph.iterators().vertexIterator(new Object[]{graphProvider.convertId("2")}).next();
            Vertex vc = (Vertex)graph.iterators().vertexIterator(new Object[]{graphProvider.convertId("3")}).next();
            Vertex vd = (Vertex)graph.iterators().vertexIterator(new Object[]{graphProvider.convertId("4")}).next();
            Assert.assertEquals((Object)a, (Object)va);
            Assert.assertEquals((Object)b, (Object)vb);
            Assert.assertEquals((Object)c, (Object)vc);
            Assert.assertEquals((Object)d, (Object)vd);
            Assert.assertEquals((Object)new Long(1L), (Object)va.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)va.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vb.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vb.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vc.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vc.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vd.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vd.outE(new String[0]).count().next());
            Edge i = a.addEdge(graphProvider.convertLabel("hates"), b, new Object[0]);
            Assert.assertEquals((Object)new Long(1L), (Object)va.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(2L), (Object)va.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(2L), (Object)vb.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vb.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vc.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vc.outE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vd.inE(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)vd.outE(new String[0]).count().next());
            for (Edge x2 : a.outE(new String[0]).toList()) {
                Assert.assertTrue((x2.label().equals(graphProvider.convertId("knows")) || x2.label().equals(graphProvider.convertId("hates")) ? 1 : 0) != 0);
            }
            Assert.assertEquals((Object)graphProvider.convertId("hates"), (Object)i.label());
            Assert.assertEquals((Object)graphProvider.convertId("2"), (Object)i.inV().id().next().toString());
            Assert.assertEquals((Object)graphProvider.convertId("1"), (Object)i.outV().id().next().toString());
        }
        HashSet<Object> vertexIds = new HashSet<Object>();
        vertexIds.add(a.id());
        vertexIds.add(a.id());
        vertexIds.add(b.id());
        vertexIds.add(b.id());
        vertexIds.add(c.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        vertexIds.add(d.id());
        Assert.assertEquals((long)4L, (long)vertexIds.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithSingleEdgeLabelFilter() {
        GraphProvider graphProvider = GraphManager.get();
        Graph graph = this.g;
        Vertex a = graph.addVertex(new Object[0]);
        Vertex b = graph.addVertex(new Object[0]);
        Vertex c = graph.addVertex(new Object[0]);
        String labelFriend = graphProvider.convertLabel("friend");
        String labelHate = graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = a.outE(new String[0]).toList();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = a.outE(new String[]{labelFriend}).toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        results = a.outE(new String[]{labelHate}).toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = a.inE(new String[]{labelHate}).toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = a.inE(new String[]{labelFriend}).toList();
        Assert.assertEquals((long)0L, (long)results.size());
        results = b.inE(new String[]{labelHate}).toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = b.inE(new String[]{labelFriend}).toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTraverseInOutFromVertexWithMultipleEdgeLabelFilter() {
        GraphProvider graphProvider = GraphManager.get();
        Graph graph = this.g;
        Vertex a = graph.addVertex(new Object[0]);
        Vertex b = graph.addVertex(new Object[0]);
        Vertex c = graph.addVertex(new Object[0]);
        String labelFriend = graphProvider.convertLabel("friend");
        String labelHate = graphProvider.convertLabel("hate");
        Edge aFriendB = a.addEdge(labelFriend, b, new Object[0]);
        Edge aFriendC = a.addEdge(labelFriend, c, new Object[0]);
        Edge aHateC = a.addEdge(labelHate, c, new Object[0]);
        Edge cHateA = c.addEdge(labelHate, a, new Object[0]);
        Edge cHateB = c.addEdge(labelHate, b, new Object[0]);
        List results = a.outE(new String[]{labelFriend, labelHate}).toList();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(aFriendC));
        Assert.assertTrue((boolean)results.contains(aHateC));
        results = a.inE(new String[]{labelFriend, labelHate}).toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(cHateA));
        results = b.inE(new String[]{labelFriend, labelHate}).toList();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(aFriendB));
        Assert.assertTrue((boolean)results.contains(cHateB));
        results = b.inE(new String[]{graphProvider.convertLabel("blah1"), graphProvider.convertLabel("blah2")}).toList();
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldTestTreeConnectivity() {
        GraphProvider graphProvider = GraphManager.get();
        Graph graph = this.g;
        int branchSize = 11;
        Vertex start = graph.addVertex(new Object[0]);
        for (int i = 0; i < branchSize; ++i) {
            Vertex a = graph.addVertex(new Object[0]);
            start.addEdge(graphProvider.convertLabel("test1"), a, new Object[0]);
            for (int j = 0; j < branchSize; ++j) {
                Vertex b = graph.addVertex(new Object[0]);
                a.addEdge(graphProvider.convertLabel("test2"), b, new Object[0]);
                for (int k = 0; k < branchSize; ++k) {
                    Vertex c = graph.addVertex(new Object[0]);
                    b.addEdge(graphProvider.convertLabel("test3"), c, new Object[0]);
                }
            }
        }
        Assert.assertEquals((Object)new Long(0L), (Object)start.inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(branchSize), (Object)start.outE(new String[0]).count().next());
        for (Edge e : start.outE(new String[0]).toList()) {
            Assert.assertEquals((Object)graphProvider.convertId("test1"), (Object)e.label());
            Assert.assertEquals((Object)new Long(branchSize), (Object)e.inV().out(new String[0]).count().next());
            Assert.assertEquals((Object)new Long(1L), (Object)e.inV().inE(new String[0]).count().next());
            for (Edge f : e.inV().outE(new String[0]).toList()) {
                Assert.assertEquals((Object)graphProvider.convertId("test2"), (Object)f.label());
                Assert.assertEquals((Object)new Long(branchSize), (Object)f.inV().out(new String[0]).count().next());
                Assert.assertEquals((Object)new Long(1L), (Object)f.inV().in(new String[0]).count().next());
                for (Edge g : f.inV().outE(new String[0]).toList()) {
                    Assert.assertEquals((Object)graphProvider.convertId("test3"), (Object)g.label());
                    Assert.assertEquals((Object)new Long(0L), (Object)g.inV().out(new String[0]).count().next());
                    Assert.assertEquals((Object)new Long(1L), (Object)g.inV().in(new String[0]).count().next());
                }
            }
        }
        int totalVertices = 0;
        for (int i = 0; i < 4; ++i) {
            totalVertices += (int)Math.pow(branchSize, i);
        }
        this.tryCommit(graph, GraphTest.assertVertexEdgeCounts(totalVertices, totalVertices - 1));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Persistence")
    public void shouldPersistDataOnClose() throws Exception {
        GraphProvider graphProvider = GraphManager.get();
        Graph graph = this.g;
        Vertex v = graph.addVertex(new Object[0]);
        Vertex u = graph.addVertex(new Object[0]);
        if (graph.features().edge().properties().supportsStringValues()) {
            v.property("name", (Object)"marko");
            u.property("name", (Object)"pavel");
        }
        Edge e = v.addEdge(graphProvider.convertLabel("collaborator"), u, new Object[0]);
        if (graph.features().edge().properties().supportsStringValues()) {
            e.property("location", (Object)"internet");
        }
        this.tryCommit(graph, GraphTest.assertVertexEdgeCounts(2, 1));
        graph.close();
        Graph reopenedGraph = graphProvider.standardTestGraph(this.getClass(), this.name.getMethodName());
        GraphTest.assertVertexEdgeCounts(2, 1).accept(reopenedGraph);
        if (graph.features().vertex().properties().supportsStringValues()) {
            reopenedGraph.iterators().vertexIterator(new Object[0]).forEachRemaining(vertex -> Assert.assertTrue((vertex.property("name").value().equals("marko") || vertex.property("name").value().equals("pavel") ? 1 : 0) != 0));
        }
        reopenedGraph.iterators().edgeIterator(new Object[0]).forEachRemaining(edge -> {
            Assert.assertEquals((Object)graphProvider.convertId("collaborator"), (Object)edge.label());
            if (graph.features().edge().properties().supportsStringValues()) {
                Assert.assertEquals((Object)"internet", (Object)edge.property("location").value());
            }
        });
        graphProvider.clear(reopenedGraph, graphProvider.standardGraphConfiguration(this.getClass(), this.name.getMethodName()));
    }
}

