/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.io.graphml.GraphMLWriter;
import com.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import com.tinkerpop.gremlin.structure.io.kryo.KryoWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class GraphWritePerformanceTest {
    private static void tryBatchCommit(Graph g, int ix) {
        if (g.features().graph().supportsTransactions() && ix % 1000 == 0) {
            g.tx().commit();
        }
    }

    @AxisRange(min=0.0, max=1.0)
    @BenchmarkMethodChart(filePrefix="io-write")
    @BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20, filePrefix="hx-io-write")
    public static class WriteToIO
    extends AbstractGremlinTest {
        @Rule
        public TestRule benchmarkRun = new BenchmarkRule();

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void writeKryo() throws Exception {
            KryoWriter writer = KryoWriter.build().create();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            writer.writeGraph((OutputStream)os, this.g);
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void writeGraphML() throws Exception {
            GraphMLWriter writer = GraphMLWriter.build().create();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            writer.writeGraph((OutputStream)os, this.g);
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void writeGraphSON() throws Exception {
            GraphSONWriter writer = GraphSONWriter.build().create();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            writer.writeGraph((OutputStream)os, this.g);
        }
    }

    @AxisRange(min=0.0, max=1.0)
    @BenchmarkMethodChart(filePrefix="structure-write")
    @BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20, filePrefix="hx-structure-write")
    public static class WriteToGraph
    extends AbstractGremlinTest {
        @Rule
        public TestRule benchmarkRun = new BenchmarkRule();

        @Test
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void writeEmptyVertices() throws Exception {
            int verticesToGenerate = 100000;
            for (int ix = 0; ix < 100000; ++ix) {
                this.g.addVertex(new Object[0]);
                GraphWritePerformanceTest.tryBatchCommit(this.g, ix);
            }
            WriteToGraph.assertVertexEdgeCounts(100000, 0).accept(this.g);
        }

        @Test
        @BenchmarkOptions(benchmarkRounds=10, warmupRounds=0, concurrency=-1)
        public void writeEmptyVerticesAndEdges() throws Exception {
            int verticesToGenerate = 100000;
            Optional<Object> lastVertex = Optional.empty();
            for (int ix = 0; ix < 100000; ++ix) {
                Vertex v = this.g.addVertex(new Object[0]);
                if (lastVertex.isPresent()) {
                    v.addEdge("parent", (Vertex)lastVertex.get(), new Object[0]);
                }
                lastVertex = Optional.of(v);
                GraphWritePerformanceTest.tryBatchCommit(this.g, ix);
            }
            WriteToGraph.assertVertexEdgeCounts(100000, 99999).accept(this.g);
        }
    }
}

