/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.LoadGraphWith;
import com.tinkerpop.gremlin.process.Path;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.io.kryo.KryoMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class SerializationTest {

    public static class GraphSONTest
    extends AbstractGremlinTest {
        private final TypeReference<HashMap<String, Object>> mapTypeReference = new TypeReference<HashMap<String, Object>>(){};

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertex() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            Vertex v = (Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next();
            String json = mapper.writeValueAsString((Object)v);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)"vertex", m.get("type"));
            Assert.assertEquals((Object)v.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)v.value("name").toString(), ((Map)((List)((Map)m.get("properties")).get("name")).get(0)).get("value"));
            Assert.assertEquals((Object)((Integer)v.value("age")), ((Map)((List)((Map)m.get("properties")).get("age")).get(0)).get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeEdge() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            String json = mapper.writeValueAsString((Object)e);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)"edge", m.get("type"));
            Assert.assertEquals((Object)e.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)((Double)e.value("weight")), ((Map)m.get("properties")).get("weight"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeProperty() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            String json = mapper.writeValueAsString((Object)p);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)p.value(), m.get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexProperty() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            VertexProperty vp = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            String json = mapper.writeValueAsString((Object)vp);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)vp.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)vp.value(), m.get("value"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
        public void shouldSerializeVertexPropertyWithProperties() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            VertexProperty vp = (VertexProperty)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).iterators().propertyIterator(new String[]{"location"}).next();
            String json = mapper.writeValueAsString((Object)vp);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
            Assert.assertEquals((Object)vp.label(), m.get("label"));
            Assert.assertNotNull(m.get("id"));
            Assert.assertEquals((Object)vp.value(), m.get("value"));
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"startTime"}).next()).value(), ((Map)m.get("properties")).get("startTime"));
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"endTime"}).next()).value(), ((Map)m.get("properties")).get("endTime"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePath() throws Exception {
            ObjectMapper mapper = this.g.io().graphSONMapper().create().createMapper();
            Path p = (Path)this.g.V(new Object[]{this.convertToVertexId("marko")}).as("a").outE(new String[0]).as("b").inV().as("c").path().next();
            String json = mapper.writeValueAsString((Object)p);
            Map m = (Map)mapper.readValue(json, this.mapTypeReference);
        }
    }

    public static class KryoTest
    extends AbstractGremlinTest {
        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            Vertex v = (Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)v);
            output.close();
            Input input = new Input(stream.toByteArray());
            Vertex detached = (Vertex)kryo.readObject(input, Vertex.class);
            input.close();
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)v.label(), (Object)detached.label());
            Assert.assertEquals((Object)v.id(), (Object)detached.id());
            Assert.assertEquals((Object)v.value("name").toString(), (Object)detached.value("name"));
            Assert.assertEquals((Object)((Integer)v.value("age")), (Object)detached.value("age"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeEdgeAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)e);
            output.close();
            Input input = new Input(stream.toByteArray());
            Edge detached = (Edge)kryo.readObject(input, Edge.class);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)e.label(), (Object)detached.label());
            Assert.assertEquals((Object)e.id(), (Object)detached.id());
            Assert.assertEquals((Object)((Double)e.value("weight")), (Object)detached.value("weight"));
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePropertyAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            Property p = ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("weight");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)p);
            output.close();
            Input input = new Input(stream.toByteArray());
            Property detached = (Property)kryo.readObject(input, Property.class);
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)p.key(), (Object)detached.key());
            Assert.assertEquals((Object)p.value(), (Object)detached.value());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializeVertexPropertyAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            VertexProperty vp = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).property("name");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)vp);
            output.close();
            Input input = new Input(stream.toByteArray());
            VertexProperty detached = (VertexProperty)kryo.readObject(input, VertexProperty.class);
            input.close();
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)vp.label(), (Object)detached.label());
            Assert.assertEquals((Object)vp.id(), (Object)detached.id());
            Assert.assertEquals((Object)vp.value(), (Object)detached.value());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
        public void shouldSerializeVertexPropertyWithPropertiesAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            VertexProperty vp = (VertexProperty)((Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next()).iterators().propertyIterator(new String[]{"location"}).next();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)vp);
            output.close();
            Input input = new Input(stream.toByteArray());
            VertexProperty detached = (VertexProperty)kryo.readObject(input, VertexProperty.class);
            input.close();
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((Object)vp.label(), (Object)detached.label());
            Assert.assertEquals((Object)vp.id(), (Object)detached.id());
            Assert.assertEquals((Object)vp.value(), (Object)detached.value());
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"startTime"}).next()).value(), (Object)((Property)detached.iterators().propertyIterator(new String[]{"startTime"}).next()).value());
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"startTime"}).next()).key(), (Object)((Property)detached.iterators().propertyIterator(new String[]{"startTime"}).next()).key());
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"endTime"}).next()).value(), (Object)((Property)detached.iterators().propertyIterator(new String[]{"endTime"}).next()).value());
            Assert.assertEquals((Object)((Property)vp.iterators().propertyIterator(new String[]{"endTime"}).next()).key(), (Object)((Property)detached.iterators().propertyIterator(new String[]{"endTime"}).next()).key());
        }

        @Test
        @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
        public void shouldSerializePathAsDetached() throws Exception {
            KryoMapper kryoMapper = this.g.io().kryoMapper().create();
            Kryo kryo = kryoMapper.createMapper();
            Path p = (Path)this.g.V(new Object[]{this.convertToVertexId("marko")}).as("a").outE(new String[0]).as("b").inV().as("c").path().next();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)stream);
            kryo.writeObject(output, (Object)p);
            output.close();
            Input input = new Input(stream.toByteArray());
            Path detached = (Path)kryo.readObject(input, Path.class);
            input.close();
            Assert.assertNotNull((Object)detached);
            Assert.assertEquals((long)p.labels().size(), (long)detached.labels().size());
            Assert.assertEquals((long)((Set)p.labels().get(0)).size(), (long)((Set)detached.labels().get(0)).size());
            Assert.assertEquals((long)((Set)p.labels().get(1)).size(), (long)((Set)detached.labels().get(1)).size());
            Assert.assertEquals((long)((Set)p.labels().get(2)).size(), (long)((Set)detached.labels().get(2)).size());
            Assert.assertTrue((boolean)p.labels().stream().flatMap(Collection::stream).allMatch(arg_0 -> ((Path)detached).hasLabel(arg_0)));
            Vertex vOut = (Vertex)p.get("a");
            Vertex detachedVOut = (Vertex)detached.get("a");
            Assert.assertEquals((Object)vOut.label(), (Object)detachedVOut.label());
            Assert.assertEquals((Object)vOut.id(), (Object)detachedVOut.id());
            Assert.assertFalse((boolean)detachedVOut.iterators().propertyIterator(new String[0]).hasNext());
            Edge e = (Edge)p.get("b");
            Edge detachedE = (Edge)detached.get("b");
            Assert.assertEquals((Object)e.label(), (Object)detachedE.label());
            Assert.assertEquals((Object)e.id(), (Object)detachedE.id());
            Assert.assertFalse((boolean)detachedE.iterators().propertyIterator(new String[0]).hasNext());
            Vertex vIn = (Vertex)p.get("c");
            Vertex detachedVIn = (Vertex)detached.get("c");
            Assert.assertEquals((Object)vIn.label(), (Object)detachedVIn.label());
            Assert.assertEquals((Object)vIn.id(), (Object)detachedVIn.id());
            Assert.assertFalse((boolean)detachedVIn.iterators().propertyIterator(new String[0]).hasNext());
        }
    }
}

