/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.ExceptionCoverage;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Transaction;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.util.function.FunctionUtils;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.configuration.Configuration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@ExceptionCoverage(exceptionClass=Transaction.Exceptions.class, methods={"transactionAlreadyOpen", "threadedTransactionsNotSupported", "openTransactionsOnClose", "transactionMustBeOpenToReadWrite", "onCloseBehaviorCannotBeNull", "onReadWriteBehaviorCannotBeNull"})
public class TransactionTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldHaveExceptionConsistencyWhenTransactionAlreadyOpen() {
        if (!this.g.tx().isOpen()) {
            this.g.tx().open();
        }
        try {
            this.g.tx().open();
            Assert.fail((String)"An exception should be thrown when a transaction is opened twice");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.transactionAlreadyOpen(), ex);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldHaveExceptionConsistencyWhenTransactionOpenOnClose() {
        this.g.tx().onClose((Consumer)Transaction.CLOSE_BEHAVIOR.MANUAL);
        if (!this.g.tx().isOpen()) {
            this.g.tx().open();
        }
        try {
            this.g.close();
            Assert.fail((String)"An exception should be thrown when close behavior is manual and the graph is close with an open transaction");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.openTransactionsOnClose(), ex);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldHaveExceptionConsistencyWhenUsingManualTransaction() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        try {
            this.g.addVertex(new Object[0]);
            Assert.fail((String)"An exception should be thrown when read/write behavior is manual and no transaction is opened");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.transactionMustBeOpenToReadWrite(), ex);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldHaveExceptionConsistencyWhenUsingManualTransactionOnCommit() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        try {
            this.g.tx().commit();
            Assert.fail((String)"An exception should be thrown when read/write behavior is manual and no transaction is opened");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.transactionMustBeOpenToReadWrite(), ex);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldHaveExceptionConsistencyWhenUsingManualTransactionOnRollback() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        try {
            this.g.tx().rollback();
            Assert.fail((String)"An exception should be thrown when read/write behavior is manual and no transaction is opened");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.transactionMustBeOpenToReadWrite(), ex);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldAllowJustCommitOnlyWithAutoTransaction() {
        this.g.tx().commit();
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldAllowJustRollbackOnlyWithAutoTransaction() {
        this.g.tx().rollback();
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldHaveExceptionConsistencyWhenOnCloseToNull() {
        try {
            this.g.tx().onClose(null);
            Assert.fail((String)"An exception should be thrown when onClose behavior is set to null");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.onCloseBehaviorCannotBeNull(), ex);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldHaveExceptionConsistencyWhenOnReadWriteToNull() {
        try {
            this.g.tx().onReadWrite(null);
            Assert.fail((String)"An exception should be thrown when onClose behavior is set to null");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Transaction.Exceptions.onReadWriteBehaviorCannotBeNull(), ex);
        }
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowAutoTransactionToWorkWithoutMutationByDefault() {
        this.g.tx().commit();
        this.g.tx().rollback();
        this.g.tx().commit();
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
    public void shouldCommitElementAutoTransactionByDefault() {
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e1 = v1.addEdge("l", v1, new Object[0]);
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
        this.g.tx().commit();
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
        this.g.iterators().vertexIterator(new Object[]{v1.id()}).forEachRemaining(Element::remove);
        TransactionTest.assertVertexEdgeCounts(0, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 1);
        this.g.iterators().vertexIterator(new Object[]{v1.id()}).forEachRemaining(Element::remove);
        TransactionTest.assertVertexEdgeCounts(0, 0);
        this.g.tx().commit();
        TransactionTest.assertVertexEdgeCounts(0, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldRollbackElementAutoTransactionByDefault() {
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e1 = v1.addEdge("l", v1, new Object[0]);
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(0, 0);
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldCommitPropertyAutoTransactionByDefault() {
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e1 = v1.addEdge("l", v1, new Object[0]);
        this.g.tx().commit();
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
        v1.property("name", (Object)"marko");
        Assert.assertEquals((Object)"marko", (Object)v1.value("name"));
        Assert.assertEquals((Object)"marko", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        this.g.tx().commit();
        Assert.assertEquals((Object)"marko", (Object)v1.value("name"));
        Assert.assertEquals((Object)"marko", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        v1.singleProperty("name", (Object)"stephen", new Object[0]);
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        Assert.assertEquals((Object)"stephen", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        this.g.tx().commit();
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        Assert.assertEquals((Object)"stephen", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        e1.property("name", (Object)"xxx");
        Assert.assertEquals((Object)"xxx", (Object)e1.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).value("name"));
        this.g.tx().commit();
        Assert.assertEquals((Object)"xxx", (Object)e1.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).value("name"));
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldRollbackPropertyAutoTransactionByDefault() {
        Vertex v1 = this.g.addVertex(new Object[]{"name", "marko"});
        Edge e1 = v1.addEdge("l", v1, new Object[]{"name", "xxx"});
        TransactionTest.assertVertexEdgeCounts(1, 1);
        Assert.assertEquals((Object)v1.id(), (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).id());
        Assert.assertEquals((Object)e1.id(), (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).id());
        Assert.assertEquals((Object)"marko", (Object)v1.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)e1.value("name"));
        this.g.tx().commit();
        Assert.assertEquals((Object)"marko", (Object)v1.value("name"));
        Assert.assertEquals((Object)"marko", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        v1.singleProperty("name", (Object)"stephen", new Object[0]);
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        Assert.assertEquals((Object)"stephen", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        this.g.tx().rollback();
        Assert.assertEquals((Object)"marko", (Object)v1.value("name"));
        Assert.assertEquals((Object)"marko", (Object)((Vertex)this.g.iterators().vertexIterator(new Object[]{v1.id()}).next()).value("name"));
        e1.property("name", (Object)"yyy");
        Assert.assertEquals((Object)"yyy", (Object)e1.value("name"));
        Assert.assertEquals((Object)"yyy", (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).value("name"));
        this.g.tx().rollback();
        Assert.assertEquals((Object)"xxx", (Object)e1.value("name"));
        Assert.assertEquals((Object)"xxx", (Object)((Edge)this.g.iterators().edgeIterator(new Object[]{e1.id()}).next()).value("name"));
        TransactionTest.assertVertexEdgeCounts(1, 1);
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldCommitOnShutdownByDefault() throws Exception {
        Vertex v1 = this.g.addVertex(new Object[]{"name", "marko"});
        Object oid = v1.id();
        this.g.close();
        this.g = this.graphProvider.openTestGraph(this.config);
        Vertex v2 = (Vertex)this.g.iterators().vertexIterator(new Object[]{oid}).next();
        Assert.assertEquals((Object)"marko", (Object)v2.value("name"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldRollbackOnShutdownWhenConfigured() throws Exception {
        Vertex v1 = this.g.addVertex(new Object[]{"name", "marko"});
        Object oid = v1.id();
        this.g.tx().onClose((Consumer)Transaction.CLOSE_BEHAVIOR.ROLLBACK);
        this.g.close();
        this.g = this.graphProvider.openTestGraph(this.config);
        try {
            this.g.iterators().vertexIterator(new Object[]{oid}).next();
            Assert.fail((String)"Vertex should not be found as close behavior was set to rollback");
        }
        catch (Exception ex) {
            TransactionTest.validateException(Graph.Exceptions.elementNotFound(Vertex.class, (Object)oid), ex);
        }
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="DoubleValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="FloatValues"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues")})
    public void shouldExecuteWithCompetingThreads() {
        final Graph graph = this.g;
        int totalThreads = 250;
        final AtomicInteger vertices = new AtomicInteger(0);
        final AtomicInteger edges = new AtomicInteger(0);
        final AtomicInteger completedThreads = new AtomicInteger(0);
        for (int i = 0; i < totalThreads; ++i) {
            new Thread(){

                @Override
                public void run() {
                    Random random = new Random();
                    if (random.nextBoolean()) {
                        Vertex a = graph.addVertex(new Object[0]);
                        Vertex b = graph.addVertex(new Object[0]);
                        Edge e = a.addEdge("friend", b, new Object[0]);
                        vertices.getAndAdd(2);
                        a.property("test", (Object)this.getId());
                        b.property("blah", (Object)random.nextDouble());
                        e.property("bloop", (Object)random.nextInt());
                        edges.getAndAdd(1);
                        graph.tx().commit();
                    } else {
                        Vertex a = graph.addVertex(new Object[0]);
                        Vertex b = graph.addVertex(new Object[0]);
                        Edge e = a.addEdge("friend", b, new Object[0]);
                        a.property("test", (Object)this.getId());
                        b.property("blah", (Object)random.nextDouble());
                        e.property("bloop", (Object)random.nextInt());
                        if (random.nextBoolean()) {
                            graph.tx().commit();
                            vertices.getAndAdd(2);
                            edges.getAndAdd(1);
                        } else {
                            graph.tx().rollback();
                        }
                    }
                    completedThreads.getAndAdd(1);
                }
            }.start();
        }
        while (completedThreads.get() < totalThreads) {
        }
        Assert.assertEquals((long)completedThreads.get(), (long)250L);
        TransactionTest.assertVertexEdgeCounts(vertices.get(), edges.get());
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldExecuteCompetingThreadsOnMultipleDbInstances() throws Exception {
        Configuration configuration = this.graphProvider.newGraphConfiguration("g1", this.getClass(), this.name.getMethodName());
        this.graphProvider.clear(configuration);
        final Graph g1 = this.graphProvider.openTestGraph(configuration);
        Thread threadModFirstGraph = new Thread(){

            @Override
            public void run() {
                TransactionTest.this.g.addVertex(new Object[0]);
                TransactionTest.this.g.tx().commit();
            }
        };
        threadModFirstGraph.start();
        threadModFirstGraph.join();
        Thread threadReadBothGraphs = new Thread(){

            @Override
            public void run() {
                long gCounter = (Long)TransactionTest.this.g.V(new Object[0]).count().next();
                Assert.assertEquals((long)1L, (long)gCounter);
                long g1Counter = (Long)g1.V(new Object[0]).count().next();
                Assert.assertEquals((long)0L, (long)g1Counter);
            }
        };
        threadReadBothGraphs.start();
        threadReadBothGraphs.join();
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionIsolationCommitCheck() throws Exception {
        final Graph graph = this.g;
        final CountDownLatch latchCommittedInOtherThread = new CountDownLatch(1);
        final CountDownLatch latchCommitInOtherThread = new CountDownLatch(1);
        final AtomicBoolean noVerticesInFirstThread = new AtomicBoolean(false);
        Thread threadTxStarter = new Thread(){

            @Override
            public void run() {
                graph.addVertex(new Object[0]);
                latchCommitInOtherThread.countDown();
                try {
                    latchCommittedInOtherThread.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.tx().rollback();
                noVerticesInFirstThread.set(!graph.V(new Object[0]).hasNext());
            }
        };
        threadTxStarter.start();
        Thread threadTryCommitTx = new Thread(){

            @Override
            public void run() {
                try {
                    latchCommitInOtherThread.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.tx().commit();
                latchCommittedInOtherThread.countDown();
            }
        };
        threadTryCommitTx.start();
        threadTxStarter.join();
        threadTryCommitTx.join();
        Assert.assertTrue((boolean)noVerticesInFirstThread.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="ThreadedTransactions")})
    public void shouldSupportMultipleThreadsOnTheSameTransaction() throws Exception {
        int numberOfThreads = 10;
        CountDownLatch latch = new CountDownLatch(10);
        Graph threadedG = this.g.tx().create();
        for (int ix = 0; ix < 10; ++ix) {
            new Thread(() -> {
                threadedG.addVertex(new Object[0]);
                latch.countDown();
            }).start();
        }
        latch.await(10000L, TimeUnit.MILLISECONDS);
        TransactionTest.assertVertexEdgeCounts(0, 0);
        threadedG.tx().commit();
        TransactionTest.assertVertexEdgeCounts(10, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionFireAndForget() {
        Graph graph = this.g;
        this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
            grx.addVertex(new Object[0]);
            throw new Exception("fail");
        })).fireAndForget();
        TransactionTest.assertVertexEdgeCounts(0, 0);
        this.g.tx().submit(grx -> graph.addVertex(new Object[0])).fireAndForget();
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionOneAndDone() {
        Graph graph = this.g;
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                grx.addVertex(new Object[0]);
                throw new Exception("fail");
            })).oneAndDone();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        TransactionTest.assertVertexEdgeCounts(0, 0);
        this.g.tx().submit(grx -> graph.addVertex(new Object[0])).oneAndDone();
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionExponentialBackoff() {
        Graph graph = this.g;
        AtomicInteger attempts = new AtomicInteger(0);
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                grx.addVertex(new Object[0]);
                attempts.incrementAndGet();
                throw new Exception("fail");
            })).exponentialBackoff();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        Assert.assertEquals((long)8L, (long)attempts.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
        AtomicInteger tries = new AtomicInteger(0);
        this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
            int tryNumber = tries.incrementAndGet();
            if (tryNumber == 6) {
                return graph.addVertex(new Object[0]);
            }
            throw new Exception("fail");
        })).exponentialBackoff();
        Assert.assertEquals((long)6L, (long)tries.get());
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionExponentialBackoffWithExceptionChecks() {
        Graph graph = this.g;
        HashSet<Class> exceptions = new HashSet<Class>(){
            {
                this.add(IllegalStateException.class);
            }
        };
        AtomicInteger attempts = new AtomicInteger(0);
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                grx.addVertex(new Object[0]);
                attempts.incrementAndGet();
                throw new Exception("fail");
            })).exponentialBackoff(8, 20L, (Set)exceptions);
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        Assert.assertEquals((long)1L, (long)attempts.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
        AtomicInteger setOfTries = new AtomicInteger(0);
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                int tryNumber = setOfTries.incrementAndGet();
                if (tryNumber == 6) {
                    throw new Exception("fail");
                }
                throw new IllegalStateException("fail");
            })).exponentialBackoff(8, 20L, (Set)exceptions);
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        Assert.assertEquals((long)6L, (long)setOfTries.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
        AtomicInteger tries = new AtomicInteger(0);
        this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
            int tryNumber = tries.incrementAndGet();
            if (tryNumber == 6) {
                return graph.addVertex(new Object[0]);
            }
            throw new IllegalStateException("fail");
        })).exponentialBackoff(8, 20L, (Set)exceptions);
        Assert.assertEquals((long)6L, (long)tries.get());
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionRetry() {
        Graph graph = this.g;
        AtomicInteger attempts = new AtomicInteger(0);
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                grx.addVertex(new Object[0]);
                attempts.incrementAndGet();
                throw new Exception("fail");
            })).retry();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        Assert.assertEquals((long)8L, (long)attempts.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
        AtomicInteger tries = new AtomicInteger(0);
        this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
            int tryNumber = tries.incrementAndGet();
            if (tryNumber == 6) {
                return graph.addVertex(new Object[0]);
            }
            throw new Exception("fail");
        })).retry();
        Assert.assertEquals((long)6L, (long)tries.get());
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
        TransactionTest.assertVertexEdgeCounts(1, 0);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionRetryWhenUsingManualTransactions() {
        Graph graph = this.g;
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        AtomicInteger attempts = new AtomicInteger(0);
        try {
            this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
                grx.addVertex(new Object[0]);
                attempts.incrementAndGet();
                throw new Exception("fail");
            })).retry();
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"fail", (Object)ex.getCause().getCause().getMessage());
        }
        Assert.assertEquals((long)8L, (long)attempts.get());
        TransactionTest.assertVertexEdgeCounts(0, 0);
        AtomicInteger tries = new AtomicInteger(0);
        this.g.tx().submit(FunctionUtils.wrapFunction(grx -> {
            int tryNumber = tries.incrementAndGet();
            if (tryNumber == 6) {
                return graph.addVertex(new Object[0]);
            }
            throw new Exception("fail");
        })).retry();
        Assert.assertEquals((long)6L, (long)tries.get());
        Assert.assertFalse((boolean)this.g.tx().isOpen());
        this.g.tx().open();
        TransactionTest.assertVertexEdgeCounts(1, 0);
        this.g.tx().rollback();
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldCountVerticesEdgesOnPreTransactionCommit() {
        Graph graph = this.g;
        Vertex v1 = graph.addVertex(new Object[0]);
        graph.tx().commit();
        TransactionTest.assertVertexEdgeCounts(1, 0);
        Vertex v2 = graph.addVertex(new Object[0]);
        v1 = (Vertex)graph.iterators().vertexIterator(new Object[]{v1.id()}).next();
        v1.addEdge("friend", v2, new Object[0]);
        TransactionTest.assertVertexEdgeCounts(2, 1);
        graph.tx().commit();
        TransactionTest.assertVertexEdgeCounts(2, 1);
    }

    @Test
    @Ignore(value="Ignoring this test for now.  Perhaps it will have relelvance later. see - https://github.com/tinkerpop/tinkerpop3/issues/31")
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")})
    public void shouldSupportTransactionIsolationWithSeparateThreads() throws Exception {
        final Graph graph = this.g;
        final CountDownLatch latchCommit = new CountDownLatch(1);
        final CountDownLatch latchFirstRead = new CountDownLatch(1);
        final CountDownLatch latchSecondRead = new CountDownLatch(1);
        Thread threadMod = new Thread(){

            @Override
            public void run() {
                graph.addVertex(new Object[0]);
                latchFirstRead.countDown();
                try {
                    latchCommit.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                graph.tx().commit();
                latchSecondRead.countDown();
            }
        };
        threadMod.start();
        final AtomicLong beforeCommitInOtherThread = new AtomicLong(0L);
        final AtomicLong afterCommitInOtherThreadButBeforeRollbackInCurrentThread = new AtomicLong(0L);
        final AtomicLong afterCommitInOtherThread = new AtomicLong(0L);
        Thread threadRead = new Thread(){

            @Override
            public void run() {
                try {
                    latchFirstRead.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                beforeCommitInOtherThread.set((Long)graph.V(new Object[0]).count().next());
                latchCommit.countDown();
                try {
                    latchSecondRead.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                afterCommitInOtherThreadButBeforeRollbackInCurrentThread.set((Long)graph.V(new Object[0]).count().next());
                graph.tx().rollback();
                afterCommitInOtherThread.set((Long)graph.V(new Object[0]).count().next());
            }
        };
        threadRead.start();
        threadMod.join();
        threadRead.join();
        Assert.assertEquals((long)0L, (long)beforeCommitInOtherThread.get());
        Assert.assertEquals((long)0L, (long)afterCommitInOtherThreadButBeforeRollbackInCurrentThread.get());
        Assert.assertEquals((long)1L, (long)afterCommitInOtherThread.get());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfVertexOutsideOfOriginalTransactionalContextManual() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        Vertex v1 = this.g.addVertex(new Object[]{"name", "stephen"});
        this.g.tx().commit();
        this.g.tx().open();
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        this.g.tx().close();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfEdgeOutsideOfOriginalTransactionalContextManual() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e = v1.addEdge("self", v1, new Object[]{"weight", 0.5});
        this.g.tx().commit();
        this.g.tx().open();
        Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-5);
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-5);
        this.g.tx().close();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfVertexOutsideOfOriginalTransactionalContextAuto() {
        Vertex v1 = this.g.addVertex(new Object[]{"name", "stephen"});
        this.g.tx().commit();
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
        this.g.tx().rollback();
        Assert.assertEquals((Object)"stephen", (Object)v1.value("name"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfEdgeOutsideOfOriginalTransactionalContextAuto() {
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e = v1.addEdge("self", v1, new Object[]{"weight", 0.5});
        this.g.tx().commit();
        Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-5);
        this.g.tx().rollback();
        Assert.assertEquals((double)0.5, (double)((Double)e.value("weight")), (double)1.0E-5);
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfVertexIdOutsideOfOriginalThreadManual() throws Exception {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        Vertex v1 = this.g.addVertex(new Object[]{"name", "stephen"});
        AtomicReference id = new AtomicReference();
        Thread t = new Thread(() -> {
            this.g.tx().open();
            id.set(v1.id());
        });
        t.start();
        t.join();
        Assert.assertEquals((Object)v1.id(), id.get());
        this.g.tx().rollback();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfEdgeIdOutsideOfOriginalThreadManual() throws Exception {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e = v1.addEdge("self", v1, new Object[]{"weight", 0.5});
        AtomicReference id = new AtomicReference();
        Thread t = new Thread(() -> {
            this.g.tx().open();
            id.set(e.id());
        });
        t.start();
        t.join();
        Assert.assertEquals((Object)e.id(), id.get());
        this.g.tx().rollback();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfVertexIdOutsideOfOriginalThreadAuto() throws Exception {
        Vertex v1 = this.g.addVertex(new Object[]{"name", "stephen"});
        AtomicReference id = new AtomicReference();
        Thread t = new Thread(() -> id.set(v1.id()));
        t.start();
        t.join();
        Assert.assertEquals((Object)v1.id(), id.get());
        this.g.tx().rollback();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldAllowReferenceOfEdgeIdOutsideOfOriginalThreadAuto() throws Exception {
        Vertex v1 = this.g.addVertex(new Object[0]);
        Edge e = v1.addEdge("self", v1, new Object[]{"weight", 0.5});
        AtomicReference id = new AtomicReference();
        Thread t = new Thread(() -> id.set(e.id()));
        t.start();
        t.join();
        Assert.assertEquals((Object)e.id(), id.get());
        this.g.tx().rollback();
    }
}

