/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.ExceptionCoverage;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Element;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.util.function.FunctionUtils;
import com.tinkerpop.gremlin.util.iterator.IteratorUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@ExceptionCoverage(exceptionClass=Vertex.Exceptions.class, methods={"multiplePropertiesExistForProvidedKey"})
@RunWith(value=Enclosed.class)
public class VertexPropertyTest
extends AbstractGremlinTest {

    public static class VertexPropertyTraversals
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldHandleVertexPropertyTraversals() {
            Vertex v = this.g.addVertex(new Object[]{"i", 1, "i", 2, "i", 3});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"i"})));
            });
            v.iterators().propertyIterator(new String[]{"i"}).forEachRemaining(p -> p.property("aKey", (Object)"aValue"));
            ((VertexProperty)v.iterators().propertyIterator(new String[]{"i"}).next()).iterators().propertyIterator(new String[]{"aKey"}).forEachRemaining(p -> Assert.assertEquals((Object)"aValue", (Object)p.value()));
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)((Long)v.properties(new String[]{"i"}).properties(new String[]{"aKey"}).count().next()).intValue());
                Assert.assertEquals((long)3L, (long)((Long)g.V(new Object[0]).properties(new String[]{"i"}).properties(new String[]{"aKey"}).count().next()).intValue());
                Assert.assertEquals((long)1L, (long)((Long)g.V(new Object[0]).properties(new String[]{"i"}).has(T.value, (Object)1).properties(new String[]{"aKey"}).count().next()).intValue());
                Assert.assertEquals((long)3L, (long)((Long)g.V(new Object[0]).properties(new String[]{"i"}).has(T.key, (Object)"i").properties(new String[0]).count().next()).intValue());
            });
        }
    }

    public static class VertexPropertyProperties
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldSupportPropertiesOnMultiProperties() {
            Vertex v = this.g.addVertex(new Object[]{"name", "marko", "age", 34});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                VertexPropertyProperties.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((Object)v.property("name"), (Object)v.property("name").property("acl", (Object)"public").element());
                Assert.assertEquals((Object)v.property("age"), (Object)v.property("age").property("acl", (Object)"private").element());
            });
            v.property("name").property("acl", (Object)"public");
            v.property("age").property("acl", (Object)"private");
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"age"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("age").iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("name").iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("age").iterators().propertyIterator(new String[]{"acl"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.property("name").iterators().propertyIterator(new String[]{"acl"})));
                Assert.assertEquals((Object)"private", v.property("age").iterators().valueIterator(new String[]{"acl"}).next());
                Assert.assertEquals((Object)"public", v.property("name").iterators().valueIterator(new String[]{"acl"}).next());
                VertexPropertyProperties.assertVertexEdgeCounts(1, 0);
            });
            v.property("age").property("acl", (Object)"public");
            v.property("age").property("changeDate", (Object)2014);
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((Object)"public", v.property("age").iterators().valueIterator(new String[]{"acl"}).next());
                Assert.assertEquals((Object)2014, v.property("age").iterators().valueIterator(new String[]{"changeDate"}).next());
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"age"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)v.iterators().propertyIterator(new String[]{"age"}).next()).iterators().propertyIterator(new String[0])));
            });
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"elementAlreadyRemoved"})
    public static class ExceptionConsistencyWhenVertexPropertyRemovedTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public Consumer<VertexProperty> functionToTest;

        @Parameterized.Parameters(name="{0}")
        public static Iterable<Object[]> data() {
            return Arrays.asList(new Object[][]{{"property(k)", FunctionUtils.wrapConsumer(p -> p.property("year"))}});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")})
        public void shouldThrowExceptionIfVertexPropertyWasRemoved() {
            Vertex v1 = this.g.addVertex(new Object[0]);
            VertexProperty p = v1.property("name", (Object)"stephen", new Object[]{"year", "2012"});
            Object id = p.id();
            p.remove();
            this.tryCommit(this.g, g -> {
                try {
                    this.functionToTest.accept(p);
                    Assert.fail((String)"Should have thrown exception as the Vertex was already removed");
                }
                catch (Exception ex) {
                    ExceptionConsistencyWhenVertexPropertyRemovedTest.validateException(Element.Exceptions.elementAlreadyRemoved(VertexProperty.class, (Object)id), ex);
                }
            });
        }
    }

    public static class VertexPropertyRemoval
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldSupportIdempotentVertexPropertyRemoval() {
            Vertex a = this.g.addVertex(new Object[]{"name", "marko"});
            Vertex b = this.g.addVertex(new Object[]{"name", "daniel", "name", "kuppitz"});
            a.property("name").remove();
            a.property("name").remove();
            a.property("name").remove();
            b.properties(new String[]{"name"}).remove();
            b.property("name").remove();
            b.properties(new String[]{"name"}).remove();
            b.property("name").remove();
            b.properties(new String[]{"name"}).remove();
            b.property("name").remove();
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldAllowIteratingAndRemovingVertexPropertyProperties() {
            Vertex daniel = this.g.addVertex(new Object[]{"name", "daniel", "name", "kuppitz", "name", "big d", "name", "the german"});
            daniel.properties(new String[]{"name"}).sideEffect(vp -> ((VertexProperty)vp.get()).property("aKey", (Object)UUID.randomUUID().toString())).sideEffect(vp -> ((VertexProperty)vp.get()).property("bKey", (Object)UUID.randomUUID().toString())).sideEffect(vp -> ((VertexProperty)vp.get()).property("cKey", (Object)UUID.randomUUID().toString())).iterate();
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)daniel.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)12L, (long)((Long)daniel.properties(new String[0]).properties(new String[0]).count().next()));
            daniel.properties(new String[0]).properties(new String[0]).remove();
            Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)daniel.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)0L, (long)((Long)daniel.properties(new String[0]).properties(new String[0]).count().next()));
            daniel.properties(new String[0]).remove();
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)daniel.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)0L, (long)((Long)daniel.properties(new String[0]).properties(new String[0]).count().next()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")})
        public void shouldRemoveMultiProperties() {
            Vertex v = this.g.addVertex(new Object[]{"name", "marko", "age", 34});
            v.property("name", (Object)"marko a. rodriguez");
            this.tryCommit(this.g);
            v.property("name", (Object)"marko rodriguez");
            v.property("name", (Object)"marko");
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)5L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.iterators().valueIterator(new String[]{"name"}));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko a. rodriguez"));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko rodriguez"));
                Assert.assertThat((Object)values, (Matcher)Matchers.hasItem((Object)"marko"));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            v.properties(new String[0]).has(T.value, (Object)"marko").remove();
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            v.property("age").remove();
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
            v.properties(new String[]{"name"}).has(T.key, (Object)"name").remove();
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldRemoveMultiPropertiesWhenVerticesAreRemoved() {
            Vertex marko = this.g.addVertex(new Object[]{"name", "marko", "name", "okram"});
            Vertex stephen = this.g.addVertex(new Object[]{"name", "stephen", "name", "spmallette"});
            this.tryCommit(this.g, g -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(2, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)stephen.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)stephen.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"blah"})));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)stephen.iterators().propertyIterator(new String[]{"blah"})));
            });
            stephen.remove();
            this.tryCommit(this.g, g -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"blah"})));
            });
            for (int i = 0; i < 100; ++i) {
                marko.property("name", (Object)i);
            }
            this.tryCommit(this.g, g -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)102L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)102L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"blah"})));
            });
            this.g.V(new Object[0]).properties(new String[]{"name"}).has(T.value, (a, b) -> ((Class)b).isAssignableFrom(a.getClass()), Integer.class).remove();
            this.tryCommit(this.g, g -> {
                VertexPropertyRemoval.assertVertexEdgeCounts(1, 0);
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"blah"})));
            });
            marko.remove();
            this.tryCommit(this.g, g -> VertexPropertyRemoval.assertVertexEdgeCounts(0, 0));
        }
    }

    public static class VertexPropertyAddition
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="UserSuppliedIds")})
        public void shouldAllowIdAssignment() {
            Vertex v = this.g.addVertex(new Object[0]);
            Object id = this.graphProvider.convertId(123131231L);
            v.property("name", (Object)"stephen", new Object[]{T.id, id});
            this.tryCommit(this.g, g -> Assert.assertEquals((Object)id, (Object)v.property("name").id()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldSetLabelOfVertexPropertyToKeyOfOwningProperty() {
            Vertex v = this.g.addVertex(new Object[]{"name", "stephen"});
            this.tryCommit(this.g, g -> Assert.assertEquals((Object)"name", (Object)v.property("name").label()));
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues")})
        public void shouldAddMultiProperties() {
            Vertex v = this.g.addVertex(new Object[]{"name", "marko", "age", 34});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((Object)"marko", (Object)v.property("name").value());
                Assert.assertEquals((Object)"marko", (Object)v.value("name"));
                Assert.assertEquals((Object)34, (Object)v.property("age").value());
                Assert.assertEquals((long)34L, (long)((Integer)v.value("age")).intValue());
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
            VertexProperty property = v.property("name", (Object)"marko a. rodriguez");
            this.tryCommit(this.g, g -> Assert.assertEquals((Object)v, (Object)property.element()));
            try {
                v.property("name");
                Assert.fail((String)("This should throw a: " + Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)"name")));
            }
            catch (Exception e) {
                VertexPropertyAddition.validateException(Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)"name"), e);
            }
            Assert.assertTrue((boolean)((List)((Map)v.valueMap(new String[0]).next()).get("name")).contains("marko"));
            Assert.assertTrue((boolean)((List)((Map)v.valueMap(new String[0]).next()).get("name")).contains("marko a. rodriguez"));
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
            VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            Assert.assertEquals((Object)v, (Object)v.property("name", (Object)"mrodriguez").element());
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)4L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
            v.properties(new String[]{"name"}).sideEffect(meta -> ((VertexProperty)meta.get()).property("counter", (Object)((String)((VertexProperty)meta.get()).value()).length())).iterate();
            this.tryCommit(this.g, g -> {
                v.properties(new String[0]).forEachRemaining(meta -> {
                    Assert.assertEquals((Object)meta.key(), (Object)meta.label());
                    Assert.assertTrue((boolean)meta.isPresent());
                    Assert.assertEquals((Object)v, (Object)meta.element());
                    if (meta.key().equals("age")) {
                        Assert.assertEquals((Object)meta.value(), (Object)34);
                        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)meta.iterators().propertyIterator(new String[0])));
                    }
                    if (meta.key().equals("name")) {
                        Assert.assertEquals((long)((String)meta.value()).length(), (long)((Integer)meta.value("counter")).intValue());
                        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)meta.iterators().propertyIterator(new String[0])));
                        Assert.assertEquals((long)1L, (long)meta.keys().size());
                        Assert.assertTrue((boolean)meta.keys().contains("counter"));
                    }
                });
                VertexPropertyAddition.assertVertexEdgeCounts(1, 0);
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="IntegerValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")})
        public void shouldHandleSingleVertexProperties() {
            Vertex v = this.g.addVertex(new Object[]{"name", "marko", "name", "marko a. rodriguez", "name", "marko rodriguez"});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.iterators().valueIterator(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
            });
            v.properties(new String[]{"name"}).remove();
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
            });
            v.property("name", (Object)"marko");
            v.property("name", (Object)"marko a. rodriguez");
            v.property("name", (Object)"marko rodriguez");
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                List values = IteratorUtils.list((Iterator)v.iterators().valueIterator(new String[]{"name"}));
                Assert.assertTrue((boolean)values.contains("marko"));
                Assert.assertTrue((boolean)values.contains("marko a. rodriguez"));
                Assert.assertTrue((boolean)values.contains("marko rodriguez"));
            });
            v.singleProperty("name", (Object)"okram", new Object[]{"acl", "private", "date", 2014});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)v.iterators().propertyIterator(new String[]{"name"}).next()).iterators().propertyIterator(new String[0])));
                Assert.assertEquals((Object)"private", ((Map)v.property("name").valueMap(new String[0]).next()).get("acl"));
                Assert.assertEquals((Object)2014, ((Map)v.property("name").valueMap(new String[0]).next()).get("date"));
            });
            v.remove();
            this.tryCommit(this.g, g -> VertexPropertyAddition.assertVertexEdgeCounts(0, 0));
            Vertex u = this.g.addVertex(new Object[]{"name", "marko", "name", "marko a. rodriguez", "name", "marko rodriguez"});
            this.tryCommit(this.g);
            u.properties(new String[0]).remove();
            u.singleProperty("name", (Object)"okram", new Object[]{"acl", "private", "date", 2014});
            this.tryCommit(this.g, g -> {
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)u.iterators().propertyIterator(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)u.iterators().propertyIterator(new String[0])));
                Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)((VertexProperty)u.iterators().propertyIterator(new String[]{"name"}).next()).iterators().propertyIterator(new String[0])));
                Assert.assertEquals((Object)"private", ((Map)u.property("name").valueMap(new String[0]).next()).get("acl"));
                Assert.assertEquals((Object)2014, ((Map)u.property("name").valueMap(new String[0]).next()).get("date"));
            });
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="StringValues"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="BooleanValues"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
        public void shouldRespectWhatAreEdgesAndWhatArePropertiesInMultiProperties() {
            Vertex marko = this.g.addVertex(new Object[]{"name", "marko"});
            Vertex stephen = this.g.addVertex(new Object[]{"name", "stephen"});
            marko.addEdge("knows", stephen, new Object[0]);
            VertexProperty santaFe = marko.property("location", (Object)"santa fe", new Object[]{"visible", false});
            VertexProperty newMexico = marko.property("location", (Object)"new mexico", new Object[]{"visible", true});
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.iterators().edgeIterator(Direction.OUT, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.iterators().edgeIterator(Direction.OUT, new String[]{"knows"})));
            Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"location"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)marko.iterators().propertyIterator(new String[]{"name"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.iterators().edgeIterator(Direction.IN, new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.iterators().edgeIterator(Direction.IN, new String[]{"knows"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)stephen.iterators().propertyIterator(new String[]{"name"})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)santaFe.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)santaFe.iterators().propertyIterator(new String[]{"visible"})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)santaFe.iterators().propertyIterator(new String[]{T.key.getAccessor()})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)santaFe.iterators().propertyIterator(new String[]{T.value.getAccessor()})));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)newMexico.iterators().propertyIterator(new String[0])));
            Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)newMexico.iterators().propertyIterator(new String[]{"visible"})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)newMexico.iterators().propertyIterator(new String[]{T.key.getAccessor()})));
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)newMexico.iterators().propertyIterator(new String[]{T.value.getAccessor()})));
        }
    }
}

