/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.strategy;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.GraphManager;
import com.tinkerpop.gremlin.process.T;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.IdStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class IdStrategyTest {
    private static final String idKey = "myId";

    public static class EdgeIdNotSupportedIdStrategyTest
    extends AbstractGremlinTest {
        public EdgeIdNotSupportedIdStrategyTest() {
            super(new GraphStrategy[]{IdStrategy.build((String)IdStrategyTest.idKey).supportsEdgeId(false).create()});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")
        public void shouldInjectAnIdAndReturnBySpecifiedId() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{T.id, "test", "something", "else"});
            Edge e = v.addEdge("self", v, new Object[]{T.id, "edge-id", "try", "this"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"edge-id", (Object)e.id());
                Assert.assertFalse((boolean)e.property(strategy.getIdKey()).isPresent());
                Assert.assertEquals((Object)"this", (Object)e.property("try").value());
                Edge found = (Edge)this.g.E(new Object[]{"edge-id"}).next();
                Assert.assertEquals((Object)"edge-id", (Object)found.id());
                Assert.assertFalse((boolean)found.property(strategy.getIdKey()).isPresent());
                Assert.assertEquals((Object)"this", (Object)found.property("try").value());
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="UserSuppliedIds")
        public void shouldAllowDirectSettingOfIdField() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{T.id, "test", "something", "else"});
            Edge e = v.addEdge("self", v, new Object[]{T.id, "edge-id", "try", "this", strategy.getIdKey(), "should be ok to set this as supportsEdgeId=false"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"edge-id", (Object)e.id());
                Assert.assertEquals((Object)"this", (Object)e.property("try").value());
                Assert.assertEquals((Object)"should be ok to set this as supportsEdgeId=false", (Object)e.property(strategy.getIdKey()).value());
                Edge found = (Edge)this.g.E(new Object[]{"edge-id"}).next();
                Assert.assertEquals((Object)"edge-id", (Object)found.id());
                Assert.assertEquals((Object)"this", (Object)found.property("try").value());
                Assert.assertEquals((Object)"should be ok to set this as supportsEdgeId=false", (Object)found.property(strategy.getIdKey()).value());
            });
            try {
                this.g.addVertex(new Object[]{T.id, "test", "something", "else", strategy.getIdKey(), "this should toss and exception as supportsVertexId=true"});
                Assert.fail((String)"An exception should be tossed here because supportsVertexId=true");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertNotNull((Object)iae);
            }
            try {
                v.property(strategy.getIdKey(), (Object)"this should toss and exception as supportsVertexId=true");
                Assert.fail((String)"An exception should be tossed here because supportsVertexId=true");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertNotNull((Object)iae);
            }
        }
    }

    public static class VertexIdNotSupportedIdStrategyTest
    extends AbstractGremlinTest {
        public VertexIdNotSupportedIdStrategyTest() {
            super(new GraphStrategy[]{IdStrategy.build((String)IdStrategyTest.idKey).supportsVertexId(false).create()});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
        public void shouldInjectAnIdAndReturnBySpecifiedId() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Object o = GraphManager.get().convertId("1");
            Vertex v = this.g.addVertex(new Object[]{T.id, o, "something", "else"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)v);
                Assert.assertEquals((Object)o, (Object)v.id());
                Assert.assertFalse((boolean)v.property(strategy.getIdKey()).isPresent());
                Assert.assertEquals((Object)"else", (Object)v.property("something").value());
                Vertex found = (Vertex)this.g.V(new Object[]{o}).next();
                Assert.assertEquals((Object)o, (Object)found.id());
                Assert.assertFalse((boolean)found.property(strategy.getIdKey()).isPresent());
                Assert.assertEquals((Object)"else", (Object)found.property("something").value());
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds")
        public void shouldAllowDirectSettingOfIdField() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Object o = GraphManager.get().convertId("1");
            Vertex v = this.g.addVertex(new Object[]{T.id, o, "something", "else", strategy.getIdKey(), "should be ok to set this as supportsEdgeId=true"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)v);
                Assert.assertEquals((Object)o, (Object)v.id());
                Assert.assertEquals((Object)"should be ok to set this as supportsEdgeId=true", (Object)v.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)v.property("something").value());
                Vertex found = (Vertex)this.g.V(new Object[]{o}).next();
                Assert.assertEquals((Object)o, (Object)found.id());
                Assert.assertEquals((Object)"should be ok to set this as supportsEdgeId=true", (Object)found.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)found.property("something").value());
            });
            try {
                v.addEdge("self", v, new Object[]{T.id, o, "something", "else", strategy.getIdKey(), "this should toss and exception as supportsVertexId=false"});
                Assert.fail((String)"An exception should be tossed here because supportsEdgeId=true");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertNotNull((Object)iae);
            }
            try {
                Edge e = v.addEdge("self", v, new Object[]{T.id, o, "something", "else"});
                e.property(strategy.getIdKey(), (Object)"this should toss and exception as supportsVertexId=false");
                Assert.fail((String)"An exception should be tossed here because supportsEdgeId=true");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertNotNull((Object)iae);
            }
        }
    }

    public static class EdgeIdMakerIdStrategyTest
    extends AbstractGremlinTest {
        public EdgeIdMakerIdStrategyTest() {
            super(new GraphStrategy[]{IdStrategy.build((String)IdStrategyTest.idKey).edgeIdMaker(() -> "100").create()});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldCreateAnIdAndReturnByCreatedId() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{"something", "else"});
            Edge e = v.addEdge("self", v, new Object[]{"try", "this"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"100", (Object)e.id());
                Assert.assertEquals((Object)"100", (Object)e.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"this", (Object)e.property("try").value());
                Edge found = (Edge)this.g.E(new Object[]{"100"}).next();
                Assert.assertEquals((Object)"100", (Object)found.id());
                Assert.assertEquals((Object)"100", (Object)found.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"this", (Object)found.property("try").value());
            });
        }
    }

    public static class VertexIdMakerIdStrategyTest
    extends AbstractGremlinTest {
        public VertexIdMakerIdStrategyTest() {
            super(new GraphStrategy[]{IdStrategy.build((String)IdStrategyTest.idKey).vertexIdMaker(() -> "100").create()});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldCreateAnIdAndReturnByCreatedId() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{"something", "else"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)v);
                Assert.assertEquals((Object)"100", (Object)v.id());
                Assert.assertEquals((Object)"100", (Object)v.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)v.property("something").value());
                Vertex found = (Vertex)this.g.V(new Object[]{"100"}).next();
                Assert.assertEquals((Object)"100", (Object)found.id());
                Assert.assertEquals((Object)"100", (Object)found.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)found.property("something").value());
            });
        }
    }

    public static class DefaultIdStrategyTest
    extends AbstractGremlinTest {
        public DefaultIdStrategyTest() {
            super(new GraphStrategy[]{IdStrategy.build((String)IdStrategyTest.idKey).create()});
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldInjectAnIdAndReturnBySpecifiedIdForVertex() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{T.id, "test", "something", "else"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)v);
                Assert.assertEquals((Object)"test", (Object)v.id());
                Assert.assertEquals((Object)"test", (Object)v.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)v.property("something").value());
                Vertex found = (Vertex)this.g.V(new Object[]{"test"}).next();
                Assert.assertEquals((Object)"test", (Object)found.id());
                Assert.assertEquals((Object)"test", (Object)found.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"else", (Object)found.property("something").value());
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldInjectAnIdAndReturnBySpecifiedIdForEdge() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{T.id, "test", "something", "else"});
            Edge e = v.addEdge("self", v, new Object[]{T.id, "edge-id", "try", "this"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"edge-id", (Object)e.id());
                Assert.assertEquals((Object)"edge-id", (Object)e.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"this", (Object)e.property("try").value());
                Edge found = (Edge)this.g.E(new Object[]{"edge-id"}).next();
                Assert.assertEquals((Object)"edge-id", (Object)found.id());
                Assert.assertEquals((Object)"edge-id", (Object)found.property(strategy.getIdKey()).value());
                Assert.assertEquals((Object)"this", (Object)found.property("try").value());
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldCreateAnIdAndReturnByCreatedIdForVertex() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{"something", "else"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)v);
                Assert.assertNotNull((Object)UUID.fromString(v.id().toString()));
                Assert.assertNotNull((Object)UUID.fromString(v.property(strategy.getIdKey()).value().toString()));
                Assert.assertEquals((Object)"else", (Object)v.property("something").value());
                Vertex found = (Vertex)this.g.V(new Object[]{v.id()}).next();
                Assert.assertNotNull((Object)UUID.fromString(found.id().toString()));
                Assert.assertNotNull((Object)UUID.fromString(found.property(strategy.getIdKey()).value().toString()));
                Assert.assertEquals((Object)"else", (Object)found.property("something").value());
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldCreateAnIdAndReturnByCreatedIdForEdge() {
            IdStrategy strategy = (IdStrategy)((StrategyGraph)this.g).getStrategy();
            Vertex v = this.g.addVertex(new Object[]{"something", "else"});
            Edge e = v.addEdge("self", v, new Object[]{"try", "this"});
            this.tryCommit(this.g, c -> {
                Assert.assertNotNull((Object)e);
                Assert.assertNotNull((Object)UUID.fromString(e.id().toString()));
                Assert.assertNotNull((Object)UUID.fromString(e.property(strategy.getIdKey()).value().toString()));
                Assert.assertEquals((Object)"this", (Object)e.property("try").value());
                Edge found = (Edge)this.g.E(new Object[]{e.id()}).next();
                Assert.assertNotNull((Object)UUID.fromString(found.id().toString()));
                Assert.assertNotNull((Object)UUID.fromString(found.property(strategy.getIdKey()).value().toString()));
                Assert.assertEquals((Object)"this", (Object)found.property("try").value());
            });
        }
    }
}

