/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.strategy;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.PartitionStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyEdge;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertex;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class PartitionStrategyTest
extends AbstractGremlinTest {
    private static final String partition = "gremlin.partitionGraphStrategy.partition";

    public PartitionStrategyTest() {
        super(new GraphStrategy[]{PartitionStrategy.build().partitionKey(partition).startPartition("A").create()});
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAppendPartitionToVertex() {
        Vertex v = this.g.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)((StrategyVertex)v).getBaseVertex().property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldHidePartitionKeyOnVertex() {
        Vertex v = this.g.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertFalse((boolean)v.property(partition).isPresent());
        Assert.assertFalse((boolean)v.iterators().propertyIterator(new String[]{partition}).hasNext());
        Assert.assertFalse((boolean)v.iterators().valueIterator(new String[]{partition}).hasNext());
        Assert.assertFalse((boolean)v.keys().contains(partition));
        Assert.assertEquals((Object)"A", (Object)((StrategyVertex)v).getBaseVertex().property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAppendPartitionToEdge() {
        Vertex v1 = this.g.addVertex(new Object[]{"any", "thing"});
        Vertex v2 = this.g.addVertex(new Object[]{"some", "thing"});
        Edge e = v1.addEdge("connectsTo", v2, new Object[]{"every", "thing"});
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)"thing", (Object)v1.property("any").value());
        Assert.assertEquals((Object)"A", (Object)((StrategyVertex)v2).getBaseVertex().property(partition).value());
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((Object)"thing", (Object)v2.property("some").value());
        Assert.assertEquals((Object)"A", (Object)((StrategyVertex)v2).getBaseVertex().property(partition).value());
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"thing", (Object)e.property("every").value());
        Assert.assertEquals((Object)"connectsTo", (Object)e.label());
        Assert.assertEquals((Object)"A", (Object)((StrategyEdge)e).getBaseEdge().property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldHidePartitionKeyOnEdge() {
        Vertex v1 = this.g.addVertex(new Object[]{"any", "thing"});
        Vertex v2 = this.g.addVertex(new Object[]{"some", "thing"});
        Edge e = v1.addEdge("connectsTo", v2, new Object[]{"every", "thing"});
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"thing", (Object)e.property("every").value());
        Assert.assertEquals((Object)"connectsTo", (Object)e.label());
        Assert.assertFalse((boolean)e.property(partition).isPresent());
        Assert.assertFalse((boolean)e.iterators().propertyIterator(new String[]{partition}).hasNext());
        Assert.assertFalse((boolean)e.iterators().valueIterator(new String[]{partition}).hasNext());
        Assert.assertFalse((boolean)e.keys().contains(partition));
        Assert.assertEquals((Object)"A", (Object)((StrategyEdge)e).getBaseEdge().property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldWriteVerticesToMultiplePartitions() {
        Vertex vA = this.g.addVertex(new Object[]{"any", "a"});
        PartitionStrategy strategy = (PartitionStrategy)((StrategyGraph)this.g).getStrategy();
        strategy.setWritePartition("B");
        Vertex vB = this.g.addVertex(new Object[]{"any", "b"});
        Assert.assertNotNull((Object)vA);
        Assert.assertEquals((Object)"a", (Object)vA.property("any").value());
        Assert.assertEquals((Object)"A", (Object)((StrategyVertex)vA).getBaseVertex().property(partition).value());
        Assert.assertNotNull((Object)vB);
        Assert.assertEquals((Object)"b", (Object)vB.property("any").value());
        Assert.assertEquals((Object)"B", (Object)((StrategyVertex)vB).getBaseVertex().property(partition).value());
        this.g.V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)(v instanceof StrategyVertex));
            Assert.assertEquals((Object)"a", (Object)v.property("any").value());
        });
        strategy.removeReadPartition("A");
        strategy.addReadPartition("B");
        this.g.V(new Object[0]).forEachRemaining(v -> {
            Assert.assertTrue((boolean)(v instanceof StrategyVertex));
            Assert.assertEquals((Object)"b", (Object)v.property("any").value());
        });
        strategy.addReadPartition("A");
        Assert.assertEquals((Object)new Long(2L), (Object)this.g.V(new Object[0]).count().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldThrowExceptionOnvInDifferentPartition() {
        Vertex vA = this.g.addVertex(new Object[]{"any", "a"});
        Assert.assertEquals((Object)vA.id(), (Object)this.g.V(new Object[]{vA.id()}).id().next());
        PartitionStrategy strategy = (PartitionStrategy)((StrategyGraph)this.g).getStrategy();
        strategy.clearReadPartitions();
        try {
            this.g.V(new Object[]{vA.id()});
        }
        catch (Exception ex) {
            NoSuchElementException expected = Graph.Exceptions.elementNotFound(Vertex.class, (Object)vA.id());
            Assert.assertEquals(expected.getClass(), ex.getClass());
            Assert.assertEquals((Object)expected.getMessage(), (Object)ex.getMessage());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldThrowExceptionOneInDifferentPartition() {
        Vertex vA = this.g.addVertex(new Object[]{"any", "a"});
        Edge e = vA.addEdge("knows", vA, new Object[0]);
        Assert.assertEquals((Object)e.id(), (Object)this.g.E(new Object[]{e.id()}).id().next());
        PartitionStrategy strategy = (PartitionStrategy)((StrategyGraph)this.g).getStrategy();
        strategy.clearReadPartitions();
        try {
            this.g.E(new Object[]{e.id()});
        }
        catch (Exception ex) {
            NoSuchElementException expected = Graph.Exceptions.elementNotFound(Edge.class, (Object)e.id());
            Assert.assertEquals(expected.getClass(), ex.getClass());
            Assert.assertEquals((Object)expected.getMessage(), (Object)ex.getMessage());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldWriteToMultiplePartitions() {
        Vertex vA = this.g.addVertex(new Object[]{"any", "a"});
        Vertex vAA = this.g.addVertex(new Object[]{"any", "aa"});
        Edge eAtoAA = vA.addEdge("a->a", vAA, new Object[0]);
        PartitionStrategy strategy = (PartitionStrategy)((StrategyGraph)this.g).getStrategy();
        strategy.setWritePartition("B");
        Vertex vB = this.g.addVertex(new Object[]{"any", "b"});
        vA.addEdge("a->b", vB, new Object[0]);
        strategy.setWritePartition("C");
        Vertex vC = this.g.addVertex(new Object[]{"any", "c"});
        Edge eBtovC = vB.addEdge("b->c", vC, new Object[0]);
        Edge eAtovC = vA.addEdge("a->c", vC, new Object[0]);
        strategy.clearReadPartitions();
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.E(new Object[0]).count().next());
        strategy.addReadPartition("A");
        Assert.assertEquals((Object)new Long(2L), (Object)this.g.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vA.id()}).outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)this.g.V(new Object[]{vA.id()}).outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vA.id()}).out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)this.g.V(new Object[]{vA.id()}).out(new String[0]).next()).id());
        Vertex vA1 = (Vertex)this.g.V(new Object[]{vA.id()}).next();
        Assert.assertEquals((Object)new Long(1L), (Object)vA1.outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)vA1.outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)vA1.out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)vA1.out(new String[0]).next()).id());
        strategy.addReadPartition("B");
        Assert.assertEquals((Object)new Long(3L), (Object)this.g.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(2L), (Object)this.g.E(new Object[0]).count().next());
        strategy.addReadPartition("C");
        Assert.assertEquals((Object)new Long(4L), (Object)this.g.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(4L), (Object)this.g.E(new Object[0]).count().next());
        strategy.removeReadPartition("A");
        strategy.removeReadPartition("B");
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)this.g.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        strategy.addReadPartition("B");
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)this.g.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        Assert.assertEquals((Object)vC.id(), (Object)this.g.E(new Object[]{eBtovC.id()}).inV().id().next());
        Assert.assertEquals((Object)vB.id(), (Object)this.g.E(new Object[]{eBtovC.id()}).outV().id().next());
        try {
            this.g.E(new Object[]{eAtovC.id()}).next();
            Assert.fail((String)"Edge should not be in the graph because vA is not in partitions {B,C}");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NoSuchElementException));
        }
    }
}

