/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.strategy;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.FeatureRequirements;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.ReadOnlyStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import com.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyStrategyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void shouldNotAllowAddVertex() {
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> g.addVertex(new Object[0])));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
    public void shouldNotAllowRemoveVertex() {
        this.g.addVertex(new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> ((Vertex)g.V(new Object[0]).next()).remove()));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
    public void shouldNotAllowRemoveEdge() {
        Vertex v = this.g.addVertex(new Object[0]);
        v.addEdge("friend", v, new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> {
            Edge e = (Edge)g.E(new Object[0]).next();
            e.remove();
        }));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")})
    public void shouldNotAllowAddEdge() {
        this.g.addVertex(new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> {
            Vertex v = (Vertex)g.V(new Object[0]).next();
            v.addEdge("friend", v, new Object[0]);
        }));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowVertexSetProperties() {
        this.g.addVertex(new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> ((Vertex)g.V(new Object[0]).next()).property("test", (Object)"test")));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldNotAllowVertexSetProperty() {
        this.g.addVertex(new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> ((Vertex)g.V(new Object[0]).next()).property("test", (Object)"test")));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldNotAllowVertexPropertySetProperty() {
        this.g.addVertex(new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> {
            VertexProperty p = ((Vertex)g.V(new Object[0]).next()).property("test", (Object)"test");
            p.property("property", (Object)"on-a-property");
        }));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowEdgeSetProperties() {
        Vertex v = this.g.addVertex(new Object[0]);
        v.addEdge("friend", v, new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> ((Edge)g.E(new Object[0]).next()).property("test", (Object)"test")));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowEdgeSetProperty() {
        Vertex v = this.g.addVertex(new Object[0]);
        v.addEdge("friend", v, new Object[0]);
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> ((Edge)g.E(new Object[0]).next()).property("test", (Object)"test")));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowVertexPropertyRemoval() {
        Vertex v = this.g.addVertex(new Object[0]);
        v.property("test", (Object)"test");
        VertexProperty p = v.property("test");
        Assert.assertEquals((Object)"test", (Object)p.value());
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> {
            VertexProperty prop = (VertexProperty)((Vertex)g.V(new Object[0]).next()).iterators().propertyIterator(new String[]{"test"}).next();
            prop.remove();
        }));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowEdgePropertyRemoval() {
        Vertex v = this.g.addVertex(new Object[0]);
        Edge e = v.addEdge("friend", v, new Object[0]);
        e.property("test", (Object)"test");
        Property p = e.property("test");
        Assert.assertEquals((Object)"test", (Object)p.value());
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> {
            Property prop = ((Edge)g.E(new Object[0]).next()).property("test");
            prop.remove();
        }));
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
    public void shouldNotAllowVariableModifications() {
        this.assertException((ThrowingConsumer<Graph>)((ThrowingConsumer)g -> g.variables().set("will", (Object)"not work")));
    }

    @Test(expected=UnsupportedOperationException.class)
    @FeatureRequirement(featureClass=Graph.Features.VariableFeatures.class, feature="Variables")
    public void shouldNotAllowVariableAsMapModifications() {
        this.g.variables().set("will", (Object)"be read-only");
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{ReadOnlyStrategy.instance()});
        swg.variables().asMap().put("will", "not work");
    }

    private void assertException(ThrowingConsumer<Graph> stt) {
        try {
            StrategyGraph swg = this.g.strategy(new GraphStrategy[]{ReadOnlyStrategy.instance()});
            stt.accept((Object)swg);
            Assert.fail();
        }
        catch (Exception ex) {
            UnsupportedOperationException expectedException = ReadOnlyStrategy.Exceptions.graphUsesReadOnlyStrategy();
            Assert.assertEquals(expectedException.getClass(), ex.getClass());
            Assert.assertEquals((Object)expectedException.getMessage(), (Object)ex.getMessage());
        }
    }
}

