/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.structure.strategy;

import com.tinkerpop.gremlin.AbstractGremlinTest;
import com.tinkerpop.gremlin.FeatureRequirement;
import com.tinkerpop.gremlin.FeatureRequirementSet;
import com.tinkerpop.gremlin.process.graph.GraphTraversal;
import com.tinkerpop.gremlin.structure.Direction;
import com.tinkerpop.gremlin.structure.Edge;
import com.tinkerpop.gremlin.structure.Graph;
import com.tinkerpop.gremlin.structure.Property;
import com.tinkerpop.gremlin.structure.Vertex;
import com.tinkerpop.gremlin.structure.VertexProperty;
import com.tinkerpop.gremlin.structure.strategy.GraphStrategy;
import com.tinkerpop.gremlin.structure.strategy.SequenceStrategy;
import com.tinkerpop.gremlin.structure.strategy.StrategyContext;
import com.tinkerpop.gremlin.structure.strategy.StrategyEdge;
import com.tinkerpop.gremlin.structure.strategy.StrategyGraph;
import com.tinkerpop.gremlin.structure.strategy.StrategyProperty;
import com.tinkerpop.gremlin.structure.strategy.StrategyVariables;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertex;
import com.tinkerpop.gremlin.structure.strategy.StrategyVertexProperty;
import com.tinkerpop.gremlin.structure.strategy.StrategyWrapped;
import com.tinkerpop.gremlin.util.function.TriFunction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class SequenceStrategyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")
    public void shouldAppendMultiPropertyValuesToVertex() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working1"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working2"));
                    o.addAll(Arrays.asList("try", "anything"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return UnaryOperator.identity();
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working3"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((long)3L, (long)v.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"anonymous"}).toList().contains("working1"));
        Assert.assertTrue((boolean)v.values(new String[]{"anonymous"}).toList().contains("working2"));
        Assert.assertTrue((boolean)v.values(new String[]{"anonymous"}).toList().contains("working3"));
        Assert.assertEquals((Object)"anything", (Object)v.property("try").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldOverwritePropertyValuesToVertex() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working1"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.remove("anonymous");
                    o.remove("working1");
                    o.addAll(Arrays.asList("anonymous", "working2"));
                    o.addAll(Arrays.asList("try", "anything"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return UnaryOperator.identity();
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.remove("anonymous");
                    o.remove("working2");
                    o.addAll(Arrays.asList("anonymous", "working3"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((long)1L, (long)v.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"anonymous"}).toList().contains("working3"));
        Assert.assertEquals((Object)"anything", (Object)v.property("try").value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAllowForALocalGraphStrategyCallInSequence() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("ts", "timestamped"));
                    return (Vertex)f.apply(o.toArray());
                };
            }

            public <V> UnaryOperator<BiFunction<String, V, VertexProperty<V>>> getVertexPropertyStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
                return f -> (k, v) -> {
                    ((StrategyVertex)ctx.getCurrent()).getBaseVertex().property("timestamp", (Object)"timestamped");
                    StrategyContext innerCtx = new StrategyContext(ctx.getStrategyGraph(), (StrategyWrapped)ctx.getStrategyGraph());
                    ((Function)this.getAddVertexStrategy((StrategyContext<StrategyGraph>)innerCtx, composingStrategy).apply(arg_0 -> ((Graph)ctx.getStrategyGraph().getBaseGraph()).addVertex(arg_0))).apply(Arrays.asList("strategy", "bypassed").toArray());
                    return (VertexProperty)f.apply(k, v);
                };
            }
        }}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        v.property("set", (Object)"prop");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((long)1L, (long)v.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"ts"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"set"}).toList().contains("prop"));
        Vertex vStrat = (Vertex)this.g.V(new Object[0]).has("strategy", (Object)"bypassed").next();
        Assert.assertEquals((long)0L, (long)vStrat.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"ts"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"timestamp"}).toList().contains("timestamped"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAllowForANeighborhoodGraphStrategyCallInSequence() {
        SequenceStrategy innerSequenceStrategy = SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("ts1", "timestamped"));
                    return (Vertex)f.apply(o.toArray());
                };
            }

            public <V> UnaryOperator<BiFunction<String, V, VertexProperty<V>>> getVertexPropertyStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
                return f -> (k, v) -> {
                    ((StrategyVertex)ctx.getCurrent()).getBaseVertex().property("timestamp", (Object)"timestamped");
                    StrategyContext innerCtx = new StrategyContext(ctx.getStrategyGraph(), (StrategyWrapped)ctx.getStrategyGraph());
                    ((Function)composingStrategy.getAddVertexStrategy(innerCtx, composingStrategy).apply(arg_0 -> ((Graph)ctx.getStrategyGraph().getBaseGraph()).addVertex(arg_0))).apply(Arrays.asList("strategy", "bypassed").toArray());
                    return (VertexProperty)f.apply(k, v);
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("ts2", "timestamped"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create();
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, innerSequenceStrategy}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        v.property("set", (Object)"prop");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((long)1L, (long)v.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"ts1"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"ts2"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"set"}).toList().contains("prop"));
        Vertex vStrat = (Vertex)this.g.V(new Object[0]).has("strategy", (Object)"bypassed").next();
        Assert.assertEquals((long)0L, (long)vStrat.values(new String[]{"anonymous"}).toList().size());
        Assert.assertTrue((boolean)v.values(new String[]{"ts1"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"ts2"}).toList().contains("timestamped"));
        Assert.assertTrue((boolean)v.values(new String[]{"timestamp"}).toList().contains("timestamped"));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAlterArgumentsToAddVertexInOrderOfSequence() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working1"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.replaceAll(it -> it.equals("working1") ? "working2" : it);
                    o.addAll(Arrays.asList("try", "anything"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return UnaryOperator.identity();
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.replaceAll(it -> it.equals("working2") ? "working3" : it);
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"working3", (Object)v.property("anonymous").value());
        Assert.assertEquals((Object)"anything", (Object)v.property("try").value());
    }

    @Test(expected=RuntimeException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldShortCircuitStrategyWithException() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working1"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    throw new RuntimeException("test");
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working3"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        swg.addVertex(new Object[]{"any", "thing"});
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldShortCircuitStrategyWithNoOp() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working1"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> null;
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working3"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        Assert.assertNull((Object)swg.addVertex(new Object[]{"any", "thing"}));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDoSomethingBeforeAndAfter() {
        StrategyGraph swg = this.g.strategy(new GraphStrategy[]{SequenceStrategy.build().sequence(new GraphStrategy[]{new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    Vertex v = (Vertex)f.apply(args);
                    Assert.assertEquals((Object)"working2", (Object)v.property("anonymous").value());
                    v.properties(new String[]{"anonymous"}).remove();
                    v.property("anonymous", (Object)"working1");
                    return v;
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    Vertex v = (Vertex)f.apply(args);
                    Assert.assertEquals((Object)"working3", (Object)v.property("anonymous").value());
                    v.properties(new String[]{"anonymous"}).remove();
                    v.property("anonymous", (Object)"working2");
                    return v;
                };
            }
        }, new GraphStrategy(){

            public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext ctx, GraphStrategy composingStrategy) {
                return f -> args -> {
                    ArrayList<Object> o = new ArrayList<Object>(Arrays.asList(args));
                    o.addAll(Arrays.asList("anonymous", "working3"));
                    return (Vertex)f.apply(o.toArray());
                };
            }
        }}).create()});
        Vertex v = swg.addVertex(new Object[]{"any", "thing"});
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"working1", (Object)v.property("anonymous").value());
    }

    @Test
    public void shouldHaveAllMethodsImplemented() throws Exception {
        Method[] methods = GraphStrategy.class.getDeclaredMethods();
        SpyGraphStrategy spy = new SpyGraphStrategy();
        SequenceStrategy strategy = SequenceStrategy.build().sequence(new GraphStrategy[]{spy}).create();
        Stream.of(methods).forEach(method -> {
            try {
                method.invoke((Object)strategy, new StrategyContext(new StrategyGraph(this.g), new StrategyWrapped(){}), strategy);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)"Should be able to invoke function");
                throw new RuntimeException("fail");
            }
        });
        Assert.assertEquals((long)methods.length, (long)spy.getCount());
    }

    public class SpyGraphStrategy
    implements GraphStrategy {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        private UnaryOperator spy() {
            ++this.count;
            return UnaryOperator.identity();
        }

        public UnaryOperator<Function<Object[], Iterator<Vertex>>> getGraphIteratorsVertexIteratorStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Function<Object[], Iterator<Edge>>> getGraphIteratorsEdgeIteratorStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Function<Object[], Vertex>> getAddVertexStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<TriFunction<String, Vertex, Object[], Edge>> getAddEdgeStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Void>> getRemoveEdgeStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Void>> getRemoveVertexStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Void>> getRemovePropertyStrategy(StrategyContext<StrategyProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String, VertexProperty<V>>> getVertexGetPropertyStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String, Property<V>>> getEdgeGetPropertyStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<BiFunction<String, V, VertexProperty<V>>> getVertexPropertyStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<BiFunction<String, V, Property<V>>> getEdgePropertyStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Object>> getVertexIdStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Graph>> getVertexGraphStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Object>> getEdgeIdStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Graph>> getEdgeGraphStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<String>> getVertexLabelStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<String>> getEdgeLabelStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Set<String>>> getVertexKeysStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Set<String>>> getEdgeKeysStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String, V>> getVertexValueStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String, V>> getEdgeValueStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Set<String>>> getVariableKeysStrategy(StrategyContext<StrategyVariables> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <R> UnaryOperator<Function<String, Optional<R>>> getVariableGetStrategy(StrategyContext<StrategyVariables> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<BiConsumer<String, Object>> getVariableSetStrategy(StrategyContext<StrategyVariables> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Consumer<String>> getVariableRemoveStrategy(StrategyContext<StrategyVariables> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Map<String, Object>>> getVariableAsMapStrategy(StrategyContext<StrategyVariables> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Supplier<Void>> getGraphCloseStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String[], Iterator<VertexProperty<V>>>> getVertexIteratorsPropertyIteratorStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String[], Iterator<Property<V>>>> getEdgeIteratorsPropertyIteratorStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String[], Iterator<V>>> getVertexIteratorsValueIteratorStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Function<String[], Iterator<V>>> getEdgeIteratorsValueIteratorStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<BiFunction<Direction, String[], Iterator<Vertex>>> getVertexIteratorsVertexIteratorStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<BiFunction<Direction, String[], Iterator<Edge>>> getVertexIteratorsEdgeIteratorStrategy(StrategyContext<StrategyVertex> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Void>> getRemoveVertexPropertyStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Function<Direction, Iterator<Vertex>>> getEdgeIteratorsVertexIteratorStrategy(StrategyContext<StrategyEdge> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Object>> getVertexPropertyIdStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<String>> getVertexPropertyLabelStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Graph>> getVertexPropertyGraphStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Set<String>>> getVertexPropertyKeysStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<Vertex>> getVertexPropertyGetElementStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V, U> UnaryOperator<BiFunction<String, V, Property<V>>> getVertexPropertyPropertyStrategy(StrategyContext<StrategyVertexProperty<U>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V, U> UnaryOperator<Function<String[], Iterator<Property<V>>>> getVertexPropertyIteratorsPropertyIteratorStrategy(StrategyContext<StrategyVertexProperty<U>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V, U> UnaryOperator<Function<String[], Iterator<V>>> getVertexPropertyIteratorsValueIteratorStrategy(StrategyContext<StrategyVertexProperty<U>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Function<Object[], GraphTraversal<Vertex, Vertex>>> getGraphVStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public UnaryOperator<Function<Object[], GraphTraversal<Edge, Edge>>> getGraphEStrategy(StrategyContext<StrategyGraph> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<V>> getVertexPropertyValueStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<V>> getPropertyValueStrategy(StrategyContext<StrategyProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<String>> getVertexPropertyKeyStrategy(StrategyContext<StrategyVertexProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }

        public <V> UnaryOperator<Supplier<String>> getPropertyKeyStrategy(StrategyContext<StrategyProperty<V>> ctx, GraphStrategy composingStrategy) {
            return this.spy();
        }
    }
}

